/* gpgez.h
 * Copyright (C) 2005 Kazuyoshi Kakihara
 *
 * This file is part of JanusDG.
 *
 * JanusDG is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 */

#ifndef _GPGEZ_DLL_H_
#define _GPGEZ_DLL_H_

#include <windows.h>
#include <windowsx.h>
#include <commctrl.h>

typedef struct gpgez_passwordboxparam {
  LPTSTR szBuff;
  DWORD dwLen;
  LPCSTR szPrompt;
  LPCSTR szTitle;
} GPGEZ_PASSWORDBOXPARAM, *PGPGEZ_PASSWORDBOXPARAM;

typedef struct gpgez_keylist {
  LPSTR szUid;
  LPSTR szFpr;
  struct gpgez_keylist *pNext;
} GPGEZ_KEYLIST, *PGPGEZ_KEYLIST;

#define MAX_UID 256
#define MAX_FPR 256
#define MAX_NAME 64
#define MAX_EMAIL 256
#define MAX_COMMENT 64
#define MAX_PASSPHRASE 256
#define MAX_STRING 260
#define MAX_BUFF 4096

#ifdef _DEBUG
#define GPGEZDEBUG() \
  { \
    CHAR szMsg[MAX_PATH + 1]; \
    CHAR szBuff[MAX_PATH + 1]; \
    LPSTR p; \
    strcpy(szBuff, __FILE__); \
    p = strrchr(szBuff, '\\') + 1; \
    strcpy(szMsg, p); strcat(szMsg, " "); strcat(szMsg, itoa(__LINE__, szBuff, 10)); \
    MessageBox(NULL, szMsg, "Debug", MB_OK); \
  }
#else
#define GPGEZDEBUG() 
#endif


enum {
  ERR_NO_ERROR,
  ERR_USER_CANCEL,
  ERR_WARN_MAX,
  ERR_FAILED_TO_ALLOCATE_MEMORY,
  ERR_FAILED_TO_CREATE_STDIN_PIPE,
  ERR_FAILED_TO_DUPLICATE_STDIN_PIPE,
  ERR_FAILED_TO_CREATE_STDOUT_PIPE,
  ERR_FAILED_TO_DUPLICATE_STDOUT_PIPE,
  ERR_FAILED_TO_CREATE_STDERR_PIPE,
  ERR_FAILED_TO_DUPLICATE_STDERR_PIPE,
  ERR_FAILED_TO_CREATE_PROCESS,
  ERR_INVALID_USER_NAME_TOO_SHORT,
  ERR_INVALID_USER_NAME_FIRST_CHARACTER_IS_NUMERIC,
  ERR_INVALID_USER_NAME_ZENKAKU,
  ERR_INVALID_USER_NAME_ILLEGAL_CHARACTER,
  ERR_INVALID_EMAIL_ADDRESS_ILLEGAL_CHARACTER,
  ERR_INVALID_PASSPHRASE,
  ERR_TOO_SHORT_PASSPHRASE,
  ERR_FAILED_TO_CREATE_GPGHOME,
  ERR_FAILED_TO_OPEN_GPGHOME,
  ERR_FAILED_TO_CREATE_SECRING_FILE,
  ERR_FAILED_TO_CREATE_PUBRING_FILE,
  ERR_FAILED_TO_CONFIRM_PASSPHRASE,
  ERR_FAILED_TO_OPEN_INPUT_FILE,
  ERR_FAILED_TO_OPEN_OUTPUT_FILE,
  ERR_FAILED_TO_READ_FILE,
  ERR_NOT_EXIST_SECRING_FILE,
  ERR_NOT_EXIST_PUBRING_FILE,
  ERR_NOT_INITIALIZED_KEYLIST,
  ERR_ILLEGAL_PATH,
  ERR_BAD_PASSPHRASE,
  ERR_FAILED_TO_DELETE_KEY,
  ERR_FAILED_TO_ENCRYPT_FILE,
  ERR_FAILED_TO_SIGN_FILE,
  ERR_FAILED_TO_DECRYPT_FILE,
  ERR_FAILED_TO_VALIDATE_SIGN,
  ERR_EOF,
  ERR_READ_TOO_LONG_LINE,
  ERR_INVALID_INDIRECTION,
  ERR_ILLEGAL_INSTALLATION,
  ERR_NO_CONF_DIR,
  ERR_NOT_ALLOWED_MULTI_FILES,
  ERR_NOT_ALLOWED_TO_PROCESS_FOLDER,
  ERR_FAILED_TO_CREATE_KEY,
  ERR_ILLEGAL_PUBRING_FORMAT,
  ERR_ILLEGAL_SECRING_FORMAT,
  ERR_FAILED_TO_LOCK_MEMORY,
  ERR_FAILED_TO_OPEN_CLIPBOARD,
  ERR_DECRYPTED_BUT_FAILED_TO_VALIDATE_SIGN,
  ERR_FAILED_TO_WRITE_OPTION,
  ERR_FAILED_TO_READ_OPTION,
  ERR_UNKNOWN
};

DWORD gpgez_decrypt(LPCSTR szGpgHome, LPCSTR szSecring, LPCSTR szPubring, LPCSTR szFilePlain, LPCSTR szFileEncrypted, LPCSTR szPassphrase, LPDWORD lpdwStatus);
DWORD gpgez_encrypt(LPCSTR szGpgHome, LPCSTR szSecring, LPCSTR szPubring, LPCSTR szFilePlain, LPCSTR szFileEncrypted, LPCSTR zsFpr, LPCSTR szPassphrase, BOOL fNoSign, LPDWORD lpdwStatus);
DWORD gpgez_export(LPCSTR szGpgHome, LPCSTR szPubring, LPCSTR szFpr, LPCSTR szFileName);
DWORD gpgez_genkey(LPCSTR szGpgHome, LPCSTR szSecring, LPCSTR szPubring, LPCSTR szName, LPCSTR szEmail, LPCSTR szComment, LPCSTR szPassphrase, LPSTR szFpr, DWORD (*procProgress)(LPVOID));
DWORD gpgez_listkeys(LPCSTR szGpgHome, LPCSTR szPubring, PGPGEZ_KEYLIST pKeyList);
DWORD gpgez_listseckeys(LPCSTR szGpgHome, LPCSTR szSecring, PGPGEZ_KEYLIST pKeyList);
DWORD gpgez_get_myfpr(LPCSTR szGpgHome, LPCSTR szSecring, LPSTR szFpr);
DWORD gpgez_passwd(LPCSTR szGpgHome, LPCSTR szSecring, LPCSTR szPubring, LPCSTR szOldPassphrase, LPCSTR szNewPassphrase);
DWORD gpgez_sign(LPCSTR szGpgHome, LPCSTR szSecring, LPCSTR szPubring, LPCSTR szFileToSign, LPCSTR szFileSign, LPCSTR szPassphrase, LPDWORD lpdwStatus);
DWORD gpgez_verify(LPCSTR szGpgHome, LPCSTR szPubring, LPCSTR szFileToVerify, LPCSTR szFileSign, LPDWORD lpdwStatus);

VOID gpgez_TrimString(LPSTR szStr);
PSTR gpgez_strryen(PSTR pStr);
BOOL gpgez_PasswordBox(HWND hwnd, LPTSTR szBuff, DWORD dwLen, LPCSTR szPrompt, LPCSTR szTitle);
DWORD gpgez_listkey_add_node(PGPGEZ_KEYLIST pKeyList, LPCSTR szUid, LPCSTR szFpr);
DWORD gpgez_listkey_clear_node(PGPGEZ_KEYLIST pKeyList);
VOID gpgez_ShowErrorMessage(HWND hwnd, DWORD dwErr);

#endif
