/* gpgez_error.c
 * Copyright (C) 2005 Kazuyoshi Kakihara
 *
 * This file is part of JanusDG.
 *
 * JanusDG is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 */

#include "gpgez_error.h"
#include "resource.h"

extern HINSTANCE g_hInstance;

struct { DWORD dwErrCode; DWORD dwMsgId; } errmsg []= {
  {ERR_NO_ERROR, IDS_ERR_NO_ERROR},
  {ERR_FAILED_TO_ALLOCATE_MEMORY, IDS_ERR_FAILED_TO_ALLOCATE_MEMORY},
  {ERR_FAILED_TO_CREATE_STDIN_PIPE, IDS_ERR_FAILED_TO_CREATE_STDIN_PIPE},
  {ERR_FAILED_TO_DUPLICATE_STDIN_PIPE, IDS_ERR_FAILED_TO_DUPLICATE_STDIN_PIPE},
  {ERR_FAILED_TO_CREATE_STDOUT_PIPE, IDS_ERR_FAILED_TO_CREATE_STDOUT_PIPE},
  {ERR_FAILED_TO_DUPLICATE_STDOUT_PIPE, IDS_ERR_FAILED_TO_DUPLICATE_STDOUT_PIPE},
  {ERR_FAILED_TO_CREATE_STDERR_PIPE, IDS_ERR_FAILED_TO_CREATE_STDERR_PIPE},
  {ERR_FAILED_TO_DUPLICATE_STDERR_PIPE, IDS_ERR_FAILED_TO_DUPLICATE_STDERR_PIPE},
  {ERR_FAILED_TO_CREATE_PROCESS, IDS_ERR_FAILED_TO_CREATE_PROCESS},
  {ERR_INVALID_USER_NAME_TOO_SHORT, IDS_ERR_INVALID_USER_NAME_TOO_SHORT},
  {ERR_INVALID_USER_NAME_FIRST_CHARACTER_IS_NUMERIC, IDS_ERR_INVALID_USER_NAME_FIRST_CHARACTER_IS_NUMERIC},
  {ERR_INVALID_USER_NAME_ZENKAKU, IDS_ERR_INVALID_USER_NAME_ZENKAKU},
  {ERR_INVALID_USER_NAME_ILLEGAL_CHARACTER, IDS_ERR_INVALID_USER_NAME_ILLEGAL_CHARACTER},
  {ERR_INVALID_EMAIL_ADDRESS_ILLEGAL_CHARACTER, IDS_ERR_INVALID_EMAIL_ADDRESS_ILLEGAL_CHARACTER},
  {ERR_INVALID_PASSPHRASE, IDS_ERR_INVALID_PASSPHRASE},
  {ERR_TOO_SHORT_PASSPHRASE, IDS_ERR_TOO_SHORT_PASSPHRASE},
  {ERR_FAILED_TO_CREATE_GPGHOME, IDS_ERR_FAILED_TO_CREATE_GPGHOME},
  {ERR_FAILED_TO_OPEN_GPGHOME, IDS_ERR_FAILED_TO_OPEN_GPGHOME},
  {ERR_FAILED_TO_CREATE_SECRING_FILE, IDS_ERR_FAILED_TO_CREATE_SECRING_FILE},
  {ERR_FAILED_TO_CREATE_PUBRING_FILE, IDS_ERR_FAILED_TO_CREATE_PUBRING_FILE},
  {ERR_FAILED_TO_CONFIRM_PASSPHRASE, IDS_ERR_FAILED_TO_CONFIRM_PASSPHRASE},
  {ERR_FAILED_TO_OPEN_INPUT_FILE, IDS_ERR_FAILED_TO_OPEN_INPUT_FILE},
  {ERR_FAILED_TO_OPEN_OUTPUT_FILE, IDS_ERR_FAILED_TO_OPEN_OUTPUT_FILE},
  {ERR_FAILED_TO_READ_FILE, IDS_ERR_FAILED_TO_READ_FILE},
  {ERR_NOT_EXIST_SECRING_FILE, IDS_ERR_NOT_EXIST_SECRING_FILE},
  {ERR_NOT_EXIST_PUBRING_FILE, IDS_ERR_NOT_EXIST_PUBRING_FILE},
  {ERR_NOT_INITIALIZED_KEYLIST, IDS_ERR_NOT_INITIALIZED_KEYLIST},
  {ERR_USER_CANCEL, IDS_ERR_USER_CANCEL},
  {ERR_ILLEGAL_PATH, IDS_ERR_ILLEGAL_PATH},
  {ERR_BAD_PASSPHRASE, IDS_ERR_BAD_PASSPHRASE},
  {ERR_FAILED_TO_DELETE_KEY, IDS_ERR_FAILED_TO_DELETE_KEY},
  {ERR_FAILED_TO_ENCRYPT_FILE, IDS_ERR_FAILED_TO_ENCRYPT_FILE},
  {ERR_FAILED_TO_SIGN_FILE, IDS_ERR_FAILED_TO_SIGN_FILE},
  {ERR_FAILED_TO_DECRYPT_FILE, IDS_ERR_FAILED_TO_DECRYPT_FILE},
  {ERR_FAILED_TO_VALIDATE_SIGN, IDS_ERR_FAILED_TO_VALIDATE_SIGN},
  {ERR_EOF, IDS_ERR_EOF},
  {ERR_READ_TOO_LONG_LINE, IDS_ERR_READ_TOO_LONG_LINE},
  {ERR_INVALID_INDIRECTION, IDS_ERR_INVALID_INDIRECTION},
  {ERR_ILLEGAL_INSTALLATION, IDS_ERR_ILLEGAL_INSTALLATION},
  {ERR_NO_CONF_DIR, IDS_ERR_NO_CONF_DIR},
  {ERR_FAILED_TO_CREATE_KEY, IDS_ERR_FAILED_TO_CREATE_KEY},
  {ERR_NOT_ALLOWED_MULTI_FILES, IDS_ERR_NOT_ALLOWED_MULTI_FILES},
  {ERR_NOT_ALLOWED_TO_PROCESS_FOLDER, IDS_ERR_NOT_ALLOWED_TO_PROCESS_FOLDER},
  {ERR_ILLEGAL_PUBRING_FORMAT, IDS_ERR_ILLEGAL_PUBRING_FORMAT},
  {ERR_ILLEGAL_SECRING_FORMAT, IDS_ERR_ILLEGAL_SECRING_FORMAT},
  {ERR_FAILED_TO_LOCK_MEMORY, IDS_ERR_FAILED_TO_LOCK_MEMORY},
  {ERR_FAILED_TO_OPEN_CLIPBOARD, IDS_ERR_FAILED_TO_OPEN_CLIPBOARD},
  {ERR_DECRYPTED_BUT_FAILED_TO_VALIDATE_SIGN, IDS_ERR_DECRYPTED_BUT_FAILED_TO_VALIDATE_SIGN},
  {ERR_FAILED_TO_WRITE_OPTION, IDS_ERR_FAILED_TO_WRITE_OPTION},
  {ERR_FAILED_TO_READ_OPTION, IDS_ERR_FAILED_TO_READ_OPTION},
  {ERR_UNKNOWN, IDS_ERR_UNKNOWN},
};

DWORD
dwTranslateErrorCodeToString(DWORD dwErr, LPSTR szMsg, DWORD dwMsgMaxLen) {
	DWORD dwCnt;

	for (dwCnt = 0; errmsg[dwCnt].dwErrCode != ERR_UNKNOWN; dwCnt++) {
		if (errmsg[dwCnt].dwErrCode == dwErr) break;
	}
	LoadString(g_hInstance, errmsg[dwCnt].dwMsgId, szMsg, dwMsgMaxLen); 
	return ERR_NO_ERROR;
}
