/* gpgez_export.c
 * Copyright (C) 2005 Kazuyoshi Kakihara
 *
 * This file is part of JanusDG.
 *
 * JanusDG is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 */

#include "gpgez.h"
#include "gpgez_util.h"
#include "gpgez_rungpg.h"

/*------------------------------------------------------------*/
DWORD
gpgez_export(LPCSTR szGpgHome, LPCSTR szPubRing, LPCSTR szFpr, LPCSTR szFileName) {
  CHAR szCommandLineOptions[MAX_PATH * 4];
  DWORD dwErr;
  HANDLE hFile;

  if ((dwErr = gpgez_dwIsValidGpgHome(szGpgHome)) != ERR_NO_ERROR) return dwErr;
  if ((dwErr = gpgez_dwIsExistPubRing(szPubRing)) != ERR_NO_ERROR) return dwErr;

  /* GNX|[gt@CƓ̃t@Cɑ݂ꍇ͏*/
  hFile = CreateFile(szFileName, GENERIC_READ, 0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
  if (hFile != INVALID_HANDLE_VALUE) {
    CloseHandle(hFile);
    if (!DeleteFile(szFileName)) {
      GPGEZDEBUG();
      return ERR_UNKNOWN;
    }
  }

  if (_snprintf(szCommandLineOptions, sizeof(szCommandLineOptions),
          "%s --homedir=\"%s\" --keyring=\"%s\" --batch --yes --no-default-keyring -o \"%s\" --export %s",
                GPGCOMMANDLINE, szGpgHome, szPubRing, szFileName, szFpr) < 0) {
    GPGEZDEBUG();
    return ERR_UNKNOWN;
  }

  dwErr = gpgez_dwRunGpg(szCommandLineOptions, NULL, NULL);

  return (dwErr);
}
/*------------------------------------------------------------*/
