/* gpgez_listkeys.c
 * Copyright (C) 2005 Kazuyoshi Kakihara
 *
 * This file is part of JanusDG.
 *
 * JanusDG is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 */

#include "gpgez.h"
#include "gpgez_util.h"
#include "gpgez_rungpg.h"

DWORD _gpgez_dwProcListkeys(struct childprocess *pcp, LPVOID pBuff);

/*------------------------------------------------------------*/
DWORD
gpgez_listkeys(LPCSTR szGpgHome, LPCSTR szPubRing, PGPGEZ_KEYLIST pKeyList) {
  CHAR szCommandLineOptions[MAX_PATH * 4];
  DWORD dwErr;
  
  if ((dwErr = gpgez_dwIsValidGpgHome(szGpgHome)) != ERR_NO_ERROR) return dwErr;
  if ((dwErr = gpgez_dwIsExistPubRing(szPubRing)) != ERR_NO_ERROR) return dwErr;
  if (pKeyList->pNext) {
    GPGEZDEBUG();
    return ERR_NOT_INITIALIZED_KEYLIST;
  }
  
  if (_snprintf(szCommandLineOptions, sizeof(szCommandLineOptions), 
          "%s --homedir=\"%s\" --keyring=\"%s\" --batch --no-default-keyring --list-keys --with-colons --with-fingerprint",
                GPGCOMMANDLINE, szGpgHome, szPubRing) < 0) {
    GPGEZDEBUG();
    return ERR_UNKNOWN;
  }
  
  dwErr = gpgez_dwRunGpg(szCommandLineOptions, _gpgez_dwProcListkeys, (LPVOID)pKeyList);
  
  return (dwErr);
}

/*------------------------------------------------------------*/
DWORD
_gpgez_dwProcListkeys(struct childprocess *pcp, LPVOID pBuff) {
  PGPGEZ_KEYLIST pKeyList;
  CHAR szUid[MAX_UID + 1] = "";
  CHAR szFpr[MAX_FPR + 1] = "";
  DWORD dwErr;
  CHAR szLine[MAX_STDLINE + 1];
  INT iCnt;
  PCHAR pSrc;
  PCHAR pDst;

  pKeyList = (PGPGEZ_KEYLIST)pBuff;

  do {
    dwErr = gpgez_dwReadFileLine(pcp->hStdOut, szLine, MAX_STDLINE);
    if ((dwErr != ERR_NO_ERROR) && (dwErr != ERR_EOF) && (dwErr != ERR_READ_TOO_LONG_LINE)) break;

    if (!strncmp("pub:", szLine, strlen("pub:"))) {
      if (strlen(szUid) > 0) {
        /* JanusDGgĂA2ȏpub:邱Ƃ͂Ȃ */
        GPGEZDEBUG();
        dwErr = ERR_ILLEGAL_PUBRING_FORMAT;
        gpgez_dwProcStdOutDefault(pcp, NULL);
        break;
      }
      pSrc = szLine;
      for (iCnt = 0; iCnt < 9; iCnt++) { pSrc = strchr(pSrc, ':') + 1; }
      pDst = strchr(pSrc, ':');
      if (pDst - pSrc >= MAX_UID) {
        GPGEZDEBUG();
        dwErr = ERR_ILLEGAL_PUBRING_FORMAT;
        gpgez_dwProcStdOutDefault(pcp, NULL);
        break;
      }
      strncpy(szUid, pSrc, pDst - pSrc);
      szUid[pDst - pSrc] = '\0';
    } else if (!strncmp("fpr:", szLine, strlen("fpr:"))) {
      if (strlen(szFpr) > 0) {
        GPGEZDEBUG();
        dwErr = ERR_ILLEGAL_PUBRING_FORMAT;
        gpgez_dwProcStdOutDefault(pcp, NULL);
        break;
      }
      pSrc = szLine;
      for (iCnt = 0; iCnt < 9; iCnt++) { pSrc = strchr(pSrc, ':') + 1; }
      pDst = strchr(pSrc, ':');
      if (pDst - pSrc >= MAX_FPR) {
        GPGEZDEBUG();
        dwErr = ERR_ILLEGAL_PUBRING_FORMAT;
        gpgez_dwProcStdOutDefault(pcp, NULL);
        break;
      }
      strncpy(szFpr, pSrc, pDst - pSrc);
      szFpr[pDst - pSrc] = '\0';
    } else if (!strncmp("sub:", szLine, strlen("sub:"))) {
    }
    if (dwErr == ERR_EOF) {
      if (strlen(szUid) > 0) {
        dwErr = gpgez_listkey_add_node(pKeyList, szUid, szFpr);
        if (dwErr != ERR_NO_ERROR) {
          break;
        }
      }
      dwErr = ERR_NO_ERROR;
      break;
    }
  } while (TRUE);
  if (dwErr != ERR_NO_ERROR) gpgez_listkey_clear_node(pKeyList);
  return (dwErr);
}

/*------------------------------------------------------------*/

