/* gpgez_listseckeys.c
 * Copyright (C) 2005 Kazuyoshi Kakihara
 *
 * This file is part of JanusDG.
 *
 * JanusDG is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 */

#include "gpgez.h"
#include "gpgez_util.h"
#include "gpgez_rungpg.h"

DWORD _gpgez_dwProcListSeckeys(struct childprocess *pcp, LPVOID pBuff);

/*------------------------------------------------------------*/
DWORD
gpgez_get_myfpr(LPCSTR szGpgHome, LPCSTR szSecring, LPSTR szFpr) {
  GPGEZ_KEYLIST KeyList;
  DWORD dwErr;

  KeyList.szUid = NULL;
  KeyList.szFpr = NULL;
  KeyList.pNext = NULL;

  dwErr = gpgez_listseckeys(szGpgHome, szSecring, &KeyList);
  if (KeyList.pNext == NULL) {
    GPGEZDEBUG();
    return ERR_ILLEGAL_SECRING_FORMAT;
  }
  if (dwErr != ERR_NO_ERROR) {
    gpgez_listkey_clear_node(&KeyList);
    return dwErr;
  }
  if ((KeyList.pNext)->pNext) {
    gpgez_listkey_clear_node(&KeyList);
    GPGEZDEBUG();
    return ERR_ILLEGAL_SECRING_FORMAT;
  }
  strcpy(szFpr, (KeyList.pNext)->szFpr);
  gpgez_listkey_clear_node(&KeyList);
  return ERR_NO_ERROR;
}

/*------------------------------------------------------------*/
DWORD
gpgez_listseckeys(LPCSTR szGpgHome, LPCSTR szSecRing, PGPGEZ_KEYLIST pKeyList) {
  CHAR szCommandLineOptions[MAX_PATH * 4];
  DWORD dwErr;

  if ((dwErr = gpgez_dwIsValidGpgHome(szGpgHome)) != ERR_NO_ERROR) return dwErr;
  if ((dwErr = gpgez_dwIsExistSecRing(szSecRing)) != ERR_NO_ERROR) return dwErr;
  if (pKeyList->pNext) {
    GPGEZDEBUG();
    return ERR_NOT_INITIALIZED_KEYLIST;
  }

  if (_snprintf(szCommandLineOptions, sizeof(szCommandLineOptions),
          "%s --homedir=\"%s\" --secret-keyring=\"%s\" --batch --no-default-keyring --list-secret-keys --with-colons --with-fingerprint",
                GPGCOMMANDLINE, szGpgHome, szSecRing) < 0) {
    GPGEZDEBUG();
    return ERR_UNKNOWN;
  }

  dwErr = gpgez_dwRunGpg(szCommandLineOptions, _gpgez_dwProcListSeckeys, (LPVOID)pKeyList);

  return (dwErr);
}

/*------------------------------------------------------------*/
DWORD
_gpgez_dwProcListSeckeys(struct childprocess *pcp, LPVOID pBuff) {
  PGPGEZ_KEYLIST pKeyList;
  CHAR szUid[MAX_UID + 1] = "";
  CHAR szFpr[MAX_FPR + 1] = "";
  DWORD dwErr;
  CHAR szLine[MAX_STDLINE + 1];
  INT iCnt;
  PCHAR pSrc;
  PCHAR pDst;

  pKeyList = (PGPGEZ_KEYLIST)pBuff;

  do {
    dwErr = gpgez_dwReadFileLine(pcp->hStdOut, szLine, MAX_STDLINE);
    if ((dwErr != ERR_NO_ERROR) && (dwErr != ERR_EOF) && (dwErr != ERR_READ_TOO_LONG_LINE)) break;

    if (!strncmp("sec:", szLine, strlen("sec:"))) {
      if (strlen(szUid) > 0) {
        /* JanusDGgĂA2ȏsec:邱Ƃ͂Ȃ */
        GPGEZDEBUG();
        dwErr = ERR_ILLEGAL_SECRING_FORMAT;
        gpgez_dwProcStdOutDefault(pcp, NULL);
        break;
      }
      pSrc = szLine;
      for (iCnt = 0; iCnt < 9; iCnt++) { pSrc = strchr(pSrc, ':') + 1; }
      pDst = strchr(pSrc, ':');
      if (pDst - pSrc >= MAX_UID) {
        GPGEZDEBUG();
        dwErr = ERR_ILLEGAL_SECRING_FORMAT;
        gpgez_dwProcStdOutDefault(pcp, NULL);
        break;
      }
      strncpy(szUid, pSrc, pDst - pSrc);
      szUid[pDst - pSrc] = '\0';
    } else if (!strncmp("fpr:", szLine, strlen("fpr:"))) {
      if (strlen(szFpr) > 0) {
        /* JanusDGgĂA2ȏfpr:邱Ƃ͂Ȃ */
        GPGEZDEBUG();
        dwErr = ERR_ILLEGAL_SECRING_FORMAT;
        gpgez_dwProcStdOutDefault(pcp, NULL);
        break;
      }
      pSrc = szLine;
      for (iCnt = 0; iCnt < 9; iCnt++) { pSrc = strchr(pSrc, ':') + 1; }
      pDst = strchr(pSrc, ':');
      if (pDst - pSrc >= MAX_FPR) {
        GPGEZDEBUG();
        dwErr = ERR_ILLEGAL_SECRING_FORMAT;
        gpgez_dwProcStdOutDefault(pcp, NULL);
        break;
      }
      strncpy(szFpr, pSrc, pDst - pSrc);
      szFpr[pDst - pSrc] = '\0';
    } else if (!strncmp("ssb:", szLine, strlen("ssb:"))) {
    }
    if (dwErr == ERR_EOF) {
      if (strlen(szUid) > 0) {
        dwErr = gpgez_listkey_add_node(pKeyList, szUid, szFpr);
        if (dwErr != ERR_NO_ERROR) {
          break;
        }
      }
      dwErr = ERR_NO_ERROR;
      break;
    }
  } while (TRUE);
  if (dwErr != ERR_NO_ERROR) gpgez_listkey_clear_node(pKeyList);
  return (dwErr);
}

/*------------------------------------------------------------*/

