/* gpgez_rungpg.c
 * Copyright (C) 2005 Kazuyoshi Kakihara
 *
 * This file is part of JanusDG.
 *
 * JanusDG is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 */

#include "gpgez_rungpg.h"

extern HINSTANCE g_hInstance;

struct pipehandles {
  HANDLE hPipeIR; /* stdin Read piqǂނj*/
  HANDLE hPipeIW; /* stdin Write pȂieނj */
  HANDLE hPipeOR; /* stdout Read pȂ ieǂނj */
  HANDLE hPipeOW; /* stdout Write piqނj*/
  HANDLE hPipeER; /* stderr Read pȂieǂނj */
  HANDLE hPipeEW; /* stderr Write piqނj*/
  HANDLE hStdInOld;
  HANDLE hStdOutOld;
  HANDLE hStdErrOld;
};

/*------------------------------------------------------------*/
VOID
InitPipeHandles(struct pipehandles *pph) {
  pph->hPipeIR = NULL;
  pph->hPipeIW = NULL;
  pph->hPipeOR = NULL;
  pph->hPipeOW = NULL;
  pph->hPipeER = NULL;
  pph->hPipeEW = NULL;
  pph->hStdInOld = GetStdHandle(STD_INPUT_HANDLE);
  pph->hStdOutOld = GetStdHandle(STD_OUTPUT_HANDLE);
  pph->hStdErrOld = GetStdHandle(STD_ERROR_HANDLE);
  return;
}

/*------------------------------------------------------------*/
VOID
ClosePipeHandles(struct pipehandles *pph) {
  SetStdHandle(STD_INPUT_HANDLE, pph->hStdInOld);
  SetStdHandle(STD_OUTPUT_HANDLE, pph->hStdOutOld);
  SetStdHandle(STD_ERROR_HANDLE, pph->hStdErrOld);
  CloseHandleClean(pph->hPipeIR);
  CloseHandleClean(pph->hPipeIW);
  CloseHandleClean(pph->hPipeOR);
  CloseHandleClean(pph->hPipeOW);
  CloseHandleClean(pph->hPipeER);
  CloseHandleClean(pph->hPipeEW);
  return;
}

/*------------------------------------------------------------*/
DWORD
dwCreateStdInPipe(LPHANDLE phPipeInR, LPHANDLE phPipeInW) {
  SECURITY_ATTRIBUTES sa;
  HANDLE hPipeIW0;

  sa.nLength = sizeof(SECURITY_ATTRIBUTES);
  sa.lpSecurityDescriptor = NULL;
  sa.bInheritHandle = TRUE;

  if (!CreatePipe(phPipeInR, &hPipeIW0, &sa, 0)) {
    GPGEZDEBUG();
    return ERR_FAILED_TO_CREATE_STDIN_PIPE;
  }
  if (!DuplicateHandle(GetCurrentProcess(), hPipeIW0, GetCurrentProcess(), phPipeInW, 0, FALSE, DUPLICATE_SAME_ACCESS)) {
    CloseHandleClean(hPipeIW0);
    GPGEZDEBUG();
    return ERR_FAILED_TO_DUPLICATE_STDIN_PIPE;
  }
  CloseHandleClean(hPipeIW0);
  return ERR_NO_ERROR;
}

/*------------------------------------------------------------*/
DWORD
dwCreateStdOutPipe(LPHANDLE phPipeOutR, LPHANDLE phPipeOutW) {
  SECURITY_ATTRIBUTES sa;
  HANDLE hPipeOR0;

  sa.nLength = sizeof(SECURITY_ATTRIBUTES);
  sa.lpSecurityDescriptor = NULL;
  sa.bInheritHandle = TRUE;

  if (!CreatePipe(&hPipeOR0, phPipeOutW, &sa, 0)) {
    GPGEZDEBUG();
    return ERR_FAILED_TO_CREATE_STDOUT_PIPE;
  }
  if (!DuplicateHandle(GetCurrentProcess(), hPipeOR0, GetCurrentProcess(), phPipeOutR, 0, FALSE, DUPLICATE_SAME_ACCESS)) {
    CloseHandleClean(hPipeOR0);
    GPGEZDEBUG();
    return ERR_FAILED_TO_DUPLICATE_STDOUT_PIPE;
  }
  CloseHandleClean(hPipeOR0);
  return ERR_NO_ERROR;
}

/*------------------------------------------------------------*/
DWORD
dwCreateStdErrPipe(LPHANDLE phPipeErrR, LPHANDLE phPipeErrW) {
  SECURITY_ATTRIBUTES sa;
  HANDLE hPipeER0;

  sa.nLength = sizeof(SECURITY_ATTRIBUTES);
  sa.lpSecurityDescriptor = NULL;
  sa.bInheritHandle = TRUE;

  if (!CreatePipe(&hPipeER0, phPipeErrW, &sa, 0)) {
    GPGEZDEBUG();
    return ERR_FAILED_TO_CREATE_STDERR_PIPE;
  }
  if (!DuplicateHandle(GetCurrentProcess(), hPipeER0, GetCurrentProcess(), phPipeErrR, 0, FALSE, DUPLICATE_SAME_ACCESS)) {
    CloseHandleClean(hPipeER0);
    GPGEZDEBUG();
    return ERR_FAILED_TO_DUPLICATE_STDERR_PIPE;
  }
  CloseHandleClean(hPipeER0);
  return ERR_NO_ERROR;
}

/*------------------------------------------------------------*/
DWORD
gpgez_dwProcStdOutDefault(struct childprocess *pcp, LPVOID pBuff) {
  DWORD dwRead;
  CHAR szBuff[MAX_PATH];
  DWORD dwErr;

  while (TRUE) {
    if (!ReadFile(pcp->hStdOut, szBuff, MAX_PATH, &dwRead, NULL)) {
      if (GetLastError() != ERROR_BROKEN_PIPE) {
        GPGEZDEBUG();
        dwErr = ERR_UNKNOWN;
        break;
      } else {
        dwErr = ERR_NO_ERROR;
        break;
      }
    }
  }
  return dwErr;
}

/*------------------------------------------------------------*/
DWORD
gpgez_dwRunGpg(LPCSTR szCommandLineOptions, DWORD (*dwProcStdOut)(struct childprocess *pcp, LPVOID pBuff), LPVOID pBuff) {
  struct pipehandles ph;
  struct childprocess cp;
  CHAR szGpgCommandFileName[MAX_PATH + 1];
  CHAR szHomeDirectoryName[MAX_PATH + 1];
  STARTUPINFO si;
  PROCESS_INFORMATION pi;
  DWORD dwErr = ERR_NO_ERROR;

  InitPipeHandles(&ph);
  if ((dwErr = dwCreateStdInPipe(&(ph.hPipeIR), &(ph.hPipeIW))) != ERR_NO_ERROR) {
    ClosePipeHandles(&ph);
    return dwErr;
  }
  if ((dwErr = dwCreateStdOutPipe(&(ph.hPipeOR), &(ph.hPipeOW))) != ERR_NO_ERROR) {
    ClosePipeHandles(&ph);
    return dwErr;
  }

  ZeroMemory(&si, sizeof(STARTUPINFO));
  si.cb = sizeof(STARTUPINFO);
  si.dwFlags = STARTF_USESTDHANDLES | STARTF_USESHOWWINDOW;
  si.wShowWindow = SW_HIDE;
  si.hStdInput = ph.hPipeIR;
  si.hStdOutput = ph.hPipeOW;
  si.hStdError = GetStdHandle(STD_ERROR_HANDLE);

  GetModuleFileName(NULL, szHomeDirectoryName, MAX_PATH);
  *(gpgez_strryen(szHomeDirectoryName) + 1) = '\0';
  strcpy(szGpgCommandFileName, szHomeDirectoryName);
  strcat(szGpgCommandFileName, GPGBINDIR);
  strcat(szGpgCommandFileName, "\\");
  strcat(szGpgCommandFileName, GPGCOMMAND);

  if (!CreateProcess(szGpgCommandFileName, (LPTSTR)szCommandLineOptions, NULL, NULL, TRUE, 0, NULL, szHomeDirectoryName, &si, &pi)) {
    ClosePipeHandles(&ph);
    GPGEZDEBUG();
    return ERR_FAILED_TO_CREATE_PROCESS;
  }
  CloseHandle(pi.hThread);
  cp.hProcess = pi.hProcess;
  cp.hStdIn = ph.hPipeIW;
  cp.hStdOut = ph.hPipeOR;
  cp.hStdErr = NULL;

  CloseHandleClean(ph.hPipeIR);
  CloseHandleClean(ph.hPipeOW);
  if (!dwProcStdOut) dwProcStdOut = gpgez_dwProcStdOutDefault;
  dwErr = (*dwProcStdOut)(&cp, pBuff);
  WaitForSingleObject(pi.hProcess, INFINITE);
  CloseHandle(pi.hProcess);
  if (!cp.hStdIn) ph.hPipeIW = NULL;
  if (!cp.hStdOut) ph.hPipeOR = NULL;
  if (!cp.hStdErr) ph.hPipeER = NULL;
  ClosePipeHandles(&ph);

  return dwErr;
}

/*------------------------------------------------------------*/
