/* gpgez_sign.c
 * Copyright (C) 2005 Kazuyoshi Kakihara
 *
 * This file is part of JanusDG.
 *
 * JanusDG is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 */

#include "gpgez.h"
#include "gpgez_util.h"
#include "gpgez_rungpg.h"

#define GPGMSG_BAD_PASSPHRASE "BAD_PASSPHRASE"
#define GPGMSG_SIG_CREATED "SIG_CREATED"

#define STATUS_SIGNED 1

struct gpgez_sign_params {
  LPDWORD lpdwStatus;
  LPCSTR szPassphrase;
};

DWORD _gpgez_dwProcSign(struct childprocess *pcp, LPVOID pBuff);


DWORD
gpgez_sign(LPCSTR szGpgHome, LPCSTR szSecRing, LPCSTR szPubRing, LPCSTR szFileToSign, LPCSTR szFileSign, LPCSTR szPassphrase, LPDWORD lpdwStatus) {
  CHAR szCommandLineOptions[MAX_PATH * 7];
  struct gpgez_sign_params gep;
  DWORD dwErr;
  
  if ((dwErr = gpgez_dwIsValidGpgHome(szGpgHome)) != ERR_NO_ERROR) return dwErr;
  if ((dwErr = gpgez_dwIsExistSecRing(szSecRing)) != ERR_NO_ERROR) return dwErr;
  if ((dwErr = gpgez_dwIsExistPubRing(szPubRing)) != ERR_NO_ERROR) return dwErr;
  
  if (_snprintf(szCommandLineOptions, sizeof(szCommandLineOptions),
          "%s --homedir=\"%s\" --secret-keyring=\"%s\" --keyring=\"%s\" --batch --yes --always-trust --passphrase-fd=0 --detach-sign -o \"%s\" \"%s\"",
                GPGCOMMANDLINE, szGpgHome, szSecRing, szPubRing, szFileSign, szFileToSign) < 0) {
    GPGEZDEBUG();
    return ERR_UNKNOWN;
  }
  
  gep.lpdwStatus = lpdwStatus;
  gep.szPassphrase = szPassphrase;
  
  *(gep.lpdwStatus) = 0;
  dwErr = gpgez_dwRunGpg(szCommandLineOptions, _gpgez_dwProcSign, (LPVOID)&gep);

  if (dwErr != ERR_NO_ERROR) {
    return (dwErr);
  }
  if (!(*lpdwStatus & STATUS_SIGNED)) {
    GPGEZDEBUG();
    dwErr = ERR_FAILED_TO_SIGN_FILE;
  }
  return (dwErr);
}

/*------------------------------------------------------------*/
DWORD
_gpgez_dwProcSign(struct childprocess *pcp, LPVOID pBuff) {
  struct gpgez_sign_params *pgep;
  DWORD dwErr;
  CHAR szLine[MAX_STDLINE + 1];

  pgep = (struct gpgez_sign_params *)pBuff;

  gpgez_bWritePipe(pcp->hStdIn, pgep->szPassphrase);
  gpgez_bWritePipe(pcp->hStdIn, "\r\n");
  do {
    dwErr = gpgez_dwReadFileLine(pcp->hStdOut, szLine, MAX_STDLINE);
    if ((dwErr != ERR_NO_ERROR) && (dwErr != ERR_EOF) && (dwErr != ERR_READ_TOO_LONG_LINE)) break;

    if (gpgez_bIsGnupgMessage(szLine, GPGMSG_BAD_PASSPHRASE)) {
      GPGEZDEBUG();
      dwErr = ERR_BAD_PASSPHRASE;
      gpgez_dwProcStdOutDefault(pcp, NULL);
      break;
    }
    if (gpgez_bIsGnupgMessage(szLine, GPGMSG_SIG_CREATED)) {
      *(pgep->lpdwStatus) = *(pgep->lpdwStatus) | STATUS_SIGNED;
    }
    if (dwErr == ERR_EOF) {
      dwErr = ERR_NO_ERROR;
      break;
    }
  } while (TRUE);
  return (dwErr);
}

/*------------------------------------------------------------*/
