/* gpgez_util.h
 * Copyright (C) 2005 Kazuyoshi Kakihara
 *
 * This file is part of JanusDG.
 *
 * JanusDG is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 */

#ifndef _GPGEZ_UTIL_H_
#define _GPGEZ_UTIL_H_

#include <windows.h>
#include <windowsx.h>
#include <commctrl.h>

#include "gpgez.h"

#define CloseHandleClean(h) if (h) {CloseHandle((h));(h) = NULL;}
#define ADD_MEMORY_UNIT 1028

#define GPGCOMMAND "gpg.exe"
#define GPGHOMEDIR "conf"
#define GPGBINDIR "bin"

#define MAX_STDLINE 256

BOOL gpgez_bWritePipe(HANDLE hPipe, LPCSTR szBuff);
DWORD gpgez_dwReadFileLine(HANDLE hPipe, LPSTR szBuff, DWORD dwMaxLen);
BOOL gpgez_bIsGnupgMessage(LPCSTR szBuff, LPCSTR szMessageLabel);

DWORD gpgez_dwIsValidGpgHome(LPCSTR szGpgHomeDir);
DWORD gpgez_dwIsExistSecRing(LPCSTR szSecring);
DWORD gpgez_dwIsExistPubRing(LPCSTR szPubring);
DWORD gpgez_dwIsInitializeSecRing(LPCSTR szSecring);
DWORD gpgez_dwIsInitializePubRing(LPCSTR szPubring);
DWORD gpgez_dwIsValidPassphrase(LPCSTR szPassphrase);
DWORD gpgez_dwIsValidName(LPCSTR szName);
DWORD gpgez_dwIsValidEmail(LPCSTR szEmail);

#define GPGEZ_CMDLINE_ADDSTRING(b, s) if (gpgez_addStringBufferSZ((b), (s)) < 0) {gpgez_freeStringBuffer((b)); return (ERR_FAILED_TO_ALLOCATE_MEMORY);}

#endif