/* gpgez_verify.c
 * Copyright (C) 2005 Kazuyoshi Kakihara
 *
 * This file is part of JanusDG.
 *
 * JanusDG is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 */

#include "gpgez.h"
#include "gpgez_util.h"
#include "gpgez_rungpg.h"

#define STATUS_VALIDSIGN 1

#define GPGMSG_VALIDSIG "VALIDSIG"
#define GPGMSG_BAD_PASSPHRASE "BAD_PASSPHRASE"

struct gpgez_verify_params {
  LPDWORD lpdwStatus;
  LPCSTR szPassphrase;
};

DWORD _gpgez_dwProcVerify(struct childprocess *pcp, LPVOID pBuff);

/*------------------------------------------------------------*/
DWORD
gpgez_verify(LPCSTR szGpgHome, LPCSTR szPubRing, LPCSTR szFileToVerify, LPCSTR szFileSign, LPDWORD lpdwStatus) {
  CHAR szCommandLineOptions[MAX_PATH * 7];
  struct gpgez_verify_params gvp;
  DWORD dwErr;
  
  if ((dwErr = gpgez_dwIsValidGpgHome(szGpgHome)) != ERR_NO_ERROR) return dwErr;
  if ((dwErr = gpgez_dwIsExistPubRing(szPubRing)) != ERR_NO_ERROR) return dwErr;
  
  if (_snprintf(szCommandLineOptions, sizeof(szCommandLineOptions),
          "%s --homedir=\"%s\" --keyring=\"%s\" --no-default-keyring --batch --yes --always-trust --status-fd=1 --verify \"%s\" \"%s\"",
                GPGCOMMANDLINE, szGpgHome, szPubRing, szFileSign, szFileToVerify) < 0) {
    GPGEZDEBUG();
    return ERR_UNKNOWN;
  }
  
  gvp.lpdwStatus = lpdwStatus;
  /*	gdp.szPassphrase = szPassphrase; */
  
  *(gvp.lpdwStatus) = 0;
  dwErr = gpgez_dwRunGpg(szCommandLineOptions, _gpgez_dwProcVerify, (LPVOID)&gvp);
  
  if (!(*lpdwStatus & STATUS_VALIDSIGN)) {
    GPGEZDEBUG();
    dwErr = ERR_FAILED_TO_VALIDATE_SIGN;
  }
  return (dwErr);
}

/*------------------------------------------------------------*/
DWORD
_gpgez_dwProcVerify(struct childprocess *pcp, LPVOID pBuff) {
  struct gpgez_verify_params *pgvp;
  DWORD dwErr;
  CHAR szLine[MAX_STDLINE + 1];
  
  pgvp = (struct gpgez_verify_params *)pBuff;
  
  do {
    dwErr = gpgez_dwReadFileLine(pcp->hStdOut, szLine, MAX_STDLINE);
    if ((dwErr != ERR_NO_ERROR) && (dwErr != ERR_EOF) && (dwErr != ERR_READ_TOO_LONG_LINE)) break;
    
    if (gpgez_bIsGnupgMessage(szLine, GPGMSG_BAD_PASSPHRASE)) {
      GPGEZDEBUG();
      dwErr = ERR_BAD_PASSPHRASE;
      gpgez_dwProcStdOutDefault(pcp, NULL);
      break;
    }
    if (gpgez_bIsGnupgMessage(szLine, GPGMSG_VALIDSIG)) {
      *(pgvp->lpdwStatus) = *(pgvp->lpdwStatus) | STATUS_VALIDSIGN;
    }
    if (dwErr == ERR_EOF) {
      dwErr = ERR_NO_ERROR;
      break;
    }
  } while (TRUE);
  return (dwErr);
}

/*------------------------------------------------------------*/
