/* gpgezw.h
 * Copyright (C) 2005 Kazuyoshi Kakihara
 *
 * This file is part of JanusDG.
 *
 * JanusDG is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 */

#ifndef _GPGEZW_H_
#define _GPGEZW_H_

#define _WIN32_WINNT 0x400
#define WINVER 0x400

#define GPGEZW_PUBKEY_FOLDER "pubkey"
#define GPGEZW_EXT_ENCRYPTED ".gpg"
#define GPGEZW_EXT_SIGN ".sig"
#define GPGEZW_EXT_KEY ".gpg"
#define GPGEZW_DEFAULT_KEYFILE_NAME "pubkey.gpg"
#define GPGEZW_OFN_FILTER_ENCRYPTED "gpg Files(*.gpg)\0*.gpg\0All Files(*.*)\0*.*\0\0"
#define GPGEZW_OFN_FILTER_KEY "gpg Files(*.gpg)\0*.gpg\0All Files(*.*)\0*.*\0\0"
#define GPGEZW_OFN_FILTER_SIGN "sig Files(*.sig)\0*.sig\0All Files(*.*)\0*.*\0\0"
#define GPGEZW_OPTION_ENCRYPT_NO_SIGN 1
#define GPGEZW_OPTION_DECRYPT_NO_VERIFY 2

#include <windows.h>
#include <commctrl.h>
#include <windowsx.h>

#include "gpgez.h"

typedef struct {
  CHAR szGpgHome[MAX_PATH + 1];
  CHAR szSecRing[MAX_PATH + 1];
  CHAR szPubRing[MAX_PATH + 1];
  CHAR szPassphrase[MAX_PASSPHRASE + 1];
  BOOL fEncryptNoSign;
  BOOL fDecryptNoVerify;
} GPGEZPARAM, *PGPGEZPARAM;

DWORD gpgezw_dwDecrypt(HWND hwnd, PGPGEZPARAM pgp, LPSTR lpCmdLine);
DWORD gpgezw_dwEncrypt(HWND hwnd, PGPGEZPARAM pgp, LPSTR lpCmdLine);
DWORD gpgezw_dwExportMyKey(HWND hwnd, PGPGEZPARAM pgp, LPCSTR lpCmdLine);
DWORD gpgezw_dwInitialize(HWND hwnd, PGPGEZPARAM pgp, LPCSTR lpCmdLine);
DWORD gpgezw_dwShowMyFpr(HWND hwnd, PGPGEZPARAM pgp, LPCSTR lpCmdLine);
DWORD gpgezw_dwSign(HWND hwnd, PGPGEZPARAM pgp, LPCSTR lpCmdLine);
DWORD gpgezw_dwVerify(HWND hwnd, PGPGEZPARAM pgp, LPCSTR lpCmdLine);
DWORD gpgezw_dwViewKey(HWND hwnd, PGPGEZPARAM pgp, LPCSTR lpCmdLine);
DWORD gpgezw_dwPassphrase(HWND hwnd, PGPGEZPARAM pgp, LPCSTR lpCmdLine);

#endif
