/* gpgezw_dec.c
 * Copyright (C) 2005 Kazuyoshi Kakihara
 *
 * This file is part of JanusDG.
 *
 * JanusDG is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 */

#include "gpgezw.h"

#include "resource.h"

extern HINSTANCE g_hInstance;

/*------------------------------------------------------------*/
DWORD
_gpgezw_decrypt_dwGetEncryptedFileName(HWND hwnd, LPSTR szEncryptedFileName) {
  OPENFILENAME ofn;
  CHAR szBuff[MAX_STRING + 1];

  LoadString(g_hInstance, IDS_STRING_WDECRYPT_WINDOW_TITLE_ENCRYPTED, szBuff, MAX_STRING);
  
  ZeroMemory(&ofn, sizeof(OPENFILENAME));
  ofn.lStructSize = sizeof(OPENFILENAME);
  ofn.hwndOwner = hwnd;
  ofn.lpstrFilter = GPGEZW_OFN_FILTER_ENCRYPTED;
  ofn.lpstrFile = szEncryptedFileName;
  ofn.lpstrTitle = szBuff;
  ofn.nMaxFile = MAX_PATH;
  ofn.Flags = OFN_FILEMUSTEXIST;
  if (GetOpenFileName(&ofn)) return ERR_NO_ERROR;
  else return ERR_USER_CANCEL;
}

/*------------------------------------------------------------*/
DWORD
_gpgezw_decrypt_dwGetPubkeyFileName(HWND hwnd, LPSTR szPubkeyFileName) {
  OPENFILENAME ofn;
  CHAR szBuff[MAX_STRING + 1];
  CHAR szInitialDir[MAX_PATH + 1];

  GetModuleFileName(NULL, szInitialDir, MAX_PATH);
  *(gpgez_strryen(szInitialDir) + 1) = '\0';
  strcat(szInitialDir, GPGEZW_PUBKEY_FOLDER);
  strcat(szInitialDir, "\\");

  LoadString(g_hInstance, IDS_STRING_WDECRYPT_WINDOW_TITLE_PUBKEYFILE, szBuff, MAX_STRING);

  ZeroMemory(&ofn, sizeof(OPENFILENAME));
  ofn.lStructSize = sizeof(OPENFILENAME);
  ofn.hwndOwner = hwnd;
  ofn.lpstrFilter = GPGEZW_OFN_FILTER_KEY;
  ofn.lpstrFile = szPubkeyFileName;
  ofn.lpstrTitle = szBuff;
  ofn.lpstrInitialDir = szInitialDir;
  ofn.nMaxFile = MAX_PATH;
  ofn.Flags = OFN_FILEMUSTEXIST | OFN_NOCHANGEDIR;
  if (GetOpenFileName(&ofn)) return ERR_NO_ERROR;
  else return ERR_USER_CANCEL;
}

/*------------------------------------------------------------*/
DWORD
_gpgezw_decrypt_dwGetPlainFileName(HWND hwnd, LPSTR szPlainFileName) {
  OPENFILENAME ofn;
  CHAR szBuff[MAX_STRING + 1];
  
  LoadString(g_hInstance, IDS_STRING_WDECRYPT_WINDOW_TITLE_PLAIN, szBuff, MAX_STRING);

  ZeroMemory(&ofn, sizeof(OPENFILENAME));
  ofn.lStructSize = sizeof(OPENFILENAME);
  ofn.hwndOwner = hwnd;
  ofn.lpstrFilter = "All Files(*.*)\0*.*\0\0";
  ofn.lpstrFile = szPlainFileName;
  ofn.lpstrTitle = szBuff;
  ofn.nMaxFile = MAX_PATH;
  ofn.Flags = OFN_OVERWRITEPROMPT;
  if (GetSaveFileName(&ofn)) return ERR_NO_ERROR;
  else return ERR_USER_CANCEL;
}

/*------------------------------------------------------------*/
DWORD
_gpgezw_decrypt_dwDecryptFile(PGPGEZPARAM pgp, LPCSTR szPlainFileName, LPCSTR szPublicKeyFileName, LPCSTR szEncryptedFileName) {
  CHAR szPubRing[MAX_PATH + 1];
  DWORD dwStatus = 0;
  DWORD dwErr;
  HCURSOR hOldCursor;

  if (strlen(szPublicKeyFileName)== 0) {
    strcpy(szPubRing, pgp->szPubRing);
  } else {
    strcpy(szPubRing, szPublicKeyFileName);
  }
  
  hOldCursor = SetCursor(LoadCursor(NULL, IDC_WAIT));
  dwErr = gpgez_decrypt(pgp->szGpgHome, pgp->szSecRing, szPubRing, szPlainFileName, szEncryptedFileName, pgp->szPassphrase, &dwStatus);
  SetCursor(hOldCursor);
  
  return dwErr;
}

/*------------------------------------------------------------*/
DWORD
gpgezw_dwDecrypt(HWND hwnd, PGPGEZPARAM pgp, LPSTR lpFileName) {
  DWORD dwErr;
  CHAR szPlainFileName[MAX_PATH + 1];
  CHAR szPubkeyFileName[MAX_PATH + 1];
  CHAR szEncryptedFileName[MAX_PATH + 1];

/*
	Íꂽt@Cw
*/
  if (!lpFileName) {
    ZeroMemory(szEncryptedFileName, MAX_PATH);
    if ((dwErr = _gpgezw_decrypt_dwGetEncryptedFileName(hwnd, szEncryptedFileName)) != ERR_NO_ERROR) {
      return dwErr;
    }
  } else {
    strcpy(szEncryptedFileName, lpFileName);
  }

/*
	̌؂Ɏgp錮t@Cw
*/
  if (pgp->fDecryptNoVerify) {
    strcpy(szPubkeyFileName, "");
  } else {
    ZeroMemory(szPubkeyFileName, MAX_PATH);
    if ((dwErr = _gpgezw_decrypt_dwGetPubkeyFileName(hwnd, szPubkeyFileName)) != ERR_NO_ERROR) {
      return dwErr;
    }
  }

/*
	̃t@Cw
*/
  if (strlen(szEncryptedFileName) > strlen(GPGEZW_EXT_ENCRYPTED) + 1) {
    strcpy(szPlainFileName, szEncryptedFileName);
    if (!(stricmp(szPlainFileName + strlen(szPlainFileName) - 4, GPGEZW_EXT_ENCRYPTED))) {
      *(szPlainFileName + strlen(szPlainFileName) - 4) = '\0';
    }
  } else {
    ZeroMemory(szPlainFileName, MAX_PATH);
  }
  if ((dwErr = _gpgezw_decrypt_dwGetPlainFileName(hwnd, szPlainFileName)) != ERR_NO_ERROR) {
    return dwErr;
  }

/*
	s
*/
  dwErr = _gpgezw_decrypt_dwDecryptFile(pgp, szPlainFileName, szPubkeyFileName, szEncryptedFileName);

/*
	ؗpt@Cw肳ĂȂꍇ́A؂ɎsĂNO_ERRORƂ
*/
  if ((strlen(szPubkeyFileName) == 0) && (dwErr == ERR_DECRYPTED_BUT_FAILED_TO_VALIDATE_SIGN))
    dwErr = ERR_NO_ERROR;
  
  if (dwErr != ERR_NO_ERROR) {
    return dwErr;
  }
  
  return ERR_NO_ERROR;
}

/*------------------------------------------------------------*/
