/* gpgezw_enc.c
 * Copyright (C) 2005 Kazuyoshi Kakihara
 *
 * This file is part of JanusDG.
 *
 * JanusDG is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 */

#include "gpgezw.h"

#include "resource.h"

extern HINSTANCE g_hInstance;

/*------------------------------------------------------------*/
DWORD
_gpgezw_encrypt_dwGetPlainFileName(HWND hwnd, LPSTR szPlainFileName) {
  OPENFILENAME ofn;
  CHAR szBuff[MAX_STRING + 1];

  LoadString(g_hInstance, IDS_STRING_WENCRYPT_WINDOW_TITLE_PLAINFILE, szBuff, MAX_STRING);
  
  ZeroMemory(&ofn, sizeof(OPENFILENAME));
  ofn.lStructSize = sizeof(OPENFILENAME);
  ofn.hwndOwner = hwnd;
  ofn.lpstrFilter = "All Files(*.*)\0*.*\0\0";
  ofn.lpstrFile = szPlainFileName;
  ofn.lpstrTitle = szBuff;
  ofn.nMaxFile = MAX_PATH;
  ofn.Flags = OFN_FILEMUSTEXIST;
  if (GetOpenFileName(&ofn)) return ERR_NO_ERROR;
  else return ERR_USER_CANCEL;
}

/*------------------------------------------------------------*/
DWORD
_gpgezw_encrypt_dwGetPubkeyFileName(HWND hwnd, LPSTR szPubkeyFileName) {
  OPENFILENAME ofn;
  CHAR szBuff[MAX_STRING + 1];
  CHAR szInitialDir[MAX_PATH + 1];

  GetModuleFileName(NULL, szInitialDir, MAX_PATH);
  *(gpgez_strryen(szInitialDir) + 1) = '\0';
  strcat(szInitialDir, GPGEZW_PUBKEY_FOLDER);
  strcat(szInitialDir, "\\");

  LoadString(g_hInstance, IDS_STRING_WENCRYPT_WINDOW_TITLE_PUBKEYFILE, szBuff, MAX_STRING);

  ZeroMemory(&ofn, sizeof(OPENFILENAME));
  ofn.lStructSize = sizeof(OPENFILENAME);
  ofn.hwndOwner = hwnd;
  ofn.lpstrFilter = GPGEZW_OFN_FILTER_KEY;
  ofn.lpstrFile = szPubkeyFileName;
  ofn.lpstrTitle = szBuff;
  ofn.lpstrInitialDir = szInitialDir;
  ofn.nMaxFile = MAX_PATH;
  ofn.Flags = OFN_FILEMUSTEXIST | OFN_NOCHANGEDIR;
  if (GetOpenFileName(&ofn)) return ERR_NO_ERROR;
  else return ERR_USER_CANCEL;
}

/*------------------------------------------------------------*/
DWORD
_gpgezw_encrypt_dwGetEncryptedFileName(HWND hwnd, LPSTR szEncryptedFileName) {
  OPENFILENAME ofn;
  CHAR szBuff[MAX_STRING + 1];
  
  LoadString(g_hInstance, IDS_STRING_WENCRYPT_WINDOW_TITLE_ENCRYPTED, szBuff, MAX_STRING);
  
  ZeroMemory(&ofn, sizeof(OPENFILENAME));
  ofn.lStructSize = sizeof(OPENFILENAME);
  ofn.hwndOwner = hwnd;
  ofn.lpstrFilter = "All Files(*.*)\0*.*\0\0";
  ofn.lpstrFile = szEncryptedFileName;
  ofn.lpstrTitle = szBuff;
  ofn.nMaxFile = MAX_PATH;
  ofn.Flags = OFN_OVERWRITEPROMPT;
  if (GetSaveFileName(&ofn)) return ERR_NO_ERROR;
  else return ERR_USER_CANCEL;
}

/*------------------------------------------------------------*/
DWORD
_gpgezw_encrypt_dwEncryptFile(PGPGEZPARAM pgp, LPCSTR szPlainFileName, LPCSTR szPublickeyFileName, LPCSTR szEncryptedFileName) {
  CHAR szFpr[MAX_FPR + 1];
  GPGEZ_KEYLIST KeyList;
  DWORD dwStatus = 0;
  DWORD dwErr;
  HCURSOR hOldCursor;

  KeyList.szUid = NULL;
  KeyList.szFpr = NULL;
  KeyList.pNext = NULL;
  dwErr = gpgez_listkeys(pgp->szGpgHome, szPublickeyFileName, &KeyList);
  if (KeyList.pNext == NULL) {
    GPGEZDEBUG();
    return ERR_ILLEGAL_PUBRING_FORMAT;
  }
  if (dwErr != ERR_NO_ERROR) {
    gpgez_listkey_clear_node(&KeyList);
    return dwErr;
  }
  if ((KeyList.pNext)->pNext) {
    gpgez_listkey_clear_node(&KeyList);
    GPGEZDEBUG();
    return ERR_ILLEGAL_PUBRING_FORMAT;
  }
  strcpy(szFpr, (KeyList.pNext)->szFpr);
  gpgez_listkey_clear_node(&KeyList);

  hOldCursor = SetCursor(LoadCursor(NULL, IDC_WAIT));
  dwErr = gpgez_encrypt(pgp->szGpgHome, pgp->szSecRing, szPublickeyFileName, szPlainFileName, szEncryptedFileName, szFpr, pgp->szPassphrase, pgp->fEncryptNoSign, &dwStatus);
  SetCursor(hOldCursor);

  return dwErr;
}

/*------------------------------------------------------------*/
DWORD
gpgezw_dwEncrypt(HWND hwnd, PGPGEZPARAM pgp, LPSTR lpFileName) {
  DWORD dwErr;
  CHAR szPlainFileName[MAX_PATH + 1];
  CHAR szPubkeyFileName[MAX_PATH + 1];
  CHAR szEncryptedFileName[MAX_PATH + 1];

/*
	Ít@Cw
*/
  if (!lpFileName) {
    ZeroMemory(szPlainFileName, MAX_PATH);
    if ((dwErr = _gpgezw_encrypt_dwGetPlainFileName(hwnd, szPlainFileName)) != ERR_NO_ERROR) {
      return dwErr;
    }
  } else {
    strcpy(szPlainFileName, lpFileName);
  }

/*
	gp錮t@Cw
*/
  ZeroMemory(szPubkeyFileName, MAX_PATH);
  if ((dwErr = _gpgezw_encrypt_dwGetPubkeyFileName(hwnd, szPubkeyFileName)) != ERR_NO_ERROR) {
    return dwErr;
  }

/*
	Í̃t@Cw
*/
  if (strlen(szPlainFileName) < (MAX_PATH - strlen(GPGEZW_EXT_ENCRYPTED))) {
    strcpy(szEncryptedFileName, szPlainFileName);
    strcat(szEncryptedFileName, GPGEZW_EXT_ENCRYPTED);
  } else {
    ZeroMemory(szEncryptedFileName, MAX_PATH);
  }
  if ((dwErr = _gpgezw_encrypt_dwGetEncryptedFileName(hwnd, szEncryptedFileName)) != ERR_NO_ERROR) {
    return dwErr;
  }

  dwErr = _gpgezw_encrypt_dwEncryptFile(pgp, szPlainFileName, szPubkeyFileName, szEncryptedFileName);
  if ((pgp->fEncryptNoSign) && (dwErr == ERR_FAILED_TO_SIGN_FILE))
    dwErr = ERR_NO_ERROR;

  if (dwErr != ERR_NO_ERROR) {
    return dwErr;
  }
  
  return ERR_NO_ERROR;
}
/*------------------------------------------------------------*/
