/* gpgezw_export_mykey.c
 * Copyright (C) 2005 Kazuyoshi Kakihara
 *
 * This file is part of JanusDG.
 *
 * JanusDG is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 */

#include "gpgezw.h"

#include "resource.h"

extern HINSTANCE g_hInstance;

/*------------------------------------------------------------*/
BOOL
_gpgezw_exportmykey_GetSaveMyPubKeyFileName(HWND hwnd, LPSTR szFileName) {
  OPENFILENAME ofn;

  ZeroMemory(&ofn, sizeof(OPENFILENAME));
  ofn.lStructSize = sizeof(OPENFILENAME);
  ofn.hwndOwner = hwnd;
  ofn.lpstrFilter = GPGEZW_OFN_FILTER_KEY;
  ofn.lpstrFile = szFileName;
  ofn.nMaxFile = MAX_PATH;
  ofn.Flags = OFN_OVERWRITEPROMPT;
  ofn.lpstrDefExt = "gpg";
  ofn.nMaxFileTitle = 64;
  ofn.lpstrFileTitle = NULL;
  ofn.lpstrTitle = NULL;
  return(GetSaveFileName(&ofn));
}

/*------------------------------------------------------------*/
DWORD
gpgezw_dwExportMyKey(HWND hwnd, PGPGEZPARAM pgp, LPCSTR lpFileName) {
  CHAR szFpr[MAX_FPR + 1];
  CHAR szUid[MAX_UID + 1];
  CHAR szEMail[MAX_EMAIL + 1];
  LPSTR szLt, szGt;
  GPGEZ_KEYLIST KeyList;
  CHAR szFileName[MAX_PATH + 1];
  DWORD dwErr;

  KeyList.szUid = NULL;
  KeyList.szFpr = NULL;
  KeyList.pNext = NULL;

  dwErr = gpgez_listseckeys(pgp->szGpgHome, pgp->szSecRing, &KeyList);
  if (dwErr != ERR_NO_ERROR) {
    GPGEZDEBUG();
    return dwErr;
  }
  if (KeyList.pNext == NULL) {
    GPGEZDEBUG();
    return ERR_ILLEGAL_SECRING_FORMAT;
  }
  if ((KeyList.pNext)->pNext) {
    gpgez_listkey_clear_node(&KeyList);
    return ERR_ILLEGAL_SECRING_FORMAT;
  }
  strcpy(szFpr, (KeyList.pNext)->szFpr);
  strcpy(szUid, (KeyList.pNext)->szUid);
  gpgez_listkey_clear_node(&KeyList);

  if ((szLt = strchr(szUid, '<')) && (szGt = strchr(szLt, '>'))) {
    strncpy(szEMail, szLt + 1, szGt - szLt - 1);
    *(szEMail + (szGt - szLt - 1)) = '\0';
    strcpy(szFileName, szEMail);
    strcat(szFileName, GPGEZW_EXT_KEY);
  } else {
    strcpy(szEMail, GPGEZW_DEFAULT_KEYFILE_NAME);
  }

  if (!_gpgezw_exportmykey_GetSaveMyPubKeyFileName(hwnd, szFileName))
    return ERR_USER_CANCEL;

  dwErr = gpgez_export(pgp->szGpgHome, pgp->szPubRing, szFpr, szFileName);
  if (dwErr != ERR_NO_ERROR) {
    return dwErr;
  }

  return ERR_NO_ERROR;
}

/*------------------------------------------------------------*/
