/* gpgezw_genkey.c
 * Copyright (C) 2005 Kazuyoshi Kakihara
 *
 * This file is part of JanusDG.
 *
 * JanusDG is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 */

#include "gpgezw.h"

#include "resource.h"

extern HINSTANCE g_hInstance;

/*------------------------------------------------------------*/
DWORD _gpgezw_genkey_dwGenerateGPGKeys(HWND);

BOOL _gpgezw_genkey_Cls_OnInitDialog(HWND, HWND, LPARAM);
VOID _gpgezw_genkey_Cls_OnClose(HWND);
VOID _gpgezw_genkey_Cls_OnCommand(HWND, int, HWND, UINT);

HWND g_hwndGenkey;

/*------------------------------------------------------------*/
DWORD
_gpgezw_procProgress(LPVOID lpBuff) {
  int *piCnt;

  piCnt = (int *)lpBuff;
  SendMessage(GetDlgItem(g_hwndGenkey, IDC_PROGRESS1), PBM_STEPIT, 0, 0L);
  if (*piCnt = 0) {
    SendMessage(GetDlgItem(g_hwndGenkey, IDC_PROGRESS1), PBM_SETPOS, 0, 0L);
  }
  UpdateWindow(g_hwndGenkey);
  return 0;
}

/*------------------------------------------------------------*/
DWORD
_gpgezw_genkey_dwGenerateGPGKeys(HWND hwnd) {
  CHAR szName[MAX_NAME + 1];
  CHAR szEmail[MAX_EMAIL + 1];
  CHAR szComment[MAX_COMMENT + 1];
  CHAR szPassphrase[MAX_PASSPHRASE + 1];
  CHAR szPassphrase2[MAX_PASSPHRASE + 1];
  CHAR szFingerPrint[MAX_FPR + 1];
  CHAR szBuff[MAX_STRING + 1];
  PGPGEZPARAM pgp;
  DWORD dwErr;
  HCURSOR hOldCursor;

  Edit_GetText(GetDlgItem(hwnd, IDC_WGENKEY_SETUP_NAME), szName, MAX_NAME);
  gpgez_TrimString(szName);

  Edit_GetText(GetDlgItem(hwnd, IDC_WGENKEY_SETUP_EMAIL), szEmail, MAX_EMAIL);
  gpgez_TrimString(szEmail);

  strcpy(szComment, "");

  pgp = (PGPGEZPARAM)GetWindowLong(hwnd, GWL_USERDATA);

  Edit_GetText(GetDlgItem(hwnd, IDC_WGENKEY_SETUP_PASSPHRASE), szPassphrase, MAX_PASSPHRASE);

  Edit_GetText(GetDlgItem(hwnd, IDC_WGENKEY_SETUP_PASSPHRASE2), szPassphrase2, MAX_PASSPHRASE);
  if (strcmp(szPassphrase, szPassphrase2)) return ERR_FAILED_TO_CONFIRM_PASSPHRASE;

  strcpy(pgp->szPassphrase, szPassphrase);

  Edit_Enable(GetDlgItem(hwnd, IDC_WGENKEY_SETUP_NAME), FALSE);
  Edit_Enable(GetDlgItem(hwnd, IDC_WGENKEY_SETUP_EMAIL), FALSE);
  Edit_Enable(GetDlgItem(hwnd, IDC_WGENKEY_SETUP_PASSPHRASE), FALSE);
  Edit_Enable(GetDlgItem(hwnd, IDC_WGENKEY_SETUP_PASSPHRASE2), FALSE);
  Button_Enable(GetDlgItem(hwnd, IDOK), FALSE);
  Button_Enable(GetDlgItem(hwnd, IDCANCEL), FALSE);
  
  hOldCursor = SetCursor(LoadCursor(NULL, IDC_WAIT));
  dwErr = gpgez_genkey(pgp->szGpgHome, pgp->szSecRing, pgp->szPubRing, szName, szEmail, szComment, pgp->szPassphrase, szFingerPrint, _gpgezw_procProgress);
  SetCursor(hOldCursor);

  if (dwErr == ERR_NO_ERROR) {
    SendMessage(GetDlgItem(hwnd, IDC_PROGRESS1), PBM_SETPOS, 100, 0);
    UpdateWindow(hwnd);

    LoadString(g_hInstance, IDS_STRING_WGENKEY_MESSAGE_KEY_ASK_EXPORT, szBuff, MAX_STRING);
    if (MessageBox(hwnd, szBuff, "Message Box", MB_YESNO|MB_ICONQUESTION) == IDYES) {
      dwErr = gpgezw_dwExportMyKey(hwnd, pgp, "");
      if (dwErr == ERR_USER_CANCEL) {
        dwErr = ERR_NO_ERROR;
      }
    }
  }

  Edit_Enable(GetDlgItem(hwnd, IDC_WGENKEY_SETUP_NAME), TRUE);
  Edit_Enable(GetDlgItem(hwnd, IDC_WGENKEY_SETUP_EMAIL), TRUE);
  Edit_Enable(GetDlgItem(hwnd, IDC_WGENKEY_SETUP_PASSPHRASE), TRUE);
  Edit_Enable(GetDlgItem(hwnd, IDC_WGENKEY_SETUP_PASSPHRASE2), TRUE);
  Button_Enable(GetDlgItem(hwnd, IDOK), TRUE);
  Button_Enable(GetDlgItem(hwnd, IDCANCEL), TRUE);
  return dwErr;
}

/*------------------------------------------------------------*/
BOOL
_gpgezw_genkey_Cls_OnInitDialog(HWND hwnd, HWND hwndFocus, LPARAM lParam) {
  PGPGEZPARAM pgp;

  g_hwndGenkey = hwnd;
  pgp = (PGPGEZPARAM)lParam;
  SetWindowLong(hwnd, GWL_USERDATA, (LONG)pgp);
  Edit_LimitText(GetDlgItem(hwnd, IDC_WGENKEY_SETUP_NAME), MAX_NAME);
  Edit_LimitText(GetDlgItem(hwnd, IDC_WGENKEY_SETUP_EMAIL), MAX_EMAIL);
  Edit_LimitText(GetDlgItem(hwnd, IDC_WGENKEY_SETUP_PASSPHRASE), MAX_PASSPHRASE);
  Edit_LimitText(GetDlgItem(hwnd, IDC_WGENKEY_SETUP_PASSPHRASE2), MAX_PASSPHRASE);
  SendMessage(GetDlgItem(hwnd, IDC_PROGRESS1), PBM_SETRANGE, 0, MAKELPARAM(0, 100));
  SendMessage(GetDlgItem(hwnd, IDC_PROGRESS1), PBM_SETSTEP, 1, 0L);
  return TRUE;
}

/*------------------------------------------------------------*/
void
_gpgezw_genkey_Cls_OnClose(HWND hwnd) {
  PostMessage(hwnd, WM_COMMAND, IDCANCEL, 0);
  return;
}

/*------------------------------------------------------------*/
void
_gpgezw_genkey_Cls_OnCommand(HWND hwnd, int id, HWND hwndCtl, UINT codeNotify) {
  DWORD dwErr;

  switch(id) {
  case IDOK:
    dwErr = _gpgezw_genkey_dwGenerateGPGKeys(hwnd);
    if (dwErr != ERR_NO_ERROR) {
      gpgez_ShowErrorMessage(hwnd, dwErr);
    } else {
      EndDialog(hwnd, (INT)ERR_NO_ERROR);
    }
    break;
  case IDCANCEL:
    EndDialog(hwnd, (INT)ERR_USER_CANCEL);
    break;
  }
}

/*------------------------------------------------------------*/
int CALLBACK
_gpgezw_genkey_procDialog(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam) {
  switch (uMsg) {
    HANDLE_MSG(hDlg, WM_INITDIALOG, _gpgezw_genkey_Cls_OnInitDialog);
    HANDLE_MSG(hDlg, WM_CLOSE, _gpgezw_genkey_Cls_OnClose);
    HANDLE_MSG(hDlg, WM_COMMAND, _gpgezw_genkey_Cls_OnCommand);
  default:
    return FALSE;
  }
  return TRUE;
}

/*------------------------------------------------------------*/
DWORD
gpgezw_dwInitialize(HWND hwnd, PGPGEZPARAM pgp, LPCSTR lpCmdLine) {
  DWORD dwErr;

  dwErr = (DWORD) DialogBoxParam(g_hInstance, MAKEINTRESOURCE(IDD_DIALOG_WGENKEY_SETUP), hwnd, _gpgezw_genkey_procDialog, (LPARAM)pgp);
  return dwErr;
}

/*------------------------------------------------------------*/
