/* gpgezw_passphrase.c
 * Copyright (C) 2005 Kazuyoshi Kakihara
 *
 * This file is part of JanusDG.
 *
 * JanusDG is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 */

#include "gpgezw.h"

#include "resource.h"

extern HINSTANCE g_hInstance;

/*------------------------------------------------------------*/
DWORD gpgezw_dwPassphrase(HWND hwnd, PGPGEZPARAM pgp, LPCSTR lpCmdLine) {
  CHAR szWindowTitle[MAX_STRING + 1];
  CHAR szWindowPrompt[MAX_STRING + 1];
  CHAR szPassphraseOld[MAX_PATH + 1];
  CHAR szPassphraseNew[MAX_PATH + 1];
  CHAR szPassphraseToConfirm[MAX_PATH + 1];
  DWORD dwErr;

  LoadString(g_hInstance, IDS_STRING_WPASS_OLD_PASSPHRASE_WINDOW_TITLE, szWindowTitle, MAX_STRING);
  LoadString(g_hInstance, IDS_STRING_WPASS_OLD_PASSPHRASE_WINDOW_PROMPT, szWindowPrompt, MAX_STRING);
  if (!gpgez_PasswordBox(hwnd, szPassphraseOld, MAX_PATH, szWindowPrompt, szWindowTitle))
    return ERR_USER_CANCEL;

  LoadString(g_hInstance, IDS_STRING_WPASS_NEW_PASSPHRASE_WINDOW_TITLE, szWindowTitle, MAX_STRING);
  LoadString(g_hInstance, IDS_STRING_WPASS_NEW_PASSPHRASE_WINDOW_PROMPT, szWindowPrompt, MAX_STRING);
  if (!gpgez_PasswordBox(hwnd, szPassphraseNew, MAX_PATH, szWindowPrompt, szWindowTitle))
    return ERR_USER_CANCEL;

  LoadString(g_hInstance, IDS_STRING_WPASS_CONFIRM_PASSPHRASE_WINDOW_TITLE, szWindowTitle, MAX_STRING);
  LoadString(g_hInstance, IDS_STRING_WPASS_CONFIRM_PASSPHRASE_WINDOW_PROMPT, szWindowPrompt, MAX_STRING);
  if (!gpgez_PasswordBox(hwnd, szPassphraseToConfirm, MAX_PATH, szWindowPrompt, szWindowTitle))
    return ERR_USER_CANCEL;

  if (strcmp(szPassphraseNew, szPassphraseToConfirm)) {
    GPGEZDEBUG();
    return ERR_FAILED_TO_CONFIRM_PASSPHRASE;
  }

  dwErr = gpgez_passwd(pgp->szGpgHome, pgp->szSecRing, pgp->szPubRing, szPassphraseOld, szPassphraseNew);
  if (dwErr != ERR_NO_ERROR) {
    return dwErr;
  }
  strcpy(pgp->szPassphrase, szPassphraseNew);

  return dwErr;
}

/*------------------------------------------------------------*/
