/* gpgezw_show_myfpr.c
 * Copyright (C) 2005 Kazuyoshi Kakihara
 *
 * This file is part of JanusDG.
 *
 * JanusDG is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 */

#include "gpgezw.h"

#include "resource.h"

extern HINSTANCE g_hInstance;

/*------------------------------------------------------------*/
DWORD
_gpgezw_showmyfpr_show_myfpr(HWND hwnd, LPCSTR szFpr){
  CHAR szPreamble[MAX_STRING + 1];
  CHAR szConfirm[MAX_STRING + 1];
  CHAR szMessage[MAX_STRING * 4 + 1];
  INT iCnt;
  HGLOBAL hMem;
  LPSTR szClipboardText;
  DWORD dwErr = ERR_NO_ERROR;

  strcpy(szMessage, "");
  LoadString(g_hInstance, IDS_STRING_WSHOWMYFPR_PREAMBLE, szPreamble, MAX_STRING);
  strcat(szMessage, szPreamble);
  strcat(szMessage, "\n\n");
  for (iCnt = 0; iCnt < 5; iCnt++) {
    strncat(szMessage, szFpr + iCnt * 4, 4);
    strcat(szMessage, " ");
  }
  strcat(szMessage, " ");
  for (iCnt = 0; iCnt < 5; iCnt++) {
    strncat(szMessage, szFpr + 20 + iCnt * 4, 4);
    strcat(szMessage, " ");
  }
  strcat(szMessage, "\n\n");
  LoadString(g_hInstance, IDS_STRING_WSHOWMYFPR_CONFIRM_TO_COPY, szConfirm, MAX_STRING);
  strcat(szMessage, szConfirm);
  
  if (MessageBox(hwnd, szMessage, "Message Box", MB_YESNO) == IDYES) {
    if ((hMem = GlobalAlloc(GMEM_MOVEABLE, strlen(szFpr) + 1))) {
      if ((szClipboardText = GlobalLock(hMem))) {
        strcpy(szClipboardText, szFpr);
        GlobalUnlock(hMem);
        if (OpenClipboard(NULL)) {
          EmptyClipboard();
          SetClipboardData(CF_TEXT, hMem);
          CloseClipboard();
        } else {
          GPGEZDEBUG();
          dwErr = ERR_FAILED_TO_OPEN_CLIPBOARD;
          GlobalFree(hMem);
        }
      } else {
        GPGEZDEBUG();
        dwErr = ERR_FAILED_TO_LOCK_MEMORY;
        GlobalFree(hMem);
      }
    } else {
      GPGEZDEBUG();
      dwErr = ERR_FAILED_TO_ALLOCATE_MEMORY;
    }
  }
  return dwErr;
}
/*------------------------------------------------------------*/
DWORD
gpgezw_dwShowMyFpr(HWND hwnd, PGPGEZPARAM pgp, LPCSTR lpCmdLine) {
  CHAR szFpr[MAX_FPR + 1];
  DWORD dwErr;

  dwErr = gpgez_get_myfpr(pgp->szGpgHome, pgp->szSecRing, szFpr);
  if (dwErr != ERR_NO_ERROR) {
    return dwErr;
  }

  dwErr = _gpgezw_showmyfpr_show_myfpr(hwnd, szFpr);

  return dwErr;
}

/*------------------------------------------------------------*/
