/* gpgezw_sign.c
 * Copyright (C) 2005 Kazuyoshi Kakihara
 *
 * This file is part of JanusDG.
 *
 * JanusDG is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 */

#include "gpgezw.h"

#include "resource.h"

extern HINSTANCE g_hInstance;

/*------------------------------------------------------------*/
DWORD
_gpgezw_sign_dwGetFileName(HWND hwnd, LPSTR szPlainFileName) {
  OPENFILENAME ofn;
  CHAR szBuff[MAX_STRING + 1];

  LoadString(g_hInstance, IDS_STRING_WSIGN_WINDOW_TITLE_FILE, szBuff, MAX_STRING);
  
  ZeroMemory(&ofn, sizeof(OPENFILENAME));
  ofn.lStructSize = sizeof(OPENFILENAME);
  ofn.hwndOwner = hwnd;
  ofn.lpstrFilter = "All Files(*.*)\0*.*\0\0";
  ofn.lpstrFile = szPlainFileName;
  ofn.lpstrTitle = szBuff;
  ofn.nMaxFile = MAX_PATH;
  ofn.Flags = OFN_FILEMUSTEXIST;
  if (GetOpenFileName(&ofn)) return ERR_NO_ERROR;
  else return ERR_USER_CANCEL;
}

/*------------------------------------------------------------*/
DWORD
_gpgezw_sign_dwGetSignFileName(HWND hwnd, LPSTR szSignFileName) {
  OPENFILENAME ofn;
  CHAR szBuff[MAX_STRING + 1];
  
  LoadString(g_hInstance, IDS_STRING_WSIGN_WINDOW_TITLE_SIGN, szBuff, MAX_STRING);
  
  ZeroMemory(&ofn, sizeof(OPENFILENAME));
  ofn.lStructSize = sizeof(OPENFILENAME);
  ofn.hwndOwner = hwnd;
  ofn.lpstrFilter = GPGEZW_OFN_FILTER_SIGN;
  ofn.lpstrFile = szSignFileName;
  ofn.lpstrTitle = szBuff;
  ofn.nMaxFile = MAX_PATH;
  ofn.Flags = OFN_OVERWRITEPROMPT;
  if (GetSaveFileName(&ofn)) return ERR_NO_ERROR;
  else return ERR_USER_CANCEL;
}

/*------------------------------------------------------------*/
DWORD
_gpgezw_sign_dwSignFile(PGPGEZPARAM pgp, LPCSTR szFileName, LPCSTR szSignFileName) {
  DWORD dwStatus = 0;
  DWORD dwErr;
  HCURSOR hOldCursor;

  hOldCursor = SetCursor(LoadCursor(NULL, IDC_WAIT));
  dwErr = gpgez_sign(pgp->szGpgHome, pgp->szSecRing, pgp->szPubRing, szFileName, szSignFileName, pgp->szPassphrase, &dwStatus);
  SetCursor(hOldCursor);

  return dwErr;
}

/*------------------------------------------------------------*/
DWORD
gpgezw_dwSign(HWND hwnd, PGPGEZPARAM pgp, LPCSTR lpFileName) {
  DWORD dwErr;
  CHAR szFileName[MAX_PATH + 1];
  CHAR szSignFileName[MAX_PATH + 1];

/*
	t@Cw
*/
  if (!lpFileName) {
    ZeroMemory(szFileName, MAX_PATH);
    if ((dwErr = _gpgezw_sign_dwGetFileName(hwnd, szFileName)) != ERR_NO_ERROR) {
      return dwErr;
    }
  } else {
    HANDLE hFile;
    hFile = CreateFile(lpFileName, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
    if (hFile == INVALID_HANDLE_VALUE) {
      GPGEZDEBUG();
      gpgez_ShowErrorMessage(NULL, ERR_FAILED_TO_OPEN_INPUT_FILE);
      return 0;
    }
    CloseHandle(hFile);
    strcpy(szFileName, lpFileName);
  }

/*
	t@C̃t@Cw
*/
  if (strlen(szFileName) < (MAX_PATH - strlen(GPGEZW_EXT_SIGN))) {
    strcpy(szSignFileName, szFileName);
    strcat(szSignFileName, GPGEZW_EXT_SIGN);
  } else {
    ZeroMemory(szSignFileName, MAX_PATH);
  }
  if ((dwErr = _gpgezw_sign_dwGetSignFileName(hwnd, szSignFileName)) != ERR_NO_ERROR) {
    return 0;
  }

  dwErr = _gpgezw_sign_dwSignFile(pgp, szFileName, szSignFileName);
  if (dwErr != ERR_NO_ERROR) {
    return dwErr;
  }
  
  return ERR_NO_ERROR;
}

/*------------------------------------------------------------*/
