/* gpgezw_verify.c
 * Copyright (C) 2005 Kazuyoshi Kakihara
 *
 * This file is part of JanusDG.
 *
 * JanusDG is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 */

#include "gpgezw.h"

#include "resource.h"

extern HINSTANCE g_hInstance;

/*------------------------------------------------------------*/
DWORD
_gpgezw_verify_dwGetFileName(HWND hwnd, LPSTR szFileName) {
  OPENFILENAME ofn;
  CHAR szBuff[MAX_STRING + 1];

  LoadString(g_hInstance, IDS_STRING_WVERIFY_WINDOW_TITLE_FILE, szBuff, MAX_STRING);
  
  ZeroMemory(&ofn, sizeof(OPENFILENAME));
  ofn.lStructSize = sizeof(OPENFILENAME);
  ofn.hwndOwner = hwnd;
  ofn.lpstrFilter = "All Files(*.*)\0*.*\0\0";
  ofn.lpstrFile = szFileName;
  ofn.lpstrTitle = szBuff;
  ofn.nMaxFile = MAX_PATH;
  ofn.Flags = OFN_FILEMUSTEXIST;
  if (GetOpenFileName(&ofn)) return ERR_NO_ERROR;
  else return ERR_USER_CANCEL;
}

/*------------------------------------------------------------*/
DWORD
_gpgezw_verify_dwGetPubkeyFileName(HWND hwnd, LPSTR szPubkeyFileName) {
  OPENFILENAME ofn;
  CHAR szBuff[MAX_STRING + 1];
  CHAR szInitialDir[MAX_PATH + 1];

  GetModuleFileName(NULL, szInitialDir, MAX_PATH);
  *(gpgez_strryen(szInitialDir) + 1) = '\0';
  strcat(szInitialDir, GPGEZW_PUBKEY_FOLDER);
  strcat(szInitialDir, "\\");

  LoadString(g_hInstance, IDS_STRING_WVERIFY_WINDOW_TITLE_PUBKEYFILE, szBuff, MAX_STRING);

  ZeroMemory(&ofn, sizeof(OPENFILENAME));
  ofn.lStructSize = sizeof(OPENFILENAME);
  ofn.hwndOwner = hwnd;
  ofn.lpstrFilter = GPGEZW_OFN_FILTER_KEY;
  ofn.lpstrFile = szPubkeyFileName;
  ofn.lpstrTitle = szBuff;
  ofn.lpstrInitialDir = szInitialDir;
  ofn.nMaxFile = MAX_PATH;
  ofn.Flags = OFN_FILEMUSTEXIST;
  if (GetOpenFileName(&ofn)) return ERR_NO_ERROR;
  else return ERR_USER_CANCEL;
}

/*------------------------------------------------------------*/
DWORD
_gpgezw_verify_dwGetSignFileName(HWND hwnd, LPSTR szSignFileName) {
  OPENFILENAME ofn;
  CHAR szBuff[MAX_STRING + 1];

  LoadString(g_hInstance, IDS_STRING_WVERIFY_WINDOW_TITLE_SIGN, szBuff, MAX_STRING);
  
  ZeroMemory(&ofn, sizeof(OPENFILENAME));
  ofn.lStructSize = sizeof(OPENFILENAME);
  ofn.hwndOwner = hwnd;
  ofn.lpstrFilter = GPGEZW_OFN_FILTER_SIGN;
  ofn.lpstrFile = szSignFileName;
  ofn.lpstrTitle = szBuff;
  ofn.nMaxFile = MAX_PATH;
  ofn.Flags = OFN_FILEMUSTEXIST;
  if (GetOpenFileName(&ofn)) return ERR_NO_ERROR;
  else return ERR_USER_CANCEL;
}

/*------------------------------------------------------------*/
DWORD
_gpgezw_verify_dwVerifyFile(PGPGEZPARAM pgp, LPCSTR szFileName, LPCSTR szPublickeyFileName, LPCSTR szSignFileName) {
  CHAR szPubring[MAX_PATH + 1];
  DWORD dwStatus = 0;
  DWORD dwErr;
  HCURSOR hOldCursor;

  if (strlen(szPublickeyFileName) > 0) {
    strcpy(szPubring, szPublickeyFileName);
  }

  hOldCursor = SetCursor(LoadCursor(NULL, IDC_WAIT));
  dwErr = gpgez_verify(pgp->szGpgHome, szPublickeyFileName, szFileName, szSignFileName, &dwStatus);
  SetCursor(hOldCursor);
  
  return dwErr;
}

/*------------------------------------------------------------*/
DWORD
gpgezw_dwVerify(HWND hwnd, PGPGEZPARAM pgp, LPCSTR lpFileName) {
  DWORD dwErr;
  CHAR szFileName[MAX_PATH + 1];
  CHAR szSignFileName[MAX_PATH + 1];
  CHAR szPubkeyFileName[MAX_PATH + 1];

/*
	ꂽt@Cw
*/
  if (!lpFileName) {
    ZeroMemory(szFileName, MAX_PATH);
    if ((dwErr = _gpgezw_verify_dwGetFileName(hwnd, szFileName)) != ERR_NO_ERROR) {
      return dwErr;
    }
  } else {
    HANDLE hFile;
    hFile = CreateFile(lpFileName, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
    if (hFile == INVALID_HANDLE_VALUE) {
      GPGEZDEBUG();
      dwErr = ERR_FAILED_TO_OPEN_INPUT_FILE;
      return dwErr;
    }
    CloseHandle(hFile);
    strcpy(szFileName, lpFileName);
  }

/*
	t@Cw
*/
  if (strlen(szFileName) < (MAX_PATH - strlen(GPGEZW_EXT_SIGN))) {
    strcpy(szSignFileName, szFileName);
    strcat(szSignFileName, GPGEZW_EXT_SIGN);
  } else {
    ZeroMemory(szSignFileName, MAX_PATH);
  }
  if ((dwErr = _gpgezw_verify_dwGetSignFileName(hwnd, szSignFileName)) != ERR_NO_ERROR) {
    return dwErr;
  }

/*
	̌؂Ɏgp錮t@Cw
*/
  ZeroMemory(szPubkeyFileName, MAX_PATH);
  if ((dwErr = _gpgezw_verify_dwGetPubkeyFileName(hwnd, szPubkeyFileName)) != ERR_NO_ERROR) {
    return dwErr;
  }
  
  dwErr = _gpgezw_verify_dwVerifyFile(pgp, szFileName, szPubkeyFileName, szSignFileName);
  if (dwErr != ERR_NO_ERROR) {
    return dwErr;
  }
  
  return ERR_NO_ERROR;
}

/*------------------------------------------------------------*/
