/* gpgezw_viewkey.c
 * Copyright (C) 2005 Kazuyoshi Kakihara
 *
 * This file is part of JanusDG.
 *
 * JanusDG is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 */

#include "gpgezw.h"

#include "resource.h"

extern HINSTANCE g_hInstance;

/*------------------------------------------------------------*/
DWORD
_gpgezw_viewkey_dwGetPubkeyFileName(HWND hwnd, LPSTR szPubkeyFileName) {
  OPENFILENAME ofn;
  CHAR szBuff[MAX_STRING + 1];
  CHAR szInitialDir[MAX_PATH + 1];

  GetModuleFileName(NULL, szInitialDir, MAX_PATH);
  *(gpgez_strryen(szInitialDir) + 1) = '\0';
  strcat(szInitialDir, GPGEZW_PUBKEY_FOLDER);
  strcat(szInitialDir, "\\");

  LoadString(g_hInstance, IDS_STRING_WVIEWKEY_WINDOW_TITLE_PUBKEYFILE, szBuff, MAX_STRING);

  ZeroMemory(&ofn, sizeof(OPENFILENAME));
  ofn.lStructSize = sizeof(OPENFILENAME);
  ofn.hwndOwner = hwnd;
  ofn.lpstrFilter = GPGEZW_OFN_FILTER_KEY;
  ofn.lpstrFile = szPubkeyFileName;
  ofn.lpstrTitle = szBuff;
  ofn.lpstrInitialDir = szInitialDir;
  ofn.nMaxFile = MAX_PATH;
  ofn.Flags = OFN_FILEMUSTEXIST;
  if (GetOpenFileName(&ofn)) return ERR_NO_ERROR;
  else return ERR_USER_CANCEL;
}

/*------------------------------------------------------------*/
DWORD
_gpgezw_viewkey_dwViewKeyFile(HWND hwnd, PGPGEZPARAM pgp, LPCSTR szPubkeyFileName) {
  CHAR szFpr[MAX_FPR + 1];
  CHAR szUid[MAX_UID + 1];
  CHAR szPreamble[MAX_STRING + 1];
  CHAR szConfirm[MAX_STRING + 1];
  CHAR szMessage[MAX_STRING * 6 + 1];
  INT iCnt;
  HGLOBAL hMem;
  LPSTR szClipboardText;
  GPGEZ_KEYLIST KeyList;
  DWORD dwErr;

  KeyList.szUid = NULL;
  KeyList.szFpr = NULL;
  KeyList.pNext = NULL;

  dwErr = gpgez_listkeys(pgp->szGpgHome, szPubkeyFileName, &KeyList);
  if (dwErr != ERR_NO_ERROR) return dwErr;
  if (KeyList.pNext == NULL) {
    GPGEZDEBUG();
    return ERR_ILLEGAL_PUBRING_FORMAT;
  }
  if ((KeyList.pNext)->pNext) {
    gpgez_listkey_clear_node(&KeyList);
    GPGEZDEBUG();
    return ERR_ILLEGAL_PUBRING_FORMAT;
  }
  strcpy(szFpr, (KeyList.pNext)->szFpr);
  strcpy(szUid, (KeyList.pNext)->szUid);
  gpgez_listkey_clear_node(&KeyList);

  strcpy(szMessage, "");
  LoadString(g_hInstance, IDS_STRING_WVIEWKEY_PREAMBLE1, szPreamble, MAX_STRING);
  strcat(szMessage, szPreamble);
  strcat(szMessage, "\n");
  strcat(szMessage, szUid);
  strcat(szMessage, "\n\n");
  LoadString(g_hInstance, IDS_STRING_WVIEWKEY_PREAMBLE2, szPreamble, MAX_STRING);
  strcat(szMessage, szPreamble);
  strcat(szMessage, "\n");
  for (iCnt = 0; iCnt < 5; iCnt++) {
    strncat(szMessage, szFpr + iCnt * 4, 4);
    strcat(szMessage, " ");
  }
  strcat(szMessage, " ");
  for (iCnt = 0; iCnt < 5; iCnt++) {
    strncat(szMessage, szFpr + 20 + iCnt * 4, 4);
    strcat(szMessage, " ");
  }
  strcat(szMessage, "\n\n");
  LoadString(g_hInstance, IDS_STRING_WVIEWKEY_CONFIRM_TO_COPY, szConfirm, MAX_STRING);
  strcat(szMessage, szConfirm);
  
  if (MessageBox(hwnd, szMessage, "Message Box", MB_YESNO) == IDYES) {
    if ((hMem = GlobalAlloc(GMEM_MOVEABLE, strlen(szFpr) + 1))) {
      if ((szClipboardText = GlobalLock(hMem))) {
        strcpy(szClipboardText, szFpr);
        GlobalUnlock(hMem);
        if (OpenClipboard(NULL)) {
          EmptyClipboard();
          SetClipboardData(CF_TEXT, hMem);
          CloseClipboard();
        } else {
          GPGEZDEBUG();
          dwErr = ERR_FAILED_TO_OPEN_CLIPBOARD;
          GlobalFree(hMem);
        }
      } else {
        GPGEZDEBUG();
        dwErr = ERR_FAILED_TO_LOCK_MEMORY;
        GlobalFree(hMem);
      }
    } else {
      GPGEZDEBUG();
      dwErr = ERR_FAILED_TO_ALLOCATE_MEMORY;
    }
  }
  return dwErr;
}
/*------------------------------------------------------------*/
DWORD gpgezw_dwViewKey(HWND hwnd, PGPGEZPARAM pgp, LPCSTR lpCmdLine) {
  CHAR szPubkeyFileName[MAX_PATH + 1];
  DWORD dwErr;

/*
	gp錮t@Cw
*/
  ZeroMemory(szPubkeyFileName, MAX_PATH);
  if ((dwErr = _gpgezw_viewkey_dwGetPubkeyFileName(hwnd, szPubkeyFileName)) != ERR_NO_ERROR) {
    return 0;
  }

  dwErr = _gpgezw_viewkey_dwViewKeyFile(hwnd, pgp, szPubkeyFileName);
  if (dwErr != ERR_NO_ERROR) {
    return dwErr;
  }

  return ERR_NO_ERROR;
}

/*------------------------------------------------------------*/
