#include "Flick.h"

CFlick::CFlick(void)
{
}

CFlick::~CFlick(void)
{
}

void CFlick::Load(char* fileName)
{
	std::string buff;

	std::ifstream fs(fileName);
	if(fs.fail())
	{
		std::cout<<fileName<<" is not exist."<<std::endl;
		exit(1);
	}
	std::ostringstream ss;
	ss<<fs.rdbuf();
	buff= ss.str();

	if(buff.substr(0,5)!="MFLK;")
	{
		std::cout<<fileName<<" is not MIDIFlick Data File."<<std::endl;
		exit(1);
	}

	size_t seek,count;

	seek=buff.find("[FileData]");
	count=buff.find("\n\n",seek)-seek+1;
	fileData.SetFileData(buff.substr(seek,count));

	seek=buff.find("[Code]");
	for(int tr=0;tr<MAX_TRACK;tr++)
	{
		seek=buff.find("=",seek)+1;
		count=buff.find("\n",seek)-seek;
		track[tr].SetTrack(buff.substr(seek,count));
		track[tr].channel=(tr==0 ? 0 : (tr<10 ? tr-1 : (tr>=16 ? 9 : tr)));
	}
	
}

/////////////////////////////////////////////////////////

CFlickFileData::CFlickFileData(void)
{
	builder="";
	title="";
	comment="";
	device="";
	timeBase=480;
}

CFlickFileData::~CFlickFileData(void)
{
}

void CFlickFileData::SetFileData(std::string fd)
{
	size_t seek;
	std::string temp;

	builder=Extract(fd,"Builder=","\n");
	
	title=Extract(fd,"Title=","\n");
	
	temp=Extract(fd,"Comment=","\n");
	seek=0;
	while((seek=temp.find("\\r\\n",seek))!=-1)
		temp.replace(seek,4,"\n");
	comment=temp;
	
	device=Extract(fd,"Device=","\n");

	temp=Extract(fd,"TimeBase=","\n");
	timeBase=stoi(temp);
}



/////////////////////////////////////////////////////////

CFlickTrack::CFlickTrack(void)
{
	channel=0;
}

CFlickTrack::~CFlickTrack(void)
{
	std::list<CFlickElement*>::iterator it;

	for(it=elementList.begin();it!=elementList.end();++it)
	{
		delete (*it);
		(*it)=NULL;
	}
	elementList.clear();
}

void CFlickTrack::SetTrack(std::string tr)
{
	size_t seek=0;
	CFlickElement* element;

	while(seek<tr.length())
	{
		element=new CFlickElement;
		switch(tr[seek])
		{
		case '[':
			if(tr[seek+1]==']')
			{
				element->type=Null;
				seek+=2;
				break;
			}
			switch(tr[seek+1])
			{
			case '%':
				element->type=Kernel;
				break;
			case '$':
				element->type=Control;
				break;
			case '#':
				element->type=System;
				break;
			}
			{
				size_t colon,close;
				colon=tr.find(":",seek);
				close=tr.find("]",seek);
				if((colon==-1) || (colon>close))
				{
					element->index=stoi(tr.substr(seek+2,close-seek-2));
				}
				else
				{
					element->index=stoi(tr.substr(seek+2,colon-seek-2));
					element->data=tr.substr(colon+1,close-colon-1);
				}
				seek=close+1;
			}
			break;
		default:
			element->type=Note;
			element->data=tr.substr(seek,1);
			seek++;
		}
		elementList.push_back(element);
	}
}


/////////////////////////////////////////////////////////

CFlickElement::CFlickElement(void)
{
	type=Null;
	index=0;
	data="";
}

CFlickElement::~CFlickElement(void)
{
}

/////////////////////////////////////////////////////////

int stoi(std::string str)
{
	const std::string numSet("0123456789");
	int result=0;
	int sign=1;

	if(str[0]=='-')
		sign=-1;

	for(unsigned int i=(sign==1 ? 0 : 1);i<str.length();i++)
	{
		if(numSet.find(str[i])==-1)
			break;

		result*=10;
		result+=(int)(numSet.find(str[i]));
	}

	return result*sign;
}

std::string Extract(std::string src,std::string start,std::string end)
{
	size_t s,e;
	s=src.find(start)+start.length();
	e=src.find(end,s);
	return src.substr(s,e-s);
}
