#include "stdafx.h"

#define MAX_TRACK 19

enum TYPE{
	Null,
	Note,
	Kernel,
	Control,
	System
};

class CFlickElement
{
public:
	CFlickElement(void);
	~CFlickElement(void);
public:
	TYPE type;
	int index;
	std::string data;
};

class CFlickTrack
{
public:
	CFlickTrack(void);
	~CFlickTrack(void);
	void SetTrack(std::string tr);
public:
	BYTE channel;
	std::list<CFlickElement*> elementList;
};

class CFlickFileData
{
public:
	CFlickFileData(void);
	~CFlickFileData(void);
	void SetFileData(std::string fd);
public:
	std::string builder;
	std::string title;
	std::string comment;
	std::string device;
	int timeBase;
};

class CFlick
{
public:
	CFlick(void);
	~CFlick(void);
	void Load(char* fileName);
public:
	CFlickFileData fileData;
	CFlickTrack track[MAX_TRACK];
};

int stoi(std::string str);
std::string Extract(std::string src,std::string start,std::string end);
