#include "Midi.h"

CMidi::CMidi(void)
{
	header.track=0;
	track=NULL;
}

CMidi::~CMidi(void)
{
	if(track!=NULL)
		delete[] track;
}

void CMidi::Save(std::string fileName)
{
	std::ofstream fs(fileName.c_str(),std::ios::out | std::ios::binary);

	header.Save(fs);
	for(int tr=0;tr<header.track;tr++)
		(track+tr)->Save(fs);
}

/////////////////////////////////////////////////////////////////////

CMidiHeader::CMidiHeader(void)
{
	strcpy(id,"MThd");
	len=6;
	format=0;
	track=1;
	time=480;
}

CMidiHeader::~CMidiHeader(void)
{
}

void CMidiHeader::Save(std::ofstream& fs)
{
	fs.write(id,4);

	fs<<ByteExt(len,24,0xff);
	fs<<ByteExt(len,16,0xff);
	fs<<ByteExt(len,8,0xff);
	fs<<ByteExt(len,0,0xff);

	fs<<ByteExt(format,8,0xff);
	fs<<ByteExt(format,0,0xff);
	
	fs<<ByteExt(track,8,0xff);
	fs<<ByteExt(track,0,0xff);

	fs<<ByteExt(time,8,0xff);
	fs<<ByteExt(time,0,0xff);
}

/////////////////////////////////////////////////////////////////////

CMidiTrack::CMidiTrack(void)
{
	strcpy(id,"MTrk");
}

CMidiTrack::~CMidiTrack(void)
{
}

void CMidiTrack::Save(std::ofstream& fs)
{
	DWORD trackLength=0;
	std::list<CMidiMsg*>::iterator it;

	for(it=msgList.begin();it != msgList.end();++it)
		trackLength+=(*it)->Length();

	fs.write(id,4);

	fs<<ByteExt(trackLength,24,0xff);
	fs<<ByteExt(trackLength,16,0xff);
	fs<<ByteExt(trackLength,8,0xff);
	fs<<ByteExt(trackLength,0,0xff);

	for(it=msgList.begin();it != msgList.end();++it)
		(*it)->Save(fs);
}


/////////////////////////////////////////////////////////////////////

CMidiMsg::CMidiMsg(void)
{
	dt=0;
	len=0;
	msg=NULL;
}

CMidiMsg::CMidiMsg(DWORD deltaTime,BYTE length,BYTE *pMsg)
{
	dt=deltaTime;
	len=length;
	msg=new BYTE[len];
	memcpy(msg,pMsg,len);
}

CMidiMsg::~CMidiMsg(void)
{
	DeleteMsg();
}

void CMidiMsg::DeleteMsg(void)
{
	if(msg!=NULL)
		delete[] msg;
	msg=NULL;
	len=0;
}

DWORD CMidiMsg::Length(void)
{
	if((dt&0xFE00000)!=0)
	{
		return (len+4);
	}
	else if((dt&0x1FC000)!=0)
	{
		return (len+3);
	}
	else if((dt&0x3F80)!=0)
	{
		return (len+2);
	}
	return (len+1);
}

void CMidiMsg::Save(std::ofstream& fs)
{
	if((dt&0xFE00000)!=0)
	{
		fs<<(BYTE)(ByteExt(dt,21,0x7f)+0x80);
		fs<<(BYTE)(ByteExt(dt,14,0x7f)+0x80);
		fs<<(BYTE)(ByteExt(dt,7,0x7f)+0x80);
		fs<<ByteExt(dt,0,0x7f);
	}
	else if((dt&0x1FC000)!=0)
	{
		fs<<(BYTE)(ByteExt(dt,14,0x7f)+0x80);
		fs<<(BYTE)(ByteExt(dt,7,0x7f)+0x80);
		fs<<ByteExt(dt,0,0x7f);
	}
	else if((dt&0x3F80)!=0)
	{
		fs<<(BYTE)(ByteExt(dt,7,0x7f)+0x80);
		fs<<ByteExt(dt,0,0x7f);
	}
	else
	{
		fs<<ByteExt(dt,0,0x7f);
	}
	fs.write((char*)msg,len);
}


////////////////////////////////////////////////////////////////////

BYTE ByteExt(DWORD src,BYTE shift,BYTE mask)
{
	DWORD masked=src&(((DWORD)mask)<<shift);

	return (BYTE)(masked>>shift);
}

BYTE ByteExt(WORD src,BYTE shift,BYTE mask)
{
	WORD masked=src&(((WORD)mask)<<shift);

	return (BYTE)(masked>>shift);
}
