#include "flkc.h"

#define MSG_BUFFER_SIZE 128

int main(int argc,char *argv[])
{
	if(argc==1)
	{
		std::cout<<"MIDIFlick Compiler ver 1.2"<<std::endl;
		std::cout<<"(C)Iwa-yukinoshita 2007"<<std::endl;
		std::cout<<"MIDIFlick Data File => Standard MIDI File"<<std::endl;
		std::cout<<"[Reference]"<<std::endl;
		std::cout<<"  flkc [file(*.flk)]"<<std::endl;
		return 0;
	}

	CFlick *flick=new CFlick;
	CMidi *midi=new CMidi;

	std::cout<<argv[1]<<" Loading...";
	flick->Load(argv[1]);
	std::cout<<"Done"<<std::endl;

	std::string outputFile(argv[1]);
	size_t ext=outputFile.find_last_of(".");
	outputFile.replace(ext,outputFile.length()-ext,".mid");

	midi->header.format=1;
	midi->header.track=MAX_TRACK;
	midi->header.time=(WORD)flick->fileData.timeBase;
	midi->track=new CMidiTrack[MAX_TRACK];

	DWORD deltaTime=0;
	std::list<CFlickElement*>::iterator itFlick;
	std::vector<DWORD> dtList;
	std::vector<DWORD>::iterator itDt;
	std::vector<char> harmony;
	std::vector<BYTE> note;
	std::string noteChar("opqrstuvwxyzabcdefghijklABCDEFGHIJKLMNOPQRSTUVWX-/");
	BYTE msgBuffer[MSG_BUFFER_SIZE];
	DWORD tick=120;
	int octave;
	BYTE vel;
	size_t noteIndex;
	CMidiMsg *newMsg=NULL;
	int tr;

	std::cout<<"Compiling";

	for(itFlick=flick->track[0].elementList.begin();itFlick!=flick->track[0].elementList.end();++itFlick)
	{
		if((*itFlick)->type==Kernel)
		{
			if((*itFlick)->index==18)
			{
				tick=stoi((*itFlick)->data);
			}
		}
		else if((*itFlick)->type==Note)
		{
			dtList.push_back(tick);
		}
	}

	std::cout<<".";

	// ?f?[?^???
	for(tr=0;tr<MAX_TRACK;tr++)
	{
		itDt=dtList.begin();
		harmony.clear();
		note.clear();
		deltaTime=0;
		tick=120;
		octave=3;
		vel=0x7f;
		for(itFlick=flick->track[tr].elementList.begin();itFlick != flick->track[tr].elementList.end();++itFlick)
		{
			switch((*itFlick)->type)
			{
			case Null:
				break;
			case Kernel:
				switch((*itFlick)->index)
				{
				case 2:// Define(=>Marker)
					msgBuffer[0]=0xff;
					msgBuffer[1]=0x06;
					msgBuffer[2]=(BYTE)((*itFlick)->data.length());
					memcpy(msgBuffer+3,(*itFlick)->data.c_str(),msgBuffer[2]);
					newMsg=new CMidiMsg(deltaTime,msgBuffer[2]+3,msgBuffer);
					midi->track[tr].msgList.push_back(newMsg);
					deltaTime=0;
					break;
				case 3:// Program Change
					msgBuffer[0]=0xc0+flick->track[tr].channel;
					msgBuffer[1]=(BYTE)(stoi(((*itFlick)->data)));
					newMsg=new CMidiMsg(deltaTime,2,msgBuffer);
					midi->track[tr].msgList.push_back(newMsg);
					deltaTime=0;
					break;
				case 4:// Octave Set
					octave=stoi((*itFlick)->data);
					break;
				case 5:// Velocity
					vel=(BYTE)(stoi((*itFlick)->data));
					break;
				case 7:// Comment(=>Text)
					msgBuffer[0]=0xff;
					msgBuffer[1]=0x01;
					msgBuffer[2]=(BYTE)((*itFlick)->data.length());
					memcpy(msgBuffer+3,(*itFlick)->data.c_str(),msgBuffer[2]);
					newMsg=new CMidiMsg(deltaTime,msgBuffer[2]+3,msgBuffer);
					midi->track[tr].msgList.push_back(newMsg);
					deltaTime=0;
					break;
				case 10:// Harmony
					if(!harmony.empty())
						harmony.clear();

					while(note.size()>1)
					{
						msgBuffer[0]=0x80+flick->track[tr].channel;
						msgBuffer[1]=note[note.size()-1];
						msgBuffer[2]=0x40;
						newMsg=new CMidiMsg(deltaTime,3,msgBuffer);
						midi->track[tr].msgList.push_back(newMsg);
						note.pop_back();
						deltaTime=0;
					}
					{
						size_t seek,token;
						BYTE h;

						seek=0;
						while(TRUE)
						{
							h=(BYTE)(stoi((*itFlick)->data.substr(seek)));
							harmony.push_back(h);
							token=(*itFlick)->data.find(",",seek);
							if(token==-1)
								break;
							seek=token+1;
						}
					}
					if(!note.empty())
					{
						for(size_t h=0;h<harmony.size();h++)
						{
							msgBuffer[0]=0x90+flick->track[tr].channel;
							msgBuffer[1]=note[note.size()-1];
							msgBuffer[2]=vel;
							newMsg=new CMidiMsg(deltaTime,3,msgBuffer);
							midi->track[tr].msgList.push_back(newMsg);
							note.push_back(msgBuffer[1]);
							deltaTime=0;
						}
					}
					break;
				case 11:// Harmony End
					if(!harmony.empty())
						harmony.clear();

					while(note.size()>1)
					{
						msgBuffer[0]=0x80+flick->track[tr].channel;
						msgBuffer[1]=note[note.size()-1];
						msgBuffer[2]=0x40;
						newMsg=new CMidiMsg(deltaTime,3,msgBuffer);
						midi->track[tr].msgList.push_back(newMsg);
						note.pop_back();
						deltaTime=0;
					}
					break;
				}
				break;
			case Control:
				msgBuffer[0]=0xb0+flick->track[tr].channel;
				msgBuffer[1]=(*itFlick)->index;
				msgBuffer[2]=(BYTE)(stoi((*itFlick)->data));
				newMsg=new CMidiMsg(deltaTime,3,msgBuffer);
				midi->track[tr].msgList.push_back(newMsg);
				deltaTime=0;
				break;
			case System:
				switch((*itFlick)->index)
				{
				case 0:// GM System ON
					msgBuffer[0]=0xf0;
					msgBuffer[1]=0x05;
					msgBuffer[2]=0x7e;
					msgBuffer[3]=0x7f;
					msgBuffer[4]=0x09;
					msgBuffer[5]=0x01;
					msgBuffer[6]=0xf7;
					newMsg=new CMidiMsg(deltaTime,7,msgBuffer);
					midi->track[tr].msgList.push_back(newMsg);
					deltaTime=0;
					break;
				case 1:// XG System ON
					msgBuffer[0]=0xf0;
					msgBuffer[1]=0x08;
					msgBuffer[2]=0x43;
					msgBuffer[3]=0x10;
					msgBuffer[4]=0x4c;
					msgBuffer[5]=0x00;
					msgBuffer[6]=0x00;
					msgBuffer[7]=0x7e;
					msgBuffer[8]=0x00;
					msgBuffer[9]=0xf7;
					newMsg=new CMidiMsg(deltaTime,10,msgBuffer);
					midi->track[tr].msgList.push_back(newMsg);
					deltaTime=0;
					break;
				case 2:// GS Reset
					msgBuffer[0]=0xf0;
					msgBuffer[1]=0x0a;
					msgBuffer[2]=0x41;
					msgBuffer[3]=0x20;
					msgBuffer[4]=0x42;
					msgBuffer[5]=0x12;
					msgBuffer[6]=0x40;
					msgBuffer[7]=0x00;
					msgBuffer[8]=0x7f;
					msgBuffer[9]=0x00;
					msgBuffer[10]=0x41;
					msgBuffer[11]=0xf7;
					newMsg=new CMidiMsg(deltaTime,12,msgBuffer);
					midi->track[tr].msgList.push_back(newMsg);
					deltaTime=0;
					break;
				case 3:// GM2 System ON
					msgBuffer[0]=0xf0;
					msgBuffer[1]=0x05;
					msgBuffer[2]=0x7e;
					msgBuffer[3]=0x7f;
					msgBuffer[4]=0x09;
					msgBuffer[5]=0x03;
					msgBuffer[6]=0xf7;
					newMsg=new CMidiMsg(deltaTime,7,msgBuffer);
					midi->track[tr].msgList.push_back(newMsg);
					deltaTime=0;
					break;
				case 30:// Tempo Set
					{
						DWORD tempo=(DWORD)(60000000/stoi((*itFlick)->data));
						msgBuffer[0]=0xff;
						msgBuffer[1]=0x51;
						msgBuffer[2]=0x03;
						msgBuffer[3]=ByteExt(tempo,16,0xff);
						msgBuffer[4]=ByteExt(tempo,8,0xff);
						msgBuffer[5]=ByteExt(tempo,0,0xff);
						newMsg=new CMidiMsg(deltaTime,6,msgBuffer);
						midi->track[tr].msgList.push_back(newMsg);
						deltaTime=0;
					}
					break;
				case 31:// Pitch Bend
					{
						WORD pitch=(WORD)(stoi((*itFlick)->data));
						msgBuffer[0]=0xe0+flick->track[tr].channel;
						msgBuffer[1]=ByteExt(pitch,0,0x7f);
						msgBuffer[2]=ByteExt(pitch,7,0x7f);
						newMsg=new CMidiMsg(deltaTime,3,msgBuffer);
						midi->track[tr].msgList.push_back(newMsg);
						deltaTime=0;
					}
					break;
				case 32:// Beat Set
					{
						int deno,num;
						size_t div=(*itFlick)->data.find("/");
						num=stoi((*itFlick)->data.substr(0,div));
						deno=stoi((*itFlick)->data.substr(div+1));
						msgBuffer[0]=0xff;
						msgBuffer[1]=0x58;
						msgBuffer[2]=0x04;
						msgBuffer[3]=(BYTE)((num<1 ? 1 : num));
						switch(deno)
						{
						case 2:
							msgBuffer[4]=1;
							break;
						case 4:
							msgBuffer[4]=2;
							break;
						case 8:
							msgBuffer[4]=3;
							break;
						case 16:
							msgBuffer[4]=4;
							break;
						default:
							msgBuffer[4]=2;
						}
						msgBuffer[5]=0x18;
						msgBuffer[6]=0x08;
						newMsg=new CMidiMsg(deltaTime,7,msgBuffer);
						midi->track[tr].msgList.push_back(newMsg);
						deltaTime=0;
					}
					break;
				case 33:// Key Signature
					{
						std::string keys("C D EF G A B");
						int keyIndex=(int)(keys.find((*itFlick)->data.at(0)));
						if((*itFlick)->data.length()>=2)
						{
							switch((*itFlick)->data.at(1))
							{
							case '#':
								keyIndex++;
								break;
							case 'b':
								keyIndex--;
								break;
							}
						}
						if(((*itFlick)->data.find('-')!=-1) || ((*itFlick)->data.find('m')!=-1))
						{
							keyIndex+=3;
							msgBuffer[4]=1;
						}
						else
						{
							msgBuffer[4]=0;
						}

						msgBuffer[0]=0xff;
						msgBuffer[1]=0x59;
						msgBuffer[2]=0x02;
						keyIndex%=12;
						switch(keyIndex)
						{
						case 0:
							msgBuffer[3]=0;// C,Am
							break;
						case 1:
							msgBuffer[3]=(BYTE)(-5);// C#,Bbm
							break;
						case 2:
							msgBuffer[3]=2;// D,Bm
							break;
						case 3:
							msgBuffer[3]=(BYTE)(-3);// Eb,Cm
							break;
						case 4:
							msgBuffer[3]=4;// E,C#m
							break;
						case 5:
							msgBuffer[3]=(BYTE)(-1);// F,Dm
							break;
						case 6:
							msgBuffer[3]=(BYTE)(-6);// F#,Ebm
							break;
						case 7:
							msgBuffer[3]=1;// G,Em
							break;
						case 8:
							msgBuffer[3]=(BYTE)(-4);// G#,Fm
							break;
						case 9:
							msgBuffer[3]=3;// A,F#m
							break;
						case 10:
							msgBuffer[3]=(BYTE)(-2);// Bb,Gm
							break;
						case 11:
							msgBuffer[3]=5;// B,G#m
							break;
						}
						newMsg=new CMidiMsg(deltaTime,5,msgBuffer);
						midi->track[tr].msgList.push_back(newMsg);
						deltaTime=0;
					}
					break;
				}
				break;
			case Note:
				noteIndex=noteChar.find((*itFlick)->data);
				switch(noteIndex)
				{
				case -1:
				case 48:// '-'
					break;
				case 49:// '/'
					while(!note.empty())
					{
						msgBuffer[0]=0x80+flick->track[tr].channel;
						msgBuffer[1]=note[note.size()-1];
						msgBuffer[2]=0x40;
						newMsg=new CMidiMsg(deltaTime,3,msgBuffer);
						midi->track[tr].msgList.push_back(newMsg);
						note.pop_back();
						deltaTime=0;
					}
					break;
				default:
					while(!note.empty())
					{
						msgBuffer[0]=0x80+flick->track[tr].channel;
						msgBuffer[1]=note[note.size()-1];
						msgBuffer[2]=0x40;
						newMsg=new CMidiMsg(deltaTime,3,msgBuffer);
						midi->track[tr].msgList.push_back(newMsg);
						note.pop_back();
						deltaTime=0;
					}
					{
						BYTE rootNote;

						msgBuffer[0]=0x90+flick->track[tr].channel;
						msgBuffer[1]=rootNote=(BYTE)(noteIndex+12*octave);
						msgBuffer[2]=vel;
						newMsg=new CMidiMsg(deltaTime,3,msgBuffer);
						midi->track[tr].msgList.push_back(newMsg);
						note.push_back(msgBuffer[1]);
						deltaTime=0;

						// Haemony
						for(size_t h=0;h<harmony.size();h++)
						{
							msgBuffer[0]=0x90+flick->track[tr].channel;
							msgBuffer[1]=(BYTE)((int)rootNote+harmony[h]);
							msgBuffer[2]=vel;
							newMsg=new CMidiMsg(0,3,msgBuffer);
							midi->track[tr].msgList.push_back(newMsg);
							note.push_back(msgBuffer[1]);
						}
					}
				}

				if(itDt!=dtList.end())
				{
					deltaTime+=(*itDt);
					itDt++;
				}
				else
				{
					deltaTime+=dtList[dtList.size()-1];
				}
				break;
			}
		}
		while(!note.empty())
		{
			msgBuffer[0]=0x80+flick->track[tr].channel;
			msgBuffer[1]=note[note.size()-1];
			msgBuffer[2]=0x40;
			newMsg=new CMidiMsg(deltaTime,3,msgBuffer);
			midi->track[tr].msgList.push_back(newMsg);
			note.pop_back();
			deltaTime=0;
		}

		msgBuffer[0]=0xff;
		msgBuffer[1]=0x2f;
		msgBuffer[2]=0x00;
		newMsg=new CMidiMsg(deltaTime,3,msgBuffer);
		midi->track[tr].msgList.push_back(newMsg);
		
		std::cout<<".";
	}

	// Title
	msgBuffer[0]=0xff;
	msgBuffer[1]=0x03;
	msgBuffer[2]=(BYTE)(flick->fileData.title.length());
	memcpy(msgBuffer+3,flick->fileData.title.c_str(),msgBuffer[2]);
	newMsg=new CMidiMsg(0,msgBuffer[2]+3,msgBuffer);
	midi->track[0].msgList.push_front(newMsg);

	// Builder
	msgBuffer[0]=0xff;
	msgBuffer[1]=0x02;
	msgBuffer[2]=(BYTE)(flick->fileData.builder.length());
	memcpy(msgBuffer+3,flick->fileData.builder.c_str(),msgBuffer[2]);
	newMsg=new CMidiMsg(0,msgBuffer[2]+3,msgBuffer);
	midi->track[0].msgList.push_front(newMsg);

	std::cout<<"Done"<<std::endl;

	std::cout<<outputFile<<" Saving...";
	midi->Save(outputFile);
	std::cout<<"Done"<<std::endl;

	std::cout<<"Memory liberating...";
	delete flick;
	delete midi;
	std::cout<<"Done"<<std::endl;

	return 0;
}
