// EventSettingDlg.cpp : t@C
//

#include "stdafx.h"
#include "FlkEdit.h"
#include "EventSettingDlg.h"


// CEventSettingDlg _CAO

IMPLEMENT_DYNAMIC(CEventSettingDlg, CDialog)

CEventSettingDlg::CEventSettingDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CEventSettingDlg::IDD, pParent)
	, m_comboType(0)
	, m_editProperty(_T(""))
{
}

CEventSettingDlg::~CEventSettingDlg()
{
}

void CEventSettingDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_CBIndex(pDX, IDC_COMBO_TYPE, m_comboType);
	DDX_Control(pDX, IDC_COMBO_VALUE, m_comboValue);
	DDX_Control(pDX, IDC_LIST_INDEX, m_listIndex);
	DDX_Text(pDX, IDC_EDIT_PROPERTY, m_editProperty);
}


BEGIN_MESSAGE_MAP(CEventSettingDlg, CDialog)
	ON_CBN_SELCHANGE(IDC_COMBO_TYPE, &CEventSettingDlg::OnCbnSelchangeComboType)
	ON_LBN_SELCHANGE(IDC_LIST_INDEX, &CEventSettingDlg::OnLbnSelchangeListIndex)
END_MESSAGE_MAP()


// CEventSettingDlg bZ[W nh

void CEventSettingDlg::OnCbnSelchangeComboType()
	// Cxg̎ނύXꂽ
{

	// f[^̍XV
	UpdateData(TRUE);

	// Xg{bNXƃR{{bNXɂ
	m_listIndex.ResetContent();
	m_comboValue.ResetContent();

	SetIndexList();
	
	// ēxf[^̍XV
	UpdateData(TRUE);
}

void CEventSettingDlg::OnOK()
{
	// OK{^ꂽ

	// R{{bNX̑II΂ꂽꍇ͂̔ԍA
	// 񂪓͂ꂽꍇ͕Ԃ
	if(m_comboValue.GetCurSel()==-1)
		m_comboValue.GetWindowTextW(m_value);
	else
		m_value.Format(_T("%d"),m_comboValue.GetCurSel());

	// IꂽԍԂ
	m_index=m_listIndex.GetCurSel();
	CDialog::OnOK();
}

void CEventSettingDlg::OnLbnSelchangeListIndex()
{
	// Xg{bNX̑IύXꂽ

	// f[^̍XV
	UpdateData(TRUE);

	// R{{bNXɂ
	m_comboValue.ResetContent();

	// R{{bNXɑIǉ
	SetValueList();

	// Cxg̃vpeB
	CString strTable;
	int mark;
	switch(m_comboType)
	{
	case Null:
		m_editProperty=_T("");
		break;
	case Kernel:
		strTable.LoadStringW(IDS_EVENT_KERNEL_0+m_listIndex.GetCurSel());
		mark=strTable.Find(_T("\n"))+1;
		m_editProperty=strTable.Mid(mark);
		break;
	case Control:
		strTable.LoadStringW(IDS_EVENT_CONTROL_0+m_listIndex.GetCurSel());
		mark=strTable.Find(_T("\n"))+1;
		m_editProperty=strTable.Mid(mark);
		break;
	case System:
		strTable.LoadStringW(IDS_EVENT_SYSTEM_0+m_listIndex.GetCurSel());
		mark=strTable.Find(_T("\n"))+1;
		m_editProperty=strTable.Mid(mark);
		break;
	}

	// ēxf[^XV
	UpdateData(FALSE);

}

BOOL CEventSettingDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO:  ɏǉĂ

	SetIndexList();
	m_listIndex.SetCurSel(m_index);

	SetValueList();

	if((m_comboType==Kernel) && (m_index==3))
	{
		m_comboValue.SetCurSel(_wtoi(m_value));
	}
	else
	{
		m_comboValue.SetWindowTextW(m_value);
	}
	
	UpdateData(FALSE);

	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}

void CEventSettingDlg::SetIndexList(void)
// ^Cvɉă\[XCfbNXǂݍ݁AXg{bNXɒǉĂ
{
	int cnt;
	CString strTable,strIndex;
	int mark,end;
	switch(m_comboType)
	{
	case Null:
		break;
	case Kernel:
		for(cnt=0;cnt<64;cnt++)
		{
			strTable.LoadStringW(IDS_EVENT_KERNEL_0+cnt);
			mark=strTable.Find(_T("/"))+1;
			end=strTable.Find(_T("\n"));
			strIndex.Format(_T("%3d:%s"),cnt,strTable.Mid(mark,end-mark));
			m_listIndex.AddString(strIndex);
		}
		break;
	case Control:
		for(cnt=0;cnt<128;cnt++)
		{
			strTable.LoadStringW(IDS_EVENT_CONTROL_0+cnt);
			mark=strTable.Find(_T("/"))+1;
			end=strTable.Find(_T("\n"));
			strIndex.Format(_T("%3d:%s"),cnt,strTable.Mid(mark,end-mark));
			m_listIndex.AddString(strIndex);
		}
		break;
	case System:
		for(cnt=0;cnt<128;cnt++)
		{
			strTable.LoadStringW(IDS_EVENT_SYSTEM_0+cnt);
			mark=strTable.Find(_T("/"))+1;
			end=strTable.Find(_T("\n"));
			strIndex.Format(_T("%3d:%s"),cnt,strTable.Mid(mark,end-mark));
			m_listIndex.AddString(strIndex);
		}
		break;
	}
}

void CEventSettingDlg::SetValueList(void)
{
	CString program,value;
	switch(m_comboType)
	{
	case Kernel:
		switch(m_listIndex.GetCurSel())
		{
		case 3:// ProgramCxg
			for(int i=0;i<128;i++)
			{
				program.LoadStringW(IDS_EVENT_PROGRAM_0+i);
				value.Format(_T("%3d:%s"),i,program);
				m_comboValue.AddString(value);
			}
			break;
		case 4:// OctaveCxg
			for(int i=0;i<=6;i++)
			{
				value.Format(_T("%d"),i);
				m_comboValue.AddString(value);
			}
			break;
		case 2:
		case 7:
		case 8:
		case 9:
		case 10:
		case 11:
		case 18:
			// IȂCxg
			break;
		default:
			for(int i=0;i<128;i++)
			{
				value.Format(_T("%3d"),i);
				m_comboValue.AddString(value);
			}
		}
		break;
	case Control:
		for(int i=0;i<128;i++)
		{
			value.Format(_T("%3d"),i);
			m_comboValue.AddString(value);
		}
		break;
	}

	// Cxg̃vpeB
	CString strTable;
	int mark;
	switch(m_comboType)
	{
	case Null:
		m_editProperty=_T("");
		break;
	case Kernel:
		strTable.LoadStringW(IDS_EVENT_KERNEL_0+m_listIndex.GetCurSel());
		mark=strTable.Find(_T("\n"))+1;
		m_editProperty=strTable.Mid(mark);
		break;
	case Control:
		strTable.LoadStringW(IDS_EVENT_CONTROL_0+m_listIndex.GetCurSel());
		mark=strTable.Find(_T("\n"))+1;
		m_editProperty=strTable.Mid(mark);
		break;
	case System:
		strTable.LoadStringW(IDS_EVENT_SYSTEM_0+m_listIndex.GetCurSel());
		mark=strTable.Find(_T("\n"))+1;
		m_editProperty=strTable.Mid(mark);
		break;
	}
}
