// FlkCode.cpp : t@C
//

#include "stdafx.h"
#include "FlkEdit.h"
#include "FlkCode.h"


// CFlkCode

CFlkCode::CFlkCode()
: m_eventLength(5)
{
}

CFlkCode::~CFlkCode()
{
	RemoveAll();
}

CFlkObj* CFlkCode::NextCur(CCursor* cur)
// J[\
{
	if(cur==NULL)
		cur=&m_cursor;

	// R[hXg
	if(m_codeList[cur->m_track].IsEmpty())
		return NULL;
	// J[\Ō
	if(cur->m_position==NULL)
		return NULL;

	return (CFlkObj*)m_codeList[cur->m_track].GetNext(cur->m_position);
}

CFlkObj* CFlkCode::PrevCur(CCursor* cur)
// J[\O
{
	if(cur==NULL)
		cur=&m_cursor;

	// R[hXg
	if(m_codeList[cur->m_track].IsEmpty())
		return NULL;

	if(cur->m_position==NULL)
	{
		// J[\Ō
		cur->m_position=m_codeList[cur->m_track].GetTailPosition();
		return NULL;
	}
	else
	{
		CFlkObj* pObj;
		pObj=(CFlkObj*)m_codeList[cur->m_track].GetPrev(cur->m_position);
		if(cur->m_position==NULL)
		{
			// J[\ŏ
			cur->m_position=m_codeList[cur->m_track].GetHeadPosition();
			pObj=(CFlkObj*)m_codeList[cur->m_track].GetHead();
		}
		return pObj;
	}
	return NULL;
}

int CFlkCode::GetCurAbs(CCursor* cur)
// J[\̐ΈʒuԂ
{
	if(cur==NULL)
		cur=&m_cursor;

	// R[hXg
	if(m_codeList[cur->m_track].IsEmpty())
		return 0;

	CFlkObj* pObj;
	int result=0;
	POSITION pos=m_codeList[cur->m_track].GetHeadPosition();

	// J[\ʒu܂ŃR[hXg𑖍
	while(pos)
	{
		if(pos==cur->m_position)
			break;
		pObj=(CFlkObj*)m_codeList[cur->m_track].GetNext(pos);
		result+=(pObj->m_type==Note ? 1 : m_eventLength);
	}

	return result;
}

void CFlkCode::SetCur(CCursor* cur,int iAbs)
// ΈʒuJ[\Ԃ
{
	if(cur==NULL)
		cur=&m_cursor;

	CFlkObj* pObj;
	POSITION pos=m_codeList[cur->m_track].GetHeadPosition();
	int i=0;
	while(pos)
	{
		pObj=(CFlkObj*)m_codeList[cur->m_track].GetAt(pos);
		if(i+(pObj->m_type==Note ? 1 : m_eventLength)>iAbs)
		{
			cur->m_position=pos;
			return;
		}
		else
		{
			m_codeList[cur->m_track].GetNext(pos);
			i+=(pObj->m_type==Note ? 1 : m_eventLength);
		}
	}
	cur->m_position=NULL;
}

void CFlkCode::NextTrack(CCursor* cur=NULL)
// ̃gbN
{
	if(cur==NULL)
		cur=&m_cursor;

	// Ō̃gbN
	if(cur->m_track>=MAX_TRACK-1)
		return;

	int iAbs=GetCurAbs(cur);

	cur->m_track++;

	SetCur(cur,iAbs);
}

void CFlkCode::PrevTrack(CCursor* cur=NULL)
// ÕgbN
{
	if(cur==NULL)
		cur=&m_cursor;

	// ŏ̃gbN
	if(cur->m_track<=0)
		return;

	int iAbs=GetCurAbs(cur);

	cur->m_track--;

	SetCur(cur,iAbs);
}

void CFlkCode::GetHeadCur(CCursor& rCur)
// 擪̃J[\Ԃ
{
	rCur.m_position=m_codeList[rCur.m_track].GetHeadPosition();
}

CFlkObj* CFlkCode::GetAt(CCursor* cur)
// J[\ʒũIuWFNgԂ
{
	if(cur==NULL)
		cur=&m_cursor;

	// J[\Ō
	if(cur->m_position==NULL)
		return NULL;

	return (CFlkObj*)(m_codeList[cur->m_track].GetAt(cur->m_position));
}

void CFlkCode::InsertObj(CString data)
// IuWFNg}
{
	CFlkObj* pNewObj=new CFlkObj;
	pNewObj->SetObj(data);

	InsertObj(NULL,pNewObj);
}

void CFlkCode::InsertObj(CCursor* cur, CFlkObj* pNewObj)
// IuWFNg}
{
	if(cur==NULL)
		cur=&m_cursor;

	if(cur->m_position==NULL)
	{
		// J[\Ō
		m_codeList[cur->m_track].AddTail((CObject*)pNewObj);
	}
	else
	{
		m_codeList[cur->m_track].InsertBefore(cur->m_position,(CObject*)pNewObj);
	}
}

void CFlkCode::RemoveObj(CCursor* cur)
// J[\ʒũIuWFNg폜
{
	if(cur==NULL)
		cur=&m_cursor;

	// R[hXg
	if(m_codeList[cur->m_track].IsEmpty())
		return;

	// J[\Ō
	if(cur->m_position==NULL)
		return;

	CFlkObj *pObj;

	pObj=(CFlkObj*)m_codeList[cur->m_track].GetAt(cur->m_position);
	POSITION pos=cur->m_position;
	m_codeList[cur->m_track].GetNext(cur->m_position);
	m_codeList[cur->m_track].RemoveAt(pos);
	delete pObj;
}

void CFlkCode::RemoveAll(void)
// ׂẴIuWFNg폜
{
	CFlkObj* pObj;
	POSITION pos;
	for(int tr=0;tr<MAX_TRACK;tr++)
	{
		pos=m_codeList[tr].GetHeadPosition();
		while(pos)
		{
			pObj=(CFlkObj*)(m_codeList[tr].GetNext(pos));
			delete pObj;
		}
		m_codeList[tr].RemoveAll();
	}
}

void CFlkCode::RemoveMarkedArea(int iMark, int iEnd)
// w͈͂̃IuWFNg폜
{
	if(iMark==iEnd)
	{
		RemoveObj(NULL);
		return;
	}

	CFlkObj *pObj;
	CCursor cur;
	int i=0;

	cur.m_track=m_cursor.m_track;
	GetHeadCur(cur);

	while(cur.m_position)
	{
		if(cur==m_cursor)
			NextCur(NULL);

		pObj=GetAt(&cur);
		i+=(pObj->m_type==Note ? 1 : m_eventLength);
		if(i>iMark)
			RemoveObj(&cur);
		else
			NextCur(&cur);

		if(i>=iEnd)
			break;
	}
}


void CFlkCode::ReadCode(CString& strCode)
// R[hǂݍ
{
	int tr;
	CString strTrack,head;

	for(tr=0;tr<MAX_TRACK;tr++)
	{
		m_cursor.m_track=tr;
		m_cursor.m_position=NULL;
		head.Format(_T("%d="),tr);
		Extract(strCode,strTrack,head,_T("\r\n"));

		PasteCode(strTrack);
	}
	m_cursor.m_track=0;
	m_cursor.m_position=m_codeList[m_cursor.m_track].GetHeadPosition();
}

void CFlkCode::PasteCode(CString& strCode)
// R[h\t
{
	int cnt=0;
	int len;
	CString str,notes;
	notes.LoadStringW(IDS_NOTES);

	while(cnt<strCode.GetLength())
	{
		if(strCode[cnt]=='[')
		{
			if(strCode.Find(_T("]"),cnt)==-1)
				return;

			len=strCode.Find(_T("]"),cnt)-cnt+1;
			InsertObj(strCode.Mid(cnt,len));
			cnt+=len;
		}
		else
		{
			str=(strCode.Mid(cnt,1)).SpanIncluding(notes);

			if(str!=_T(""))
				InsertObj(str);

			cnt++;
		}
	}
}

void CFlkCode::StoreCode(CArchive& ar)
// R[hۑ
{
	CStringA strBuff;
		
	int tr;
	CFlkObj* pObj;
	CCursor cur;

	strBuff=_T("[Code]\r\n");
	ar.Write(strBuff,strBuff.GetLength());

	for(tr=0;tr<MAX_TRACK;tr++)
	{
		strBuff.Format("%d=",tr);
		cur.m_position=m_codeList[tr].GetHeadPosition();
		cur.m_track=tr;
		while(cur.m_position)
		{
			pObj=NextCur(&cur);
			strBuff+=(CStringA)pObj->GetObj();
		}
			
		strBuff.Insert(strBuff.GetLength(),"\r\n");
		ar.Write(strBuff,strBuff.GetLength());
	}
}

void CFlkCode::Extract(CString& data, CString& result, CString head, CString foot)
// dataheadAfootŋ܂ꂽresultɕԂiheadAfoot͊܂܂Ȃj
{
	int mark;
	int end;
	mark=data.Find(head)+head.GetLength();
	end=data.Find(foot,mark);

	result=data.Mid(mark,end-mark);
}

void CFlkCode::UpdateCode(void)
// Ŝ̃R[h̐ۂ
{
	POSITION posCode,posMaster,posTrack;
	CFlkObj* pObj,* pNewObj;
	CPtrList masterList,trackList;
	int tr;
	PINT piEvent;
	PINT piTrack;
	bool bUpdated=true;

	while(bUpdated)
	{
		// }X^[Xg̍쐬XV
		posMaster=masterList.GetHeadPosition();
		posTrack=trackList.GetHeadPosition();
		while(posMaster && posTrack)
		{
			piEvent=(PINT)masterList.GetNext(posMaster);
			(*piEvent)=0;

			piTrack=(PINT)trackList.GetNext(posTrack);
			(*piTrack)=0;

		}
		for(tr=0;tr<MAX_TRACK;tr++)
		{
			posCode=m_codeList[tr].GetHeadPosition();
			posMaster=masterList.GetHeadPosition();
			posTrack=trackList.GetHeadPosition();
			while(posCode)
			{
				pObj=(CFlkObj*)m_codeList[tr].GetNext(posCode);
				if(posMaster==NULL)
				{
					piEvent=new int;
					(*piEvent)=(pObj->m_type==Note ? 0 : 1);
					masterList.AddTail(piEvent);

					piTrack=new int;
					(*piTrack)=1;
					trackList.AddTail(piTrack);
				}
				else
				{
					piEvent=(PINT)masterList.GetNext(posMaster);
					(*piEvent)+=(pObj->m_type==Note ? 0 : 1);

					piTrack=(PINT)trackList.GetNext(posTrack);
					(*piTrack)++;
				}
			}
		}

		bUpdated=false;
		for(tr=0;tr<MAX_TRACK;tr++)
		{
			posCode=m_codeList[tr].GetHeadPosition();
			posMaster=masterList.GetHeadPosition();
			posTrack=trackList.GetHeadPosition();
			while(posCode)
			{
				pObj=(CFlkObj*)m_codeList[tr].GetAt(posCode);
				piEvent=(PINT)masterList.GetNext(posMaster);
				piTrack=(PINT)trackList.GetNext(posTrack);

				if(((*piEvent)==0) || ((*piEvent)==(*piTrack)))
				{
					m_codeList[tr].GetNext(posCode);
					continue;
				}

				if(pObj->m_type==Note)
				{
					pNewObj=new CFlkObj;
					pNewObj->SetEvent(Null,0,_T(""));
					m_codeList[tr].InsertBefore(posCode,(CObject*)pNewObj);
					bUpdated=true;
				}
				break;
			}
		}
	}

	// }X^[Xg̍폜
	posMaster=masterList.GetHeadPosition();
	posTrack=trackList.GetHeadPosition();
	while(posMaster)
	{
		piEvent=(PINT)masterList.GetNext(posMaster);
		delete piEvent;

		piTrack=(PINT)trackList.GetNext(posTrack);
		delete piTrack;
	}
	masterList.RemoveAll();
	trackList.RemoveAll();

	Compress();
}

void CFlkCode::UpdateCode(int iTrack)
// ̃gbN݂̂ύXꂽƂAۂ
{
	CFlkObj *pObj,*pNewObj;
	PINT piEvent,piNewEvent;
	CPtrList masterList;
	POSITION posMaster,posCode;
	int tr;

	// }X^[Xg̍쐬(ύXꂽgbN)
	for(tr=0;tr<MAX_TRACK;tr++)
	{
		if(tr==iTrack)
			continue;

		posMaster=masterList.GetHeadPosition();
		posCode=m_codeList[tr].GetHeadPosition();
		while(posCode)
		{
			pObj=(CFlkObj*)m_codeList[tr].GetNext(posCode);
			if(posMaster==NULL)
			{
				piEvent=new int;
				(*piEvent)=(pObj->m_type==Note ? 0 : 1);
				masterList.AddTail(piEvent);
			}
			else
			{
				piEvent=(PINT)masterList.GetNext(posMaster);
				ASSERT((*piEvent)==(pObj->m_type==Note ? 0 : 1));
			}
		}
	}

	// }X^[XgƕύXꂽgbN̐ۂ
	posMaster=masterList.GetHeadPosition();
	posCode=m_codeList[iTrack].GetHeadPosition();
	while(posMaster && posCode)
	{
		pObj=(CFlkObj*)m_codeList[iTrack].GetAt(posCode);
		piEvent=(PINT)masterList.GetAt(posMaster);

		if((*piEvent)==0)
		{
			if(pObj->m_type!=Note)
			{
				piNewEvent=new int;
				(*piNewEvent)=1;
				masterList.InsertBefore(posMaster,piNewEvent);
				m_codeList[iTrack].GetNext(posCode);
				continue;
			}
		}
		else
		{
			if(pObj->m_type==Note)
			{
				pNewObj=new CFlkObj;
				pNewObj->SetEvent(Null,0,_T(""));
				m_codeList[iTrack].InsertBefore(posCode,pNewObj);
				masterList.GetNext(posMaster);
				continue;
			}
		}
		masterList.GetNext(posMaster);
		m_codeList[iTrack].GetNext(posCode);
	}
	
	// }X^[XgR[hXg֔f
	for(tr=0;tr<MAX_TRACK;tr++)
	{
		if(tr==iTrack)
			continue;

		posMaster=masterList.GetHeadPosition();
		posCode=m_codeList[tr].GetHeadPosition();
		while(posCode && posMaster)
		{
			pObj=(CFlkObj*)m_codeList[tr].GetAt(posCode);
			piEvent=(PINT)masterList.GetAt(posMaster);

			if(((*piEvent)==1) && (pObj->m_type==Note))
			{
				pNewObj=new CFlkObj;
				pNewObj->SetEvent(Null,0,_T(""));
				m_codeList[tr].InsertBefore(posCode,pNewObj);
				masterList.GetNext(posMaster);
			}
			else
			{
				masterList.GetNext(posMaster);
				m_codeList[iTrack].GetNext(posCode);
			}
		}
	}

	// }X^[Xg̍폜
	posMaster=masterList.GetHeadPosition();
	while(posMaster)
	{
		piEvent=(PINT)masterList.GetNext(posMaster);
		delete piEvent;
	}
	masterList.RemoveAll();
	
	Compress();
}

void CFlkCode::Compress(void)
// NullCxĝ݂ŏoCl߂
{
	POSITION posDel,posCode,posMaster;
	CFlkObj* pObj;
	CPtrList masterList;
	int tr;
	PINT piEvent;

	// }X^[Xg̍쐬
	for(tr=0;tr<MAX_TRACK;tr++)
	{
		posCode=m_codeList[tr].GetHeadPosition();
		posMaster=masterList.GetHeadPosition();
		while(posCode)
		{
			pObj=(CFlkObj*)m_codeList[tr].GetNext(posCode);
			if(posMaster==NULL)
			{
				piEvent=new int;
				(*piEvent)=(pObj->m_type==Null ? 0 : 1);
				masterList.AddTail(piEvent);
			}
			else
			{
				piEvent=(PINT)masterList.GetNext(posMaster);
				(*piEvent)+=(pObj->m_type==Null ? 0 : 1);
			}
		}
	}

	// C
	for(tr=0;tr<MAX_TRACK;tr++)
	{
		posCode=m_codeList[tr].GetHeadPosition();
		posMaster=masterList.GetHeadPosition();
		while(posCode && posMaster)
		{
			posDel=posCode;
			pObj=(CFlkObj*)m_codeList[tr].GetNext(posCode);
			piEvent=(PINT)masterList.GetNext(posMaster);

			if((*piEvent)==0)
			{
				if(posDel==m_cursor.m_position)
					m_cursor.m_position=posCode;

				delete pObj;
				m_codeList[tr].RemoveAt(posDel);
			}
		}
	}

	// }X^[Xg̍폜
	posMaster=masterList.GetHeadPosition();
	while(posMaster)
	{
		piEvent=(PINT)masterList.GetNext(posMaster);
		delete piEvent;
	}
	masterList.RemoveAll();
}
int CFlkCode::PageMark()
// y[WIԂɂ
{
	CFlkObj* pObj;
	CCursor curMarkStart,curMarkEnd;
	int iMark=GetCurAbs(NULL);

	curMarkStart=m_cursor;
	curMarkEnd=m_cursor;

	while(curMarkStart.m_position)
	{
		pObj=GetAt(&curMarkStart);

		if((pObj->m_type==Kernel) && (pObj->m_index==8))
			// PageBegin𔭌
		{
			iMark=GetCurAbs(&curMarkStart)+m_eventLength;
			break;
		}
		m_codeList[curMarkStart.m_track].GetPrev(curMarkStart.m_position);
	}
	
	while(curMarkEnd.m_position)
	{
		pObj=GetAt(&curMarkEnd);

		if((pObj->m_type==Kernel) && (pObj->m_index==9))
			// PageEnd𔭌
		{
			m_cursor=curMarkEnd;
			break;
		}
		m_codeList[curMarkEnd.m_track].GetNext(curMarkEnd.m_position);
	}

	return iMark;
}
