#pragma once

#include "flkobj.h"

#define MAX_TRACK 19

// CCursorNX

class CCursor
{
public:
	POSITION m_position;
	int m_track;
public:
	CCursor()
	{
		m_position=NULL;
		m_track=0;
	};

	bool operator==(CCursor& cur)
	{
		return ((m_position==cur.m_position) && (m_track==cur.m_track));
	};

	bool operator!=(CCursor& cur)
	{
		return ((m_position!=cur.m_position) || (m_track!=cur.m_track));
	};
};

// CFlkCode R}h ^[Qbg

class CFlkCode : public CObject
{
public:
	CFlkCode();
	virtual ~CFlkCode();
	CObList m_codeList[MAX_TRACK];
	CCursor m_cursor;
	CFlkObj* NextCur(CCursor* cur);
	CFlkObj* PrevCur(CCursor* cur);
	int GetCurAbs(CCursor* cur);
	void SetCur(CCursor* cur,int iAbs);
	void NextTrack(CCursor* cur);
	void PrevTrack(CCursor* cur);
	void GetHeadCur(CCursor& rCur);
	CFlkObj* GetAt(CCursor* cur);
	void InsertObj(CString data);
	void InsertObj(CCursor* cur, CFlkObj* pNewObj);
	void RemoveObj(CCursor* cur);
	void RemoveAll(void);
	void ReadCode(CString& strCode);
	void StoreCode(CArchive& ar);
	void Extract(CString& data, CString& result, CString head, CString foot);
	int m_eventLength;
	void UpdateCode(void);
	void Compress(void);
	void UpdateCode(int iTrack);
	void PasteCode(CString& strCode);
	void RemoveMarkedArea(int iMark, int iEnd);
	int PageMark();
};

