// FlkEditView.cpp : CFlkEditView NX̎
//

#include "stdafx.h"
#include "FlkEdit.h"

#include "FlkEditDoc.h"
#include "FlkEditView.h"

#include "FlkObj.h"
#include "EventSettingDlg.h"
#include "HeaderInfoDlg.h"

#define LEFT_MARGIN pDoc->m_noteSize.cx*3+2

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CFlkEditView

IMPLEMENT_DYNCREATE(CFlkEditView, CView)

BEGIN_MESSAGE_MAP(CFlkEditView, CView)
	// WR}h
	ON_COMMAND(ID_FILE_PRINT, &CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, &CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, &CView::OnFilePrintPreview)
	ON_WM_CHAR()
	ON_WM_KEYDOWN()
	ON_WM_HSCROLL()
	ON_WM_MOUSEWHEEL()
	ON_WM_LBUTTONDOWN()
	ON_COMMAND(IDM_HEADER_INFO, &CFlkEditView::OnHeaderInfo)
	ON_WM_LBUTTONUP()
	ON_WM_MOUSEMOVE()
	ON_COMMAND(ID_EDIT_COPY, &CFlkEditView::OnEditCopy)
	ON_UPDATE_COMMAND_UI(ID_EDIT_COPY, &CFlkEditView::OnUpdateEditCopy)
	ON_COMMAND(ID_EDIT_CUT, &CFlkEditView::OnEditCut)
	ON_UPDATE_COMMAND_UI(ID_EDIT_CUT, &CFlkEditView::OnUpdateEditCut)
	ON_COMMAND(ID_EDIT_PASTE, &CFlkEditView::OnEditPaste)
	ON_UPDATE_COMMAND_UI(ID_EDIT_PASTE, &CFlkEditView::OnUpdateEditPaste)
	ON_WM_LBUTTONDBLCLK()
	ON_COMMAND(IDM_INSERT_EVENT, &CFlkEditView::OnInsertEvent)
	ON_COMMAND(IDM_LEFT_EDGE, &CFlkEditView::OnLeftEdge)
	ON_COMMAND(IDM_RIGHT_EDGE, &CFlkEditView::OnRightEdge)
	ON_COMMAND(IDM_PAGE_LEFT, &CFlkEditView::OnPageLeft)
	ON_COMMAND(IDM_PAGE_RIGHT, &CFlkEditView::OnPageRight)
	ON_WM_RBUTTONDBLCLK()
//	ON_WM_RBUTTONDOWN()
ON_WM_RBUTTONDOWN()
ON_COMMAND(ID_PAGE_SET, &CFlkEditView::OnPageSet)
ON_COMMAND(ID_EDIT_SELECT_ALL, &CFlkEditView::OnEditSelectAll)
ON_WM_VSCROLL()
END_MESSAGE_MAP()

// CFlkEditView RXgNV/fXgNV

CFlkEditView::CFlkEditView()
: m_BasePoint(0,0)
, m_bLButtonDown(false)
{
	// TODO: \zR[hɒǉ܂B

	m_fntNormalInfo.lfHeight=20;
	m_fntNormalInfo.lfWidth=0;
	m_fntNormalInfo.lfEscapement=0;
	m_fntNormalInfo.lfOrientation=0;
	m_fntNormalInfo.lfWeight=400;
	m_fntNormalInfo.lfItalic=0;
	m_fntNormalInfo.lfUnderline=0;
	m_fntNormalInfo.lfStrikeOut=0;
	m_fntNormalInfo.lfCharSet=128;
	m_fntNormalInfo.lfOrientation=3;
	m_fntNormalInfo.lfClipPrecision=2;
	m_fntNormalInfo.lfQuality=1;
	m_fntNormalInfo.lfPitchAndFamily=49;
	wcscpy_s(m_fntNormalInfo.lfFaceName,32,L"MS SVbN");

	m_fntSmallInfo=m_fntNormalInfo;
	m_fntSmallInfo.lfHeight=10;
}

CFlkEditView::~CFlkEditView()
{
}

BOOL CFlkEditView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: ̈ʒu CREATESTRUCT cs C Window NX܂̓X^C
	//  CĂB

	return CView::PreCreateWindow(cs);
}

// CFlkEditView `

void CFlkEditView::OnDraw(CDC* pDC)
{
	CFlkEditDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
	if (!pDoc)
		return;

	// TODO: ̏ꏊɃlCeBu f[^p̕`R[hǉ܂B
	CRect rectClient;
	GetClientRect(rectClient);

	DrawCode(pDC,pDoc,rectClient);
	DrawCursor(pDC,pDoc);
	DrawIndex(pDC,pDoc);

	UpdateScrollInfo();
}

// CFlkEditView 

BOOL CFlkEditView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// ̈
	return DoPreparePrinting(pInfo);
}

void CFlkEditView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: O̓ʂȏǉĂB
}

void CFlkEditView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: ̌㏈ǉĂB
}


// CFlkEditView ff

#ifdef _DEBUG
void CFlkEditView::AssertValid() const
{
	CView::AssertValid();
}

void CFlkEditView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CFlkEditDoc* CFlkEditView::GetDocument() const // fobOȊÕo[W̓CCłB
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CFlkEditDoc)));
	return (CFlkEditDoc*)m_pDocument;
}
#endif //_DEBUG

//////////////////////////////////////////////////////////////////////////
// CFlkEditView bZ[W nh
//////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////
// `
//////////////////////////////////////////////////////////////////////////

void CFlkEditView::DrawCode(CDC* pDC, CFlkEditDoc* pDoc, CRect& rectClient)
// R[h`
{
	CFlkObj* pObj;
	CCursor cur;
	CString ev,lst,pr;
	CRect rectClip;
	int bkMode;
	int token;
	int i;
	CFont fntNormal,fntSmall;
	CFont* pfntOld;
	COLORREF clrEventBack(0xffcccc);
	COLORREF clrNoteBack(pDC->GetBkColor());
	COLORREF clrText[4]={0x000000,0x006600,0x660000,0x0000cc};
	COLORREF clrTextOld=pDC->GetTextColor();

	// tHg̏
	m_fntNormalInfo.lfHeight=pDoc->m_noteSize.cy;
	fntNormal.CreateFontIndirectW(&m_fntNormalInfo);
	m_fntSmallInfo.lfHeight=pDoc->m_eventSize.cy;
	fntSmall.CreateFontIndirectW(&m_fntSmallInfo);

	pfntOld=pDC->SelectObject(&fntNormal);

	bkMode=pDC->SetBkMode(TRANSPARENT);

	for(int tr=0;tr<MAX_TRACK;tr++)
	{
		if(tr<m_BasePoint.y)
			continue;
		if(tr>m_BasePoint.y+rectClient.Height()/pDoc->m_eventSize.cy/2)
			break;

		i=0;
		cur.m_track=tr;
		pDoc->m_flkCode.GetHeadCur(cur);
		while(cur.m_position)
		{
			pObj=pDoc->m_flkCode.NextCur(&cur);
			if((i-m_BasePoint.x+pDoc->m_flkCode.m_eventLength)*pDoc->m_noteSize.cx<rectClient.left)
			{
				i+=(pObj->m_type==Note ? 1 : pDoc->m_flkCode.m_eventLength);
				continue;
			}
			if((i-m_BasePoint.x)*pDoc->m_noteSize.cx>rectClient.right)
				break;

			switch(pObj->m_type)
			{
			case Null:
				rectClip=CRect(CPoint((i-m_BasePoint.x)*pDoc->m_noteSize.cx+rectClient.left+LEFT_MARGIN,(tr-m_BasePoint.y)*pDoc->m_eventSize.cy*2),
					CSize(pDoc->m_noteSize.cx*pDoc->m_flkCode.m_eventLength,pDoc->m_eventSize.cy*2));
				pDC->FillSolidRect(rectClip,clrEventBack);
				break;
			case Note:
				pDC->SelectObject(&fntNormal);
				pDC->SetTextColor(clrText[0]);
				rectClip=CRect(CPoint((i-m_BasePoint.x)*pDoc->m_noteSize.cx+rectClient.left+LEFT_MARGIN,(tr-m_BasePoint.y)*pDoc->m_eventSize.cy*2),pDoc->m_noteSize);
				pDC->FillSolidRect(rectClip,clrNoteBack);
				pDC->DrawText(pObj->m_value,rectClip,DT_NOCLIP);
				break;
			case Kernel:
				pDC->SelectObject(&fntSmall);
				pDC->SetTextColor(clrText[1]);
				lst.LoadStringW(IDS_EVENT_KERNEL_0+pObj->m_index);
				token=lst.Find(_T("/"));
				if(pObj->m_index==3)// ProgramCxg
				{
					pr.LoadStringW(IDS_EVENT_PROGRAM_0+_wtoi(pObj->m_value));
					ev.Format(_T("%s\r\n%s"),lst.Mid(0,token),pr);
					rectClip=CRect(CPoint((i-m_BasePoint.x)*pDoc->m_noteSize.cx+rectClient.left+LEFT_MARGIN,(tr-m_BasePoint.y)*pDoc->m_eventSize.cy*2),
						CSize(pDoc->m_noteSize.cx*pDoc->m_flkCode.m_eventLength,pDoc->m_eventSize.cy*2));
					pDC->FillSolidRect(rectClip,clrEventBack);
					pDC->DrawText(ev,rectClip,DT_EDITCONTROL);
				}
				else
				{
					ev.Format(_T("%s\r\n%s"),lst.Mid(0,token),pObj->m_value);
					rectClip=CRect(CPoint((i-m_BasePoint.x)*pDoc->m_noteSize.cx+rectClient.left+LEFT_MARGIN,(tr-m_BasePoint.y)*pDoc->m_eventSize.cy*2),
						CSize(pDoc->m_noteSize.cx*pDoc->m_flkCode.m_eventLength,pDoc->m_eventSize.cy*2));
					pDC->FillSolidRect(rectClip,clrEventBack);
					pDC->DrawText(ev,rectClip,DT_EDITCONTROL);
				}
				break;
			case Control:
				pDC->SelectObject(&fntSmall);
				pDC->SetTextColor(clrText[2]);
				lst.LoadStringW(IDS_EVENT_CONTROL_0+pObj->m_index);
				token=lst.Find(_T("/"));
				ev.Format(_T("%s\r\n%s"),lst.Mid(0,token),pObj->m_value);
				rectClip=CRect(CPoint((i-m_BasePoint.x)*pDoc->m_noteSize.cx+rectClient.left+LEFT_MARGIN,(tr-m_BasePoint.y)*pDoc->m_eventSize.cy*2),
					CSize(pDoc->m_noteSize.cx*pDoc->m_flkCode.m_eventLength,pDoc->m_eventSize.cy*2));
				pDC->FillSolidRect(rectClip,clrEventBack);
				pDC->DrawText(ev,rectClip,DT_EDITCONTROL);
				break;
			case System:
				pDC->SelectObject(&fntSmall);
				pDC->SetTextColor(clrText[3]);
				lst.LoadStringW(IDS_EVENT_SYSTEM_0+pObj->m_index);
				token=lst.Find(_T("/"));
				ev.Format(_T("%s\r\n%s"),lst.Mid(0,token),pObj->m_value);
				rectClip=CRect(CPoint((i-m_BasePoint.x)*pDoc->m_noteSize.cx+rectClient.left+LEFT_MARGIN,(tr-m_BasePoint.y)*pDoc->m_eventSize.cy*2),
					CSize(pDoc->m_noteSize.cx*pDoc->m_flkCode.m_eventLength,pDoc->m_eventSize.cy*2));
				pDC->FillSolidRect(rectClip,clrEventBack);
				pDC->DrawText(ev,rectClip,DT_EDITCONTROL);
				break;
			}
			
			i+=(pObj->m_type==Note ? 1 : pDoc->m_flkCode.m_eventLength);
		}
	}

	pDC->SelectObject(pfntOld);
	pDC->SetBkMode(bkMode);
	pDC->SetTextColor(clrTextOld);

	fntNormal.DeleteObject();
	fntSmall.DeleteObject();
}

void CFlkEditView::DrawCursor(CDC* pDC, CFlkEditDoc* pDoc)
// J[\`
{
	CRect rectCur;
	CFlkObj* pObj=pDoc->m_flkCode.GetAt(NULL);
	int iCur=pDoc->m_flkCode.GetCurAbs(NULL)-m_BasePoint.x;
	int iCurBefore=pDoc->m_curBefore-m_BasePoint.x;
	CPoint ptCur[2];

	if(iCur==iCurBefore)
	{
		ptCur[0].SetPoint(iCur*pDoc->m_noteSize.cx+LEFT_MARGIN,(pDoc->m_flkCode.m_cursor.m_track-m_BasePoint.y)*pDoc->m_eventSize.cy*2);
		ptCur[1].SetPoint(iCur*pDoc->m_noteSize.cx+LEFT_MARGIN+1,(pDoc->m_flkCode.m_cursor.m_track-m_BasePoint.y+1)*pDoc->m_eventSize.cy*2);
	}
	else
	{
		ptCur[0].SetPoint(iCur*pDoc->m_noteSize.cx+LEFT_MARGIN,(pDoc->m_flkCode.m_cursor.m_track-m_BasePoint.y)*pDoc->m_eventSize.cy*2);
		ptCur[1].SetPoint(iCurBefore*pDoc->m_noteSize.cx+LEFT_MARGIN,(pDoc->m_flkCode.m_cursor.m_track-m_BasePoint.y+1)*pDoc->m_eventSize.cy*2);
	}

	rectCur=CRect(ptCur[0],ptCur[1]);
	rectCur.NormalizeRect();

	pDC->InvertRect(rectCur);
}

void CFlkEditView::DrawIndex(CDC* pDC, CFlkEditDoc* pDoc)
// m[g̃CfbNX`
{
	CRect rectLeftMargin(CPoint(-m_BasePoint.x*pDoc->m_noteSize.cx,-m_BasePoint.y*pDoc->m_eventSize.cy*2)
		,CSize(LEFT_MARGIN-1,MAX_TRACK*pDoc->m_eventSize.cy*2));

	pDC->FillSolidRect(rectLeftMargin,0x999999);

	CFont fnt;
	CFont* pfntOld;

	m_fntNormalInfo.lfHeight=pDoc->m_noteSize.cy;
	fnt.CreateFontIndirectW(&m_fntNormalInfo);

	pfntOld=pDC->SelectObject(&fnt);
	COLORREF clrText=pDC->SetTextColor(0xFFFFFF);

	pDC->TextOut(-m_BasePoint.x*pDoc->m_noteSize.cx,-m_BasePoint.y*pDoc->m_eventSize.cy*2,_T("SYS"));
	CString index;
	for(int tr=1;tr<MAX_TRACK;tr++)
	{
		if(tr<=15)
			index.Format(_T("N%02d"),tr);
		else
			index.Format(_T("R%02d"),tr-15);

		pDC->TextOut(-m_BasePoint.x*pDoc->m_noteSize.cx,(tr-m_BasePoint.y)*pDoc->m_eventSize.cy*2,index);
	}

	pDC->SetTextColor(clrText);
	pDC->SelectObject(pfntOld);
}


//////////////////////////////////////////////////////////////////////////
// L[{[h
//////////////////////////////////////////////////////////////////////////

void CFlkEditView::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags)
// ͂ꂽ
{
	CFlkEditDoc* pDoc=GetDocument();
	int curAbs=pDoc->m_flkCode.GetCurAbs(NULL);
	CRect rectClient;
	GetClientRect(rectClient);

	CString notes;
	notes.LoadStringW(IDS_NOTES);
	if((nChar>='o') && (nChar<='z'))
		pDoc->m_flkCode.InsertObj(notes.Mid(nChar-'o',1));
	if((nChar>='a') && (nChar<='l'))
		pDoc->m_flkCode.InsertObj(notes.Mid(nChar-'a'+12,1));
	if((nChar>='A') && (nChar<='X'))
		pDoc->m_flkCode.InsertObj(notes.Mid(nChar-'A'+24,1));
	if(nChar=='-')
		pDoc->m_flkCode.InsertObj(_T("-"));
	if(nChar=='/')
		pDoc->m_flkCode.InsertObj(_T("/"));

	while((curAbs-m_BasePoint.x)*pDoc->m_noteSize.cx>=rectClient.right)
		m_BasePoint.x+=rectClient.Width()/pDoc->m_noteSize.cx/2;
	
	pDoc->m_curBefore=pDoc->m_flkCode.GetCurAbs(NULL);

	pDoc->m_flkCode.UpdateCode(pDoc->m_flkCode.m_cursor.m_track);
	pDoc->UpdateAllViews(NULL);
	pDoc->SetModifiedFlag();

	CView::OnChar(nChar, nRepCnt, nFlags);
}

void CFlkEditView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags)
// L[{[hꂽ
{
	CFlkEditDoc* pDoc=GetDocument();
	CDC* pDC=GetDC();
	int curAbs=pDoc->m_flkCode.GetCurAbs(NULL);
	CRect rectClient;
	GetClientRect(rectClient);

	switch(nChar)
	{
	case VK_RIGHT:
		DrawCursor(pDC,pDoc);
		pDoc->m_flkCode.NextCur(NULL);
		if(GetKeyState(VK_SHIFT)>=0)
			pDoc->m_curBefore=pDoc->m_flkCode.GetCurAbs(NULL);
		DrawCursor(pDC,pDoc);
		pDoc->UpdateAllViews(this);
		break;
	case VK_LEFT:
		DrawCursor(pDC,pDoc);
		pDoc->m_flkCode.PrevCur(NULL);
		if(GetKeyState(VK_SHIFT)>=0)
			pDoc->m_curBefore=pDoc->m_flkCode.GetCurAbs(NULL);
		DrawCursor(pDC,pDoc);
		pDoc->UpdateAllViews(this);
		break;
	case VK_UP:
		DrawCursor(pDC,pDoc);
		pDoc->m_flkCode.PrevTrack(NULL);
		if(GetKeyState(VK_SHIFT)>=0)
			pDoc->m_curBefore=pDoc->m_flkCode.GetCurAbs(NULL);
		DrawCursor(pDC,pDoc);
		pDoc->UpdateAllViews(this);
		break;
	case VK_DOWN:
		DrawCursor(pDC,pDoc);
		pDoc->m_flkCode.NextTrack(NULL);
		if(GetKeyState(VK_SHIFT)>=0)
			pDoc->m_curBefore=pDoc->m_flkCode.GetCurAbs(NULL);
		DrawCursor(pDC,pDoc);
		pDoc->UpdateAllViews(this);
		break;
	case VK_DELETE:
		{
			int iMark=pDoc->m_curBefore;
			int iEnd=pDoc->m_flkCode.GetCurAbs(NULL);
			
			if(iEnd<iMark)
			{
				int iBuf=iEnd;
				iEnd=iMark;
				iMark=iBuf;
			}
			pDoc->m_flkCode.RemoveMarkedArea(iMark,iEnd);

			pDoc->m_flkCode.UpdateCode(pDoc->m_flkCode.m_cursor.m_track);
			pDoc->UpdateAllViews(NULL);
			pDoc->SetModifiedFlag();
		}
		break;
	case VK_BACK:
		{
			int iMark=pDoc->m_curBefore;
			int iEnd=pDoc->m_flkCode.GetCurAbs(NULL);

			if(iEnd<iMark)
			{
				int iBuf=iEnd;
				iEnd=iMark;
				iMark=iBuf;
			}
			if(iEnd==0)
				break;

			pDoc->m_flkCode.PrevCur(NULL);
			pDoc->m_flkCode.RemoveMarkedArea(iMark,iEnd);

			pDoc->m_flkCode.UpdateCode(pDoc->m_flkCode.m_cursor.m_track);
			pDoc->UpdateAllViews(NULL);
			pDoc->SetModifiedFlag();
		}
		break;
	case VK_SPACE:
		OnInsertEvent();
		break;
	}
	while((curAbs-m_BasePoint.x)*pDoc->m_noteSize.cx>=rectClient.right)
	{
		m_BasePoint.x+=rectClient.Width()/pDoc->m_noteSize.cx/2;
		pDoc->UpdateAllViews(NULL);
	}
	while((curAbs-m_BasePoint.x)*pDoc->m_noteSize.cx<rectClient.left)
	{
		m_BasePoint.x=max(0,m_BasePoint.x-rectClient.Width()/pDoc->m_noteSize.cx/2);
		pDoc->UpdateAllViews(NULL);
	}

	while((pDoc->m_flkCode.m_cursor.m_track-m_BasePoint.y)*pDoc->m_eventSize.cy*2>=rectClient.bottom)
	{
		m_BasePoint.y+=rectClient.Height()/pDoc->m_eventSize.cy/4;
		pDoc->UpdateAllViews(NULL);
	}
	while((pDoc->m_flkCode.m_cursor.m_track-m_BasePoint.y)*pDoc->m_eventSize.cy*2<rectClient.top)
	{
		m_BasePoint.y=max(0,m_BasePoint.y-rectClient.Height()/pDoc->m_eventSize.cy/4);
		pDoc->UpdateAllViews(NULL);
	}

	ReleaseDC(pDC);

	CView::OnKeyDown(nChar, nRepCnt, nFlags);
}

//////////////////////////////////////////////////////////////////////////
// XN[
//////////////////////////////////////////////////////////////////////////

void CFlkEditView::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
// XN[o[삳ꂽ
{
	SCROLLINFO sInfo;
	GetScrollInfo(SB_HORZ,&sInfo,SIF_ALL);

	switch (nSBCode)
	{
	case SB_LEFT:// [փXN[
		sInfo.nPos=sInfo.nMin;
		break;

	case SB_RIGHT:// E[փXN[
		sInfo.nPos=sInfo.nMax;
		break;

	case SB_ENDSCROLL:// XN[I
		break;

	case SB_LINELEFT:// PփXN[
		if(sInfo.nPos>sInfo.nMin)
		   sInfo.nPos--;
		break;

	case SB_LINERIGHT:// PEփXN[
		if (sInfo.nPos<sInfo.nMax)
			sInfo.nPos++;
		break;

	case SB_PAGELEFT:// Py[WփXN[
		if(sInfo.nPos>sInfo.nMin)
			sInfo.nPos=max(sInfo.nMin,sInfo.nPos-(int)sInfo.nPage);
		break;

	case SB_PAGERIGHT:// Py[WEփXN[
		if(sInfo.nPos<sInfo.nMax)
			sInfo.nPos=min(sInfo.nMax,sInfo.nPos+(int)sInfo.nPage);
		break;

	case SB_THUMBPOSITION: // wʒuɃXN[
		sInfo.nPos=nPos;
		break;

	case SB_THUMBTRACK:// XN[
		sInfo.nPos=nPos;
		break;
	}
	m_BasePoint.x=sInfo.nPos;
	SetScrollInfo(SB_HORZ,&sInfo,TRUE);
	InvalidateRect(NULL,TRUE);

	CView::OnHScroll(nSBCode, nPos, pScrollBar);
}

void CFlkEditView::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
// XN[o[삳ꂽ
{
	SCROLLINFO sInfo;
	GetScrollInfo(SB_VERT,&sInfo,SIF_ALL);

	switch (nSBCode)
	{
	case SB_TOP:// [փXN[
		sInfo.nPos=sInfo.nMin;
		break;

	case SB_BOTTOM:// [փXN[
		sInfo.nPos=sInfo.nMax;
		break;

	case SB_ENDSCROLL:// XN[I
		break;

	case SB_LINEUP:// 1gbNփXN[
	case SB_PAGEUP:
		if(sInfo.nPos>sInfo.nMin)
		   sInfo.nPos--;
		break;

	case SB_LINEDOWN:// 1gbNփXN[
	case SB_PAGEDOWN:
		if (sInfo.nPos<sInfo.nMax)
			sInfo.nPos++;
		break;

	case SB_THUMBPOSITION: // wʒuɃXN[
		sInfo.nPos=nPos;
		break;

	case SB_THUMBTRACK:// XN[
		sInfo.nPos=nPos;
		break;
	}
	m_BasePoint.y=sInfo.nPos;
	SetScrollInfo(SB_VERT,&sInfo,TRUE);
	InvalidateRect(NULL,TRUE);

	CView::OnVScroll(nSBCode, nPos, pScrollBar);
}

void CFlkEditView::UpdateScrollInfo(void)
// XN[o[̍XV
{
	CFlkEditDoc* pDoc=GetDocument();
	CRect rectClient;
	GetClientRect(rectClient);

	SCROLLINFO hsInfo,vsInfo;
	CCursor cur;
	int scrollMax=rectClient.Width()/pDoc->m_noteSize.cx;


	cur.m_position=NULL;
	for(cur.m_track=0;cur.m_track<MAX_TRACK;cur.m_track++)
	{
		if(scrollMax<pDoc->m_flkCode.GetCurAbs(&cur))
			scrollMax=pDoc->m_flkCode.GetCurAbs(&cur);
	}

	hsInfo.cbSize=sizeof(SCROLLINFO);
	hsInfo.fMask=SIF_ALL;
	hsInfo.nMax=scrollMax+LEFT_MARGIN/pDoc->m_noteSize.cx;
	hsInfo.nMin=0;
	hsInfo.nPage=rectClient.Width()/pDoc->m_noteSize.cx;
	hsInfo.nPos=m_BasePoint.x;
	hsInfo.nTrackPos=0;

	SetScrollInfo(SB_HORZ,&hsInfo,TRUE);

	vsInfo.cbSize=sizeof(SCROLLINFO);
	vsInfo.fMask=SIF_ALL;
	vsInfo.nMax=max(MAX_TRACK-rectClient.Height()/pDoc->m_eventSize.cy/2,1);
	vsInfo.nMin=0;
	vsInfo.nPage=1;
	vsInfo.nPos=m_BasePoint.y;
	vsInfo.nTrackPos=0;

	SetScrollInfo(SB_VERT,&vsInfo,TRUE);
}

//////////////////////////////////////////////////////////////////////////
// }EX
//////////////////////////////////////////////////////////////////////////

BOOL CFlkEditView::OnMouseWheel(UINT nFlags, short zDelta, CPoint pt)
// }EXzC[삳ꂽ
{
	SCROLLINFO sInfo;
	GetScrollInfo(SB_HORZ,&sInfo,SIF_ALL);

	if(nFlags==MK_RBUTTON)
		sInfo.nPos-=(int)(sInfo.nPage)*zDelta/120;
	else
		sInfo.nPos-=zDelta/120;

	if(sInfo.nPos<sInfo.nMin)
		sInfo.nPos=sInfo.nMin;

	if(sInfo.nPos>sInfo.nMax)
		sInfo.nPos=sInfo.nMax;

	m_BasePoint.x=sInfo.nPos;
	SetScrollInfo(SB_HORZ,&sInfo,TRUE);
	InvalidateRect(NULL,TRUE);
	
	return CView::OnMouseWheel(nFlags, zDelta, pt);
}

void CFlkEditView::OnLButtonDown(UINT nFlags, CPoint point)
// {^ꂽ
{
	CFlkEditDoc* pDoc=GetDocument();
	CDC* pDC=GetDC();

	DrawCursor(pDC,pDoc);

	pDoc->m_flkCode.m_cursor=PointToCur(point);
	pDoc->m_curBefore=pDoc->m_flkCode.GetCurAbs(NULL);

	DrawCursor(pDC,pDoc);

	ReleaseDC(pDC);

	m_bLButtonDown=true;
	SetCapture();
	pDoc->UpdateAllViews(this);

	CView::OnLButtonDown(nFlags, point);
}

void CFlkEditView::OnLButtonUp(UINT nFlags, CPoint point)
// {^ꂽ
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B
	CFlkEditDoc* pDoc=GetDocument();
	CDC* pDC=GetDC();

	DrawCursor(pDC,pDoc);

	pDoc->m_flkCode.SetCur(NULL,point.x/pDoc->m_noteSize.cx+m_BasePoint.x);

	DrawCursor(pDC,pDoc);

	ReleaseDC(pDC);
	m_bLButtonDown=false;
	ReleaseCapture();
	pDoc->UpdateAllViews(this);

	CView::OnLButtonUp(nFlags, point);
}

void CFlkEditView::OnMouseMove(UINT nFlags, CPoint point)
// }EX
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B
	if(m_bLButtonDown)
	{
		CFlkEditDoc* pDoc=GetDocument();
		CDC* pDC=GetDC();

		DrawCursor(pDC,pDoc);

		pDoc->m_flkCode.SetCur(NULL,point.x/pDoc->m_noteSize.cx+m_BasePoint.x);

		DrawCursor(pDC,pDoc);

		ReleaseDC(pDC);

		pDoc->UpdateAllViews(this);
	}
	
	CView::OnMouseMove(nFlags, point);
}

void CFlkEditView::OnLButtonDblClk(UINT nFlags, CPoint point)
// {^_uNbNꂽ
{
	CFlkEditDoc* pDoc=GetDocument();

	CFlkObj* pObj=pDoc->m_flkCode.GetAt(NULL);
	if(pObj!=NULL)
	{
		if(pObj->m_type!=Note)
		{
			CEventSettingDlg dlg;

			dlg.m_comboType=pObj->m_type;
			dlg.m_index=pObj->m_index;
			dlg.m_value=pObj->m_value;

			if(dlg.DoModal()==IDOK)
			{
				pObj->SetEvent((TYPE)dlg.m_comboType,dlg.m_index,dlg.m_value);

				pDoc->m_flkCode.UpdateCode(pDoc->m_flkCode.m_cursor.m_track);
				pDoc->UpdateAllViews(NULL);
				pDoc->SetModifiedFlag();
			}
		}
	}
	
	CView::OnLButtonDblClk(nFlags, point);
}

void CFlkEditView::OnRButtonDblClk(UINT nFlags, CPoint point)
// E{^_uNbNꂽ
{
	CFlkEditDoc* pDoc=GetDocument();

	pDoc->m_flkCode.m_cursor=PointToCur(point);

	pDoc->m_curBefore=pDoc->m_flkCode.PageMark();
	pDoc->UpdateAllViews(NULL);

	CView::OnRButtonDblClk(nFlags, point);
}

CCursor CFlkEditView::PointToCur(CPoint &point)
// CPointCCursorɕϊ
{
	CFlkEditDoc* pDoc=GetDocument();
	CCursor cur;

	cur.m_track=point.y/(pDoc->m_eventSize.cy*2)+m_BasePoint.y;
	if(cur.m_track>=MAX_TRACK)
		cur.m_track=MAX_TRACK-1;

	pDoc->m_flkCode.SetCur(&cur,point.x/pDoc->m_noteSize.cx+m_BasePoint.x);

	return cur;
}

void CFlkEditView::OnRButtonDown(UINT nFlags, CPoint point)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B

	CView::OnRButtonDown(nFlags, point);
}


//////////////////////////////////////////////////////////////////////////
// j[
//////////////////////////////////////////////////////////////////////////

void CFlkEditView::OnHeaderInfo()
// ȏ
{
	CFlkEditDoc* pDoc=GetDocument();
	CHeaderInfoDlg dlg;
	dlg.m_editBulder=pDoc->m_flkHeader.m_builder;
	dlg.m_editComment=pDoc->m_flkHeader.m_comment;
	dlg.m_editDevice=pDoc->m_flkHeader.m_device;
	dlg.m_editTimeBase=pDoc->m_flkHeader.m_timebase;
	dlg.m_editTitle=pDoc->m_flkHeader.m_title;

	if(dlg.DoModal()==IDOK)
	{
		pDoc->m_flkHeader.m_builder=dlg.m_editBulder;
		pDoc->m_flkHeader.m_comment=dlg.m_editComment;
		pDoc->m_flkHeader.m_device=dlg.m_editDevice;
		pDoc->m_flkHeader.m_timebase=dlg.m_editTimeBase;
		pDoc->m_flkHeader.m_title=dlg.m_editTitle;
		pDoc->SetModifiedFlag();
	}
}
void CFlkEditView::OnEditCopy()
// Rs[
{
	CFlkEditDoc *pDoc=GetDocument();
	int iMark=pDoc->m_curBefore;
	int iEnd=pDoc->m_flkCode.GetCurAbs(NULL);

	if(iEnd<iMark)
	{
		int iBuf=iEnd;
		iEnd=iMark;
		iMark=iBuf;
	}

	CopyCode(iMark,iEnd);

	pDoc->UpdateAllViews(NULL);
	pDoc->SetModifiedFlag();
}

void CFlkEditView::OnUpdateEditCopy(CCmdUI *pCmdUI)
// Rs[R}h̏ԂXV
{
	CFlkEditDoc *pDoc=GetDocument();

	if(pDoc->m_curBefore==pDoc->m_flkCode.GetCurAbs(NULL))
		pCmdUI->Enable(FALSE);
}

void CFlkEditView::OnEditCut()
// ؂
{
	CFlkEditDoc *pDoc=GetDocument();
	int iMark=pDoc->m_curBefore;
	int iEnd=pDoc->m_flkCode.GetCurAbs(NULL);

	if(iEnd<iMark)
	{
		int iBuf=iEnd;
		iEnd=iMark;
		iMark=iBuf;
		pDoc->m_flkCode.SetCur(NULL,iMark);
	}
	CopyCode(iMark,iEnd);
	pDoc->m_flkCode.RemoveMarkedArea(iMark,iEnd);
	pDoc->m_flkCode.UpdateCode(pDoc->m_flkCode.m_cursor.m_track);
	pDoc->m_curBefore=pDoc->m_flkCode.GetCurAbs(NULL);

	pDoc->UpdateAllViews(NULL);
	pDoc->SetModifiedFlag();
}


void CFlkEditView::OnUpdateEditCut(CCmdUI *pCmdUI)
// ؂R}h̏ԂXV
{
	CFlkEditDoc *pDoc=GetDocument();

	if(pDoc->m_curBefore==pDoc->m_flkCode.GetCurAbs(NULL))
		pCmdUI->Enable(FALSE);
}

void CFlkEditView::OnEditPaste()
// \t
{
	COleDataObject* pClipData=new COleDataObject;

	if(!pClipData->AttachClipboard())
		return;

	HGLOBAL hMem=pClipData->GetGlobalData(CF_UNICODETEXT);
	LPCTSTR lpMem=(LPCTSTR)GlobalLock(hMem);
	CString strData(lpMem);
	GlobalUnlock(hMem);
	pClipData->Release();
	

	CFlkEditDoc* pDoc=GetDocument();

	pDoc->m_flkCode.PasteCode(strData);
	pDoc->m_flkCode.UpdateCode(pDoc->m_flkCode.m_cursor.m_track);
	pDoc->UpdateAllViews(NULL);
	pDoc->SetModifiedFlag();

	delete pClipData;
}

void CFlkEditView::OnUpdateEditPaste(CCmdUI *pCmdUI)
// \tR}h̏ԂXV
{
	// Ȃ
}

void CFlkEditView::CopyCode(int iMark,int iEnd)
// I͈͂Nbv{[hɃRs[
{
	CFlkEditDoc *pDoc=GetDocument();
	CString strClip(_T(""));
	CFlkObj *pObj;
	CCursor cur;
	int i;

	cur.m_track=pDoc->m_flkCode.m_cursor.m_track;
	pDoc->m_flkCode.GetHeadCur(cur);
	i=0;
	while(cur.m_position)
	{
		pObj=pDoc->m_flkCode.GetAt(&cur);
		i+=(pObj->m_type==Note ? 1 : pDoc->m_flkCode.m_eventLength);
		if(i>iMark)
			strClip+=pObj->GetObj();

		pDoc->m_flkCode.NextCur(&cur);

		if(i>=iEnd)
			break;
	}
	StrToClipboard(strClip);
	pDoc->m_curBefore=pDoc->m_flkCode.GetCurAbs(NULL);
}

bool CFlkEditView::StrToClipboard(LPCTSTR strData)
// Nbv{[hɑ
{
	COleDataSource* pData = new COleDataSource;
	HGLOBAL hMem = GlobalAlloc(GHND,(lstrlen(strData)+1)*sizeof(_TCHAR));

	if(!hMem)
		return false;

	LPTSTR lpMem=(LPTSTR)GlobalLock(hMem);
	lstrcpy(lpMem,strData);
	GlobalUnlock(hMem);

	pData->CacheGlobalData(CF_UNICODETEXT,hMem);
	pData->SetClipboard();

	return true;
}

void CFlkEditView::OnInsertEvent()
// Cxg}
{
	CFlkEditDoc* pDoc=GetDocument();
	CEventSettingDlg dlg;
	dlg.m_comboType=Null;
	if(dlg.DoModal()==IDOK)
	{
		CFlkObj* pObj=new CFlkObj;
		pObj->SetEvent((TYPE)dlg.m_comboType,dlg.m_index,dlg.m_value);
		pDoc->m_flkCode.InsertObj(NULL,pObj);

		pDoc->m_flkCode.UpdateCode(pDoc->m_flkCode.m_cursor.m_track);
		pDoc->UpdateAllViews(NULL);
		pDoc->SetModifiedFlag();
	}
}

void CFlkEditView::OnLeftEdge()
// 擪ֈړ
{
	CFlkEditDoc *pDoc=GetDocument();
	SCROLLINFO sInfo;
	GetScrollInfo(SB_HORZ,&sInfo,SIF_ALL);

	sInfo.nPos=sInfo.nMin;
	m_BasePoint.x=sInfo.nPos;
	SetScrollInfo(SB_HORZ,&sInfo,TRUE);
	pDoc->m_flkCode.GetHeadCur(pDoc->m_flkCode.m_cursor);
	pDoc->m_curBefore=pDoc->m_flkCode.GetCurAbs(NULL);

	InvalidateRect(NULL,TRUE);
}

void CFlkEditView::OnRightEdge()
// I[ֈړ
{
	CFlkEditDoc *pDoc=GetDocument();
	SCROLLINFO sInfo;
	GetScrollInfo(SB_HORZ,&sInfo,SIF_ALL);

	sInfo.nPos=sInfo.nMax;
	m_BasePoint.x=sInfo.nPos;
	SetScrollInfo(SB_HORZ,&sInfo,TRUE);
	pDoc->m_flkCode.m_cursor.m_position=NULL;
	pDoc->m_curBefore=pDoc->m_flkCode.GetCurAbs(NULL);

	InvalidateRect(NULL,TRUE);
}

void CFlkEditView::OnPageLeft()
// 1y[Wֈړ
{
	CFlkEditDoc *pDoc=GetDocument();
	SCROLLINFO sInfo;
	GetScrollInfo(SB_HORZ,&sInfo,SIF_ALL);
	int curAbs;

	if(sInfo.nPos>sInfo.nMin)
		sInfo.nPos=max(sInfo.nMin,sInfo.nPos-(int)sInfo.nPage);
	m_BasePoint.x=sInfo.nPos;
	SetScrollInfo(SB_HORZ,&sInfo,TRUE);

	curAbs=pDoc->m_flkCode.GetCurAbs(NULL);
	pDoc->m_flkCode.SetCur(NULL,curAbs-(int)sInfo.nPage);
	pDoc->m_curBefore=pDoc->m_flkCode.GetCurAbs(NULL);

	InvalidateRect(NULL,TRUE);
}

void CFlkEditView::OnPageRight()
// 1y[WEֈړ
{
	CFlkEditDoc *pDoc=GetDocument();
	SCROLLINFO sInfo;
	GetScrollInfo(SB_HORZ,&sInfo,SIF_ALL);
	int curAbs;

	if(sInfo.nPos<sInfo.nMax)
		sInfo.nPos=min(sInfo.nMax,sInfo.nPos+(int)sInfo.nPage);
	m_BasePoint.x=sInfo.nPos;
	SetScrollInfo(SB_HORZ,&sInfo,TRUE);

	curAbs=pDoc->m_flkCode.GetCurAbs(NULL);
	pDoc->m_flkCode.SetCur(NULL,curAbs+(int)sInfo.nPage);
	pDoc->m_curBefore=pDoc->m_flkCode.GetCurAbs(NULL);

	InvalidateRect(NULL,TRUE);
}
void CFlkEditView::OnPageSet()
// y[WI
{
	CFlkEditDoc* pDoc=GetDocument();

	pDoc->m_curBefore=pDoc->m_flkCode.PageMark();
	pDoc->UpdateAllViews(NULL);
}

void CFlkEditView::OnEditSelectAll()
// ׂđI
{
	CFlkEditDoc* pDoc=GetDocument();

	pDoc->m_curBefore=0;
	pDoc->m_flkCode.m_cursor.m_position=NULL;
	pDoc->UpdateAllViews(NULL);
}