// FlkHeader.cpp : t@C
//

#include "stdafx.h"
#include "FlkEdit.h"
#include "FlkHeader.h"


// CFlkHeader

CFlkHeader::CFlkHeader()
: m_builder(_T(""))
, m_title(_T(""))
, m_comment(_T(""))
, m_device(_T(""))
, m_timebase(480)
, m_st_track(0)
, m_st_octave(3)
, m_st_rhythm(false)
, m_st_program(0)
{
}

CFlkHeader::~CFlkHeader()
{
}


// CFlkHeader o֐

// dataheadAfootŋ܂ꂽresultɕԂiheadAfoot͊܂܂Ȃj

void CFlkHeader::Extract(CString& data, CString& result, CString head, CString foot)
{
	int mark;
	int end;
	mark=data.Find(head)+head.GetLength();
	end=data.Find(foot,mark);

	result=data.Mid(mark,end-mark);
}

void CFlkHeader::ReadHeader(CString& strHeader)
{
	CString strTemp;

	// [FileData]̓ǂݍ
	Extract(strHeader,m_builder,_T("Builder="),_T("\r\n"));
	Extract(strHeader,m_title,_T("Title="),_T("\r\n"));
	Extract(strHeader,m_comment,_T("Comment="),_T("\r\n"));
	m_comment.Replace(_T("\\r\\n"),_T("\r\n"));
	Extract(strHeader,m_device,_T("Device="),_T("\r\n"));
	Extract(strHeader,strTemp,_T("TimeBase="),_T("\r\n"));
	m_timebase=_wtoi(strTemp);

	// [SoundTest]̓ǂݍ
	Extract(strHeader,strTemp,_T("Track="),_T("\r\n"));
	m_st_track=_wtoi(strTemp);
	Extract(strHeader,strTemp,_T("Octave="),_T("\r\n"));
	m_st_octave=_wtoi(strTemp);
	Extract(strHeader,strTemp,_T("Rhythm="),_T("\r\n"));
	m_st_rhythm=(strTemp==_T("1") ? true : false);
	Extract(strHeader,strTemp,_T("Program="),_T("\r\n"));
	m_st_program=_wtoi(strTemp);
}

void CFlkHeader::StoreHeader(CArchive& ar)
{
	CStringA strBuff;
	CString ver,com;

	strBuff=_T("MFLK;\r\n\r\n");
	ar.Write(strBuff,strBuff.GetLength());
		
	ver.LoadStringW(IDS_VERSION);
	strBuff.Format(IDS_PROGRAM,(CStringA)ver);
	ar.Write(strBuff,strBuff.GetLength());

	com=m_comment;
	com.Replace(_T("\r\n"),_T("\\r\\n"));
	strBuff.Format(IDS_FILEDATA,(CStringA)m_builder,(CStringA)m_title,
		(CStringA)com,(CStringA)m_device,m_timebase);
	ar.Write(strBuff,strBuff.GetLength());
		
	strBuff.Format(IDS_SOUNDTEST,m_st_track,m_st_octave,
		(m_st_rhythm ? 1 : 0),m_st_program);
	ar.Write(strBuff,strBuff.GetLength());
}
