// FlkObj.cpp : t@C
//

#include "stdafx.h"
#include "FlkEdit.h"
#include "FlkObj.h"


// CFlkObj

CFlkObj::CFlkObj()
: m_type(Null)
, m_index(0)
, m_value(_T(""))
{
}

CFlkObj::~CFlkObj()
{
}


// CFlkObj o֐

void CFlkObj::SetNote(CString note)
{
	m_type=Note;
	m_value=note;
}

void CFlkObj::SetEvent(CString ev)
{
	switch((UINT)ev[1])
	{
	case '%':
		m_type=Kernel;
		break;
	case '$':
		m_type=Control;
		break;
	case '#':
		m_type=System;
		break;
	default:
		m_type=Null;
		return;
	}

	m_index=_wtoi(ev.Mid(2));
	int colon=ev.Find(_T(":"));
	if(colon==-1)
		return;
	m_value=ev.Mid(colon+1,ev.GetLength()-colon-2);
}

void CFlkObj::SetObj(CString data)
{
	if(data[0]=='[')
		SetEvent(data);
	else
		SetNote(data);
}

CString CFlkObj::GetObj(void)
{
	CString result;

	switch(m_type)
	{
	case Null:
		result=_T("[]");
		break;
	case Kernel:
		if(m_value==_T(""))
			result.Format(_T("[%%%d]"),m_index);
		else
			result.Format(_T("[%%%d:%s]"),m_index,m_value);
		break;
	case Control:
		if(m_value==_T(""))
			result.Format(_T("[$%d]"),m_index);
		else
			result.Format(_T("[$%d:%s]"),m_index,m_value);
		break;
	case System:
		if(m_value==_T(""))
			result.Format(_T("[#%d]"),m_index);
		else
			result.Format(_T("[#%d:%s]"),m_index,m_value);
		break;
	case Note:
		result=m_value;
		break;
	}
	return result;
}

void CFlkObj::SetEvent(TYPE type, int index, CString value)
{
	m_type=type;
	m_index=index;
	m_value=value;
}
