// KeyWnd.cpp : t@C
//

#include "stdafx.h"
#include "flkkey.h"
#include "flkkeyDlg.h"
#include "KeyWnd.h"

LPCTSTR CKeyWnd::m_lpszClassName=NULL;

// CKeyWnd

IMPLEMENT_DYNAMIC(CKeyWnd, CWnd)

CKeyWnd::CKeyWnd()
: m_pInterface(NULL)
, m_pBuffer(NULL)
, m_pPort(NULL)
, m_outportIndex(0)
, m_pPerformance(NULL)
, m_bNoteOn(FALSE)
, m_track(0)
, m_progIndex(0)
, m_keyIndex(0)
, m_pSound(NULL)
, m_octaveSet(3)
, m_panpot(64)
, m_moduration(0)
, m_hold(0)
{
	for(int i=0;i<MAX_PORT;i++)
	{
		ZeroMemory(&m_portCaps[i],sizeof(DMUS_PORTCAPS));
		m_portCaps[i].dwSize=sizeof(DMUS_PORTCAPS);
	}
	m_BankSelect[0]=0;
	m_BankSelect[1]=0;
}

CKeyWnd::~CKeyWnd()
{
}


BEGIN_MESSAGE_MAP(CKeyWnd, CWnd)
	ON_WM_CREATE()
	ON_WM_PAINT()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_MOUSEMOVE()
	ON_WM_DESTROY()
END_MESSAGE_MAP()



// CKeyWnd bZ[W nh



int CKeyWnd::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

	// TODO:  ɓȍ쐬R[hǉĂB
	CoInitialize(NULL);

	CoCreateInstance(CLSID_DirectMusic,NULL,CLSCTX_INPROC,
		IID_IDirectMusic8,(void**)&m_pInterface);

	CoCreateInstance(CLSID_DirectMusicPerformance, NULL,CLSCTX_INPROC,
		IID_IDirectMusicPerformance8,(void**)&m_pPerformance );
	
	CoCreateInstance(CLSID_DirectSound8, NULL,CLSCTX_INPROC,
		IID_IDirectSound8,(void**)&m_pSound );
	
	//DirectSound̐ݒ
	m_pInterface->SetDirectSound(m_pSound,m_hWnd);

	//|[gLpVeB̎擾
	for(int i=0;i<MAX_PORT;i++)
	{
		if(m_pInterface->EnumPort(i,&m_portCaps[i])==S_FALSE)
			break;
	}

	ChangePort(0,FALSE);
	
	return 0;
}

BOOL CKeyWnd::Create(DWORD dwExStyle, DWORD dwStyle, const CRect& rrect, CWnd* pwndParent, UINT uiID)
{
	if(m_lpszClassName==NULL)
	{
		m_lpszClassName=AfxRegisterWndClass(CS_VREDRAW|CS_HREDRAW|CS_SAVEBITS|CS_DBLCLKS);
	}

	return CreateEx(dwExStyle,m_lpszClassName,_T("Keyboard"),dwStyle,rrect,pwndParent,uiID,NULL);
}

void CKeyWnd::OnPaint()
{
	CPaintDC dc(this); // device context for painting
	// TODO: ɃbZ[W nh R[hǉ܂B
	// `惁bZ[W CWnd::OnPaint() ĂяoȂłB
	CBitmap bmp;
	CDC memDC;

	bmp.LoadBitmapW(IDB_BITMAP_KEYBOARD);
	memDC.CreateCompatibleDC(&dc);
	
	memDC.SelectObject(&bmp);

	dc.BitBlt(0,0,560,70,&memDC,0,0,SRCCOPY);

	memDC.DeleteDC();
}

void CKeyWnd::OnLButtonDown(UINT nFlags, CPoint point)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B
	CflkkeyDlg* pParent=(CflkkeyDlg*)GetParent();
	int oc;
	int note;

	//_CAOf[^擾AXV
	UpdateData();

	//Ղ̂ǂ𔻕
	m_bNoteOn=KeyCheck(point,oc,note);

	if(m_bNoteOn)
	{	
		m_keyIndex=note+12*(m_octaveSet+oc);

		//vO`FW
		if(m_track!=9)//YgbN͏
		{
			BYTE bank[3]={0xB0+m_track,0x00,m_BankSelect[0]};
			SendToBuffer(3,bank);

			bank[1]=0x20;
			bank[2]=m_BankSelect[1];
			SendToBuffer(3,bank);

			BYTE pc[2]={0xC0+m_track,m_progIndex};
			SendToBuffer(2,pc);
		}
		//Rg[`FW
		BYTE ctrl[3]={0xB0+m_track,0x01,m_moduration};
		SendToBuffer(3,ctrl);

		ctrl[1]=0x0A;
		ctrl[2]=m_panpot;
		SendToBuffer(3,ctrl);

		ctrl[1]=0x40;
		ctrl[2]=m_hold;
		SendToBuffer(3,ctrl);

		//m[gI
		BYTE msg[3]={0x90+m_track,m_keyIndex,0x7F};
		SendToBuffer(3,msg);
	}

	SetCapture();

	CWnd::OnLButtonDown(nFlags, point);
}

void CKeyWnd::OnLButtonUp(UINT nFlags, CPoint point)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B
	CflkkeyDlg* pParent=(CflkkeyDlg*)GetParent();

	//z[hIt
	BYTE hoff[3]={0xB0+m_track,0x40,0x00};
	SendToBuffer(3,hoff);
	//m[gIt
	BYTE msg[3]={0x80+m_track,m_keyIndex,0x40};
	SendToBuffer(3,msg);
	m_bNoteOn=FALSE;

	ReleaseCapture();

	CWnd::OnLButtonUp(nFlags, point);
}

void CKeyWnd::OnMouseMove(UINT nFlags, CPoint point)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B
	CflkkeyDlg* pParent=(CflkkeyDlg*)GetParent();

	if(m_bNoteOn)
	{
		int oc;
		int note;

		m_bNoteOn=KeyCheck(point,oc,note);
		if(m_bNoteOn)
		{
			if(m_keyIndex!=note+12*(m_octaveSet+oc))
			{
				//m[gIt
				BYTE off[3]={0x80+m_track,m_keyIndex,0x40};
				SendToBuffer(3,off);

				m_keyIndex=note+12*(m_octaveSet+oc);

				//m[gI
				BYTE on[3]={0x90+m_track,m_keyIndex,0x7F};
				SendToBuffer(3,on);
			}
		}
		else
		{
			//m[gIt
			BYTE off[3]={0x80+m_track,m_keyIndex,0x40};
			SendToBuffer(3,off);
		}
	}

	CWnd::OnMouseMove(nFlags, point);
}

BOOL CKeyWnd::KeyCheck(CPoint point,int& octave, int& note)
{
	int key;
	CRect rect(0,0,560,70);

	if(rect.PtInRect(point)==FALSE)
		return FALSE;

	octave=(point.x-(point.x%140))/140;//o-z:0 a-l:1 A-L:2 M-X:3
	key=((point.x%140)-(point.x%10))/10;

	if(point.y<=35)
	{
		switch(key)
		{
		case 0:
			note=0;//h
			break;
		case 1:
		case 2:
			note=1;//h#
			break;
		case 3:
		case 4:
			note=3;//#
			break;
		case 5:
			note=4;//~
			break;
		case 6:
			note=5;//t@
			break;
		case 7:
		case 8:
			note=6;//t@#
			break;
		case 9:
		case 10:
			note=8;//\#
			break;
		case 11:
		case 12:
			note=10;//#
			break;
		case 13:
			note=11;//V
			break;
		}
		return TRUE;
	}
	else
	{
		switch(key)
		{
		case 0:
		case 1:
			note=0;//h
			break;
		case 2:
		case 3:
			note=2;//
			break;
		case 4:
		case 5:
			note=4;//~
			break;
		case 6:
		case 7:
			note=5;//t@
			break;
		case 8:
		case 9:
			note=7;//\
			break;
		case 10:
		case 11:
			note=9;//
			break;
		case 12:
		case 13:
			note=11;//V
			break;
		}
		return TRUE;
	}

	return FALSE;
}

// midibZ[Wobt@֑
HRESULT CKeyWnd::SendToBuffer(DWORD len, LPBYTE msg)
{
	REFERENCE_TIME rt;
	HRESULT hresult;
	
	m_pPerformance->GetLatencyTime(&rt);

	hresult=m_pBuffer->PackUnstructured(rt,0,len,msg);

	m_pPort->PlayBuffer(m_pBuffer);
	m_pBuffer->Flush();

	return hresult;
}

void CKeyWnd::OnDestroy()
{
	CWnd::OnDestroy();

	// TODO: ɃbZ[W nh R[hǉ܂B

	//DirectMusicC^[tF[X̉
	m_pPerformance->RemovePort(m_pPort);
	m_pPort->Release();
	m_pPerformance->CloseDown();
	m_pPerformance->Release();
	m_pBuffer->Release();
	m_pSound->Release();
 
	CoUninitialize();

}

// f[^̍XV
void CKeyWnd::UpdateData(void)
{
	CflkkeyDlg* pParent=(CflkkeyDlg*)GetParent();

	pParent->UpdateData(TRUE);

	m_octaveSet=pParent->m_comboOctaveSet.GetCurSel();
	m_progIndex=pParent->m_comboProgram.GetCurSel();
	m_BankSelect[0]=pParent->m_iBankMSB;
	m_BankSelect[1]=pParent->m_iBankLSB;
	m_panpot=pParent->m_iPanpot;
	m_moduration=pParent->m_iModuration;
	m_hold=(pParent->m_bHold ? 127 : 0 );
	m_track=pParent->m_comboTrack.GetCurSel();
}

// o̓|[gύXibRelease=TRUÊƂ͊̃|[gj
void CKeyWnd::ChangePort(int iPortIndex,BOOL bReleace)
{
	CflkkeyDlg* pParent=(CflkkeyDlg*)GetParent();
	HRESULT hresult;//`FbNp

	m_outportIndex=iPortIndex;

	if(bReleace)
	{
		//|[g̉
		hresult=m_pPerformance->RemovePort(m_pPort);
		m_pPort->Release();
	}
	else
	{
		//ptH[}X̏
		m_pPerformance->Init((IDirectMusic**)(&m_pInterface),m_pSound,m_hWnd);

		//obt@̍쐬
		DMUS_BUFFERDESC bufDesc;
		ZeroMemory(&bufDesc,sizeof(DMUS_BUFFERDESC));
		bufDesc.dwSize=sizeof(DMUS_BUFFERDESC);
		bufDesc.guidBufferFormat=GUID_NULL;
		bufDesc.cbBuffer=128;
		hresult=m_pInterface->CreateMusicBuffer(&bufDesc,&m_pBuffer,NULL);
	}

	//|[g̍쐬
	DMUS_PORTPARAMS8 portParams;
	ZeroMemory(&portParams,sizeof(DMUS_PORTPARAMS8));
	portParams.dwSize=sizeof(DMUS_PORTPARAMS8);
	hresult=m_pInterface->CreatePort(m_portCaps[m_outportIndex].guidPort,&portParams,&m_pPort,NULL);

	//|[g̏
	hresult=m_pPort->Activate(TRUE);
	hresult=m_pPerformance->AddPort(m_pPort);
	hresult=m_pPerformance->AssignPChannelBlock(0,m_pPort,1);

	//̏
	BYTE gm_on[6]={0xF0,0x7E,0x7F,0x09,0x01,0xF7};
	SendToBuffer(6,gm_on);
	Sleep(100);
	BYTE gs_reset[11]={0xF0,0x41,0x10,0x42,0x12,0x40,0x00,0x7F,0x00,0x41,0xF7};
	SendToBuffer(11,gs_reset);
	Sleep(100);
	BYTE xg_reset[9]={0xF0,0x43,0x10,0x4C,0x00,0x00,0x7E,0x00,0xF7};
	SendToBuffer(9,xg_reset);
	BYTE vol[3];
	for(int tr=0;tr<16;tr++)
	{
		vol[0]=0xB0+tr;
		vol[1]=0x07;
		vol[2]=0x7F;
		SendToBuffer(3,vol);
	}
}

