// FlkPlayDlg.cpp : t@C
//

#include "stdafx.h"
#include "FlkPlay.h"
#include "FlkPlayDlg.h"
#include "PortSetDlg.h"

#define MFLK_MAX_TRACK 19
#define TRtoCH(t) ((t)<10?(t)-1:((t)<16?(t):9))

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// AvP[Ṽo[WɎg CAboutDlg _CAO

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// _CAO f[^
	enum { IDD = IDD_ABOUTBOX };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV T|[g

// 
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
END_MESSAGE_MAP()


// CFlkPlayDlg _CAO




CFlkPlayDlg::CFlkPlayDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CFlkPlayDlg::IDD, pParent)
	, m_midi(1,480)
	, m_filePath(_T("flkp.tmp"))
	, m_portNumber(0)
	, g_pInterface(NULL)
	, g_pMusicPort(NULL)
	, g_pLoader(NULL)
	, g_pPerformance(NULL)
	, g_pSegment(NULL)
	, m_editCopyRight(_T(""))
	, m_editTitle(_T(""))
	, m_editComment(_T(""))
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

	for(int i=0;i<10;i++)
	{
		ZeroMemory(&m_portCaps[i],sizeof(DMUS_PORTCAPS));
		m_portCaps[i].dwSize=sizeof(DMUS_PORTCAPS);
	}
}

void CFlkPlayDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Text(pDX, IDC_EDIT_COPY_RIGHT, m_editCopyRight);
	DDX_Text(pDX, IDC_EDIT_TITLE, m_editTitle);
	DDX_Text(pDX, IDC_EDIT_COMMENT, m_editComment);
}

BEGIN_MESSAGE_MAP(CFlkPlayDlg, CDialog)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_COMMAND(IDM_ABOUT, &CFlkPlayDlg::OnAbout)
	ON_COMMAND(IDM_EXIT, &CFlkPlayDlg::OnExit)
	ON_COMMAND(IDM_FILE_OPEN, &CFlkPlayDlg::OnFileOpen)
	ON_COMMAND(IDM_SAVE_AS_MIDI, &CFlkPlayDlg::OnSaveAsMidi)
//	ON_UPDATE_COMMAND_UI(IDM_SAVE_AS_MIDI, &CFlkPlayDlg::OnUpdateSaveAsMidi)
ON_COMMAND(IDM_PLAY, &CFlkPlayDlg::OnPlay)
ON_COMMAND(IDM_STOP, &CFlkPlayDlg::OnStop)
ON_WM_DESTROY()
ON_COMMAND(IDM_PORT_SET, &CFlkPlayDlg::OnPortSet)
END_MESSAGE_MAP()


// CFlkPlayDlg bZ[W nh

BOOL CFlkPlayDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// "o[W..." j[VXe j[ɒǉ܂B

	// IDM_ABOUTBOX ́AVXe R}h͈͓̔ɂȂ΂Ȃ܂B
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// ̃_CAÕACRݒ肵܂BAvP[ṼC EBhE_CAOłȂꍇA
	//  Framework ́A̐ݒIɍs܂B
	SetIcon(m_hIcon, TRUE);			// 傫ACR̐ݒ
	SetIcon(m_hIcon, FALSE);		// ACR̐ݒ

	// DirectMusic̏
	CoInitialize(NULL);

	CoCreateInstance(CLSID_DirectMusic,NULL,CLSCTX_INPROC,
		IID_IDirectMusic8,(void**)&g_pInterface);

	CoCreateInstance(CLSID_DirectMusicLoader,NULL,CLSCTX_INPROC,
		IID_IDirectMusicLoader8,(void**)&g_pLoader);

	CoCreateInstance(CLSID_DirectMusicPerformance, NULL,CLSCTX_INPROC,
		IID_IDirectMusicPerformance8,(void**)&g_pPerformance );


	//DirectSound̐ݒ
	g_pInterface->SetDirectSound(NULL,m_hWnd);
	
	//|[gLpVeB擾
	int count=0;
	while(g_pInterface->EnumPort(count,&m_portCaps[count])!=S_FALSE)
	{
		if((m_portCaps[count].wszDescription[0]=='M')
			&& (m_portCaps[count].wszDescription[10]=='M'))
		{
			//Microsoft MIDI}bp[ftHgɂ
			m_portNumber=count;
		}
		count++;
	}

	//|[g̍쐬
	DMUS_PORTPARAMS8 portParams;
	ZeroMemory(&portParams,sizeof(DMUS_PORTPARAMS8));
	portParams.dwSize=sizeof(DMUS_PORTPARAMS8);
	g_pInterface->CreatePort(m_portCaps[m_portNumber].guidPort,&portParams,&g_pMusicPort,NULL);

	//|[g̏
	g_pPerformance->Init((IDirectMusic**)(&g_pInterface),NULL,m_hWnd);
	if(g_pMusicPort->Activate(TRUE)!=S_OK)
	{
		AfxMessageBox(_T("̏Ɏs܂B\ñvOŎgpĂȂmFĂB"),MB_OK|MB_ICONEXCLAMATION);
	}
	g_pPerformance->AddPort(g_pMusicPort);
	g_pPerformance->AssignPChannelBlock(0,g_pMusicPort,1);

	return TRUE;  // tH[JXRg[ɐݒ肵ꍇATRUE Ԃ܂B
}

void CFlkPlayDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// _CAOɍŏ{^ǉꍇAACR`悷邽߂
//  ̃R[hKvłBhLg/r[ fg MFC AvP[V̏ꍇA
//  ́AFramework ɂĎIɐݒ肳܂B

void CFlkPlayDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // `̃foCX ReLXg

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// NCAg̎lp`̈̒
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// ACR̕`
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// [U[ŏEBhEhbOĂƂɕ\J[\擾邽߂ɁA
//  VXe̊֐Ăяo܂B
HCURSOR CFlkPlayDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}


void CFlkPlayDlg::OnAbout()
{
	// o[W_CAO\
	CAboutDlg dlgAbout;
	dlgAbout.DoModal();
}

void CFlkPlayDlg::OnExit()
{
	// _CAO{bNX
	
	//Đ~
	OnStop();

	CDialog::OnOK();
}

void CFlkPlayDlg::OnFileOpen()
{
	// t@CJ

	OnStop();

	CFileDialog fdlg(TRUE,NULL,NULL,4|2,_T("MIDIFlick Data Files (*.flk)|*.flk|Standard MIDI Files (*.mid)|*.mid|All Files (*.*)|*.*||"),this);
	if(fdlg.DoModal()==IDOK)
	{
		CString fileName=fdlg.GetPathName();
		int dot=0;
		m_filePath=fileName.Tokenize(_T("."),dot);
		m_filePath+=_T("_flkplay.tmp");
		CFile f;
		if(!f.Open(fileName,CFile::modeRead|CFile::shareExclusive))
		{
			AfxMessageBox(_T("t@C̃I[vɎs܂B"),MB_OK|MB_ICONEXCLAMATION);
			return;
		}

		char buff[5];
		f.Read(buff,5);
		buff[4]='\0';
		f.SeekToBegin();
		if(strcmp(buff,"MThd")==0)
		{
			CArchive ar(&f,CArchive::load);
			m_midi.Serialize(ar);
			ar.Close();

			char title[256];
			char copyRight[256];
			m_midi.GetTitle(title);
			m_midi.GetCopyRight(copyRight);

			m_editTitle=title;
			if(m_editTitle.IsEmpty())
				m_editTitle=fdlg.GetFileName();
			m_editCopyRight=copyRight;
		}
		else if(strcmp(buff,"MFLK")==0)
		{
			UINT buffSize=(UINT)(f.GetLength());
			char *buff=new char[buffSize+1];
			UINT eof=f.Read(buff,buffSize+1);
			buff[eof]='\0';

			CString data(buff);

			m_editTitle=Extract(data,_T("Title="),_T("\r\n"));
			if(m_editTitle.IsEmpty())
				m_editTitle=fdlg.GetFileName();
			m_editCopyRight=Extract(data,_T("Builder="),_T("\r\n"));
			m_editComment=Extract(data,_T("Comment="),_T("\r\n"));
			m_editComment.Replace(_T("\\r\\n"),_T("\r\n"));

			Convert(&m_midi,data);

			delete[] buff;
		}
		f.Close();

		UpdateData(FALSE);
	}
}

void CFlkPlayDlg::OnSaveAsMidi()
{
	// Standard MIDI FileƂĕۑ
	
	// Đ~
	OnStop();

	CFileDialog fdlg(FALSE,_T("mid"),_T("NoTitle"),4|2,_T("Standard MIDI Files (*.mid)|*.mid|All Files (*.*)|*.*||"),this);
	if(fdlg.DoModal()==IDOK)
	{
		CString fileName=fdlg.GetPathName();
		CFile f;
		if(!f.Open(fileName,CFile::modeCreate|CFile::modeWrite|CFile::shareExclusive))
		{
			AfxMessageBox(_T("t@C̃I[vɎs܂B"),MB_OK|MB_ICONEXCLAMATION);
			return;
		}
		CArchive ar(&f,CArchive::store);
		m_midi.Serialize(ar);

		ar.Close();
		f.Close();
	}
}

void CFlkPlayDlg::OnPlay()
{
	OnStop();

	//ꎞt@C̕ۑ
	
	CFile f;
	if(!f.Open(m_filePath,CFile::modeCreate|CFile::modeWrite|CFile::shareExclusive))
	{
		AfxMessageBox(_T("ꎞt@C̍쐬Ɏs܂B"),MB_OK|MB_ICONEXCLAMATION);
		return;
	}
	CArchive ar(&f,CArchive::store);
	m_midi.Serialize(ar);

	ar.Close();
	f.Close();

	//ꎞt@C̃[h
	if (FAILED(g_pLoader->LoadObjectFromFile(CLSID_DirectMusicSegment,
		IID_IDirectMusicSegment8,(wchar_t*)((LPCTSTR)m_filePath),(LPVOID*)&g_pSegment)))
	{
		AfxMessageBox(_T("ꎞt@C̃[hɎs܂B"),MB_OK|MB_ICONEXCLAMATION);
		return;
	}
	g_pSegment->Download(g_pPerformance);

	//ĐJn
	g_pPerformance->PlaySegmentEx(g_pSegment,NULL,NULL,0,
		0,NULL,NULL,NULL);

}

void CFlkPlayDlg::OnStop()
{
	// ĐȂ~
	if(g_pPerformance->IsPlaying(g_pSegment,NULL)==S_OK)
	{
		g_pPerformance->Stop(g_pSegment,NULL,0,0);
		g_pSegment->Unload(g_pPerformance);
		g_pSegment->Release();
		g_pSegment=NULL;
	}

	// ꎞt@C폜
	CFileStatus st;
	if(CFile::GetStatus(m_filePath,st)==TRUE)
		CFile::Remove(m_filePath);
}

void CFlkPlayDlg::OnDestroy()
{
	CDialog::OnDestroy();

	// TODO: ɃbZ[W nh R[hǉ܂B
	
	// ꎞt@C폜
	CFileStatus st;
	if(CFile::GetStatus(m_filePath,st)==TRUE)
		CFile::Remove(m_filePath);

	// DirectMusic̉
	g_pPerformance->RemovePort(g_pMusicPort);
	g_pMusicPort->Release();
	g_pPerformance->CloseDown();
	g_pLoader->Release(); 
	g_pPerformance->Release();
	if(g_pSegment!=NULL)
		g_pSegment->Release();
 
	CoUninitialize();
}

void CFlkPlayDlg::OnPortSet()
{
	// ̐ݒ

	// Đ~
	OnStop();

	CPortSetDlg sdlg;
	
	sdlg.m_number=m_portNumber;
	sdlg.m_count=0;
	while(m_portCaps[sdlg.m_count].wszDescription[0]!='\0')
	{
		sdlg.m_portName[sdlg.m_count]=m_portCaps[sdlg.m_count].wszDescription;
		sdlg.m_count++;
	}
	if(sdlg.DoModal()==IDOK)
	{
		if(m_portNumber!=sdlg.m_number)
		{
			m_portNumber=sdlg.m_number;
				
			//|[g̍폜
			g_pPerformance->RemovePort(g_pMusicPort);
			g_pMusicPort->Release();

			//|[g̍쐬
			DMUS_PORTPARAMS8 portParams;
			ZeroMemory(&portParams,sizeof(DMUS_PORTPARAMS8));
			portParams.dwSize=sizeof(DMUS_PORTPARAMS8);
			g_pInterface->CreatePort(m_portCaps[m_portNumber].guidPort,&portParams,&g_pMusicPort,NULL);

			//|[g̏
			if(g_pMusicPort->Activate(TRUE)!=S_OK)
			{
				AfxMessageBox(_T("̏Ɏs܂B\ñvOŎgpĂȂmFĂB"),MB_OK|MB_ICONEXCLAMATION);
			}
			g_pPerformance->AddPort(g_pMusicPort);
			g_pPerformance->AssignPChannelBlock(0,g_pMusicPort,1);
		}
	}
}

CString CFlkPlayDlg::Extract(CString& src, CString mark, CString end, int start)
{
	// srcstartȍ~ŁAmarkendɈ͂܂ꂽԂ
	CString result(_T(""));
	int m=src.Find(mark,start);
	int e=src.Find(end,m);

	if((m!=-1) && (e!=-1))
		result=src.Mid(m+mark.GetLength(),e-m-mark.GetLength());

	return result;
}

void CFlkPlayDlg::Convert(CMidi* midi, CString& flk)
{	
	// MIDIFlickMIDIւ̕ϊ

	CString trackData[MFLK_MAX_TRACK];// egbÑf[^
	CString head;// egbN̐擪
	CStringA title,copyRight;
	int baseTime;// 
	int tr,curSys,curTrack;
	UINT time,dt;
	BYTE bufMsg[128];

	//gbN̍쐬
	baseTime=_wtoi(Extract(flk,_T("TimeBase="),_T("\r\n")));
	if(midi->m_midiTrack!=NULL)
	{
		midi->DeleteTrack();
		midi->CreateTrack(1,(WORD)baseTime);
	}

	// ^Cg
	title=(CStringA)Extract(flk,_T("Title="),_T("\r\n"));
	bufMsg[0]=0xff;
	bufMsg[1]=0x03;
	bufMsg[2]=title.GetLength();
	memcpy_s(bufMsg+3,125,title,bufMsg[2]);
	midi->AddMsgTail(0,0,bufMsg,bufMsg[2]+3);

	// 쌠
	copyRight=(CStringA)Extract(flk,_T("Builder="),_T("\r\n"));
	bufMsg[0]=0xff;
	bufMsg[1]=0x02;
	bufMsg[2]=copyRight.GetLength();
	memcpy_s(bufMsg+3,125,copyRight,bufMsg[2]);
	midi->AddMsgTail(0,0,bufMsg,bufMsg[2]+3);

	for(tr=0;tr<MFLK_MAX_TRACK;tr++)
	{
		// f[^egbNɕ
		head.Format(_T("%d="),tr);
		trackData[tr]=Extract(flk,head,_T("\r\n"));
	}

	// SysgbN
	curSys=0;
	time=0;
	dt=120;
	while(curSys<trackData[0].GetLength())
	{
		switch(trackData[0].GetAt(curSys))
		{
		case '[':
			switch(trackData[0].GetAt(curSys+1))
			{
			case ']'://Null()
				break;
			case '%'://Kernel
				switch(_wtoi(trackData[0].Mid(curSys+2,3)))
				{
				case 2://Define(}[J[ƂĖߍ)
					{
						CStringA marker=(CStringA)Extract(trackData[0],_T(":"),_T("]"),curSys);
						bufMsg[0]=0xff;
						bufMsg[1]=0x06;
						bufMsg[2]=marker.GetLength();
						memcpy_s(bufMsg+3,125,marker,bufMsg[2]);
						midi->InsertMsg(time,0,bufMsg,bufMsg[2]+3);
					}
					break;
				case 7://Comment(eLXgƂĖߍ)
					{
						CStringA text=(CStringA)Extract(trackData[0],_T(":"),_T("]"),curSys);
						bufMsg[0]=0xff;
						bufMsg[1]=0x01;
						bufMsg[2]=text.GetLength();
						memcpy_s(bufMsg+3,125,text,bufMsg[2]);
						midi->InsertMsg(time,0,bufMsg,bufMsg[2]+3);
					}
					break;
				case 18://DeltaTime
					dt=_wtoi(trackData[0].Mid(curSys+5,3));
					break;
				}
				break;
			case '$'://Control()
				break;
			case '#'://System
				switch(_wtoi(trackData[0].Mid(curSys+2,3)))
				{
				case 0://GM System ON
					bufMsg[0]=0xf0;
					bufMsg[1]=0x05;
					bufMsg[2]=0x7e;
					bufMsg[3]=0x7f;
					bufMsg[4]=0x09;
					bufMsg[5]=0x01;
					bufMsg[6]=0xf7;
					midi->InsertMsg(time,0,bufMsg,7);
					break;
				case 1://XG System ON
					bufMsg[0]=0xf0;
					bufMsg[1]=0x08;
					bufMsg[2]=0x43;
					bufMsg[3]=0x10;
					bufMsg[4]=0x4c;
					bufMsg[5]=0x00;
					bufMsg[6]=0x00;
					bufMsg[7]=0x7e;
					bufMsg[8]=0x00;
					bufMsg[9]=0xf7;
					midi->InsertMsg(time,0,bufMsg,10);
					break;
				case 2://GS Reset
					bufMsg[0]=0xf0;
					bufMsg[1]=0x0a;
					bufMsg[2]=0x41;
					bufMsg[3]=0x10;
					bufMsg[4]=0x42;
					bufMsg[5]=0x12;
					bufMsg[6]=0x40;
					bufMsg[7]=0x00;
					bufMsg[8]=0x7f;
					bufMsg[9]=0x00;
					bufMsg[10]=0x41;
					bufMsg[11]=0xf7;
					midi->InsertMsg(time,0,bufMsg,12);
					break;
				case 30://Tempo
					{
						DWORD tempo=_wtoi(trackData[0].Mid(curSys+5,4));
						tempo=(DWORD)(60000000/(double)(tempo));
						bufMsg[0]=0xff;
						bufMsg[1]=0x51;
						bufMsg[2]=0x03;
						bufMsg[3]=BYTE_EXT(tempo,2);
						bufMsg[4]=BYTE_EXT(tempo,1);
						bufMsg[5]=BYTE_EXT(tempo,0);
						midi->InsertMsg(time,0,bufMsg,6);
					}
					break;
				}
				break;
			}
			curSys=trackData[0].Find(_T("]"),curSys)+1;
			break;
		case '-':
		case '/':
			curSys++;
			time+=dt;
			break;
		}
	}

	//̃gbN
	int oc,vel;
	int har[8];//har[0]͓WJꂽa̐Ahar[1`7]͘ȃΈʒu
	bool play;
	BYTE noteStack[8];//noteStack[0]͖{̉AnoteStack[1`7]͓WJꂽa
	CString noteElements[4]={
		_T("opqrstuvwxyz"),
		_T("abcdefghijkl"),
		_T("ABCDEFGHIJKL"),
		_T("MNOPQRSTUVWX")
	};

	for(tr=1;tr<MFLK_MAX_TRACK;tr++)
	{
		curSys=0;
		curTrack=0;
		time=0;
		dt=120;
		oc=3;
		har[0]=0;
		vel=127;
		play=false;
		while(curTrack<trackData[tr].GetLength())
		{
			//f^^C̊Ď
			if(curSys<trackData[0].GetLength())
			{
				if(trackData[0].GetAt(curSys)=='[')
				{
					if(trackData[0].Mid(curSys+1,3)==_T("%18"))
						dt=_wtoi(trackData[0].Mid(curSys+5,3));

					curSys=trackData[0].Find(_T("]"),curSys)+1;
				}
				else
				{
					curSys++;
				}
			}

			switch(trackData[tr].GetAt(curTrack))
			{
			case '[':
				switch(trackData[tr].GetAt(curTrack+1))
				{
				case ']'://Null()
					break;
				case '%'://Kernel
					switch(_wtoi(trackData[tr].Mid(curTrack+2,3)))
					{
					case 3://ProgramChange
						bufMsg[0]=0xc0+TRtoCH(tr);
						bufMsg[1]=(BYTE)(_wtoi(trackData[tr].Mid(curTrack+4,3)));
						midi->InsertMsg(time,0,bufMsg,2);
						break;
					case 4://Octave
						oc=_wtoi(trackData[tr].Mid(curTrack+4,1));
						break;
					case 5://Velocity
						vel=_wtoi(trackData[tr].Mid(curTrack+4,3));
						break;
					case 7://Comment(eLXgƂĖߍ)
						{
							CStringA text=(CStringA)Extract(trackData[tr],_T(":"),_T("]"),curTrack);
							bufMsg[0]=0xff;
							bufMsg[1]=0x01;
							bufMsg[2]=text.GetLength();
							memcpy_s(bufMsg+3,125,text,bufMsg[2]);
							midi->InsertMsg(time,0,bufMsg,bufMsg[2]+3);
						}
						break;
					case 10://Harmony
						{
							int cnt;
							int cur=0;
							CString h=Extract(trackData[tr],_T("[%10:"),_T("]"),curTrack);

							// łɃn[j[tȂn[j[~߂
							if(play)
							{
								for(cnt=1;cnt<=har[0];cnt++)
								{
									bufMsg[0]=0x80+TRtoCH(tr);
									bufMsg[1]=noteStack[cnt];
									bufMsg[2]=0x40;
									midi->InsertMsg(time,0,bufMsg,3);
								}
							}

							// har[]Vn[j[ōXV
							har[0]=0;
							CString token;
							while(cur!=-1)
							{
								token=h.Tokenize(_T(", "),cur);
								if(token!=_T(""))
								{
									har[0]++;
									har[har[0]]=_wtoi(token);
								}
							}
							
							// n[j[t
							if(play)
							{
								for(cnt=1;cnt<=har[0];cnt++)
								{
									noteStack[cnt]=noteStack[0]+har[cnt];
									bufMsg[0]=0x90+TRtoCH(tr);
									bufMsg[1]=noteStack[cnt];
									bufMsg[2]=(BYTE)vel;
									midi->InsertMsg(time,0,bufMsg,3);
								}
							}
						}
						break;
					case 11://HarmonyEnd
						{
							// łɃn[j[tȂn[j[~߂
							if(play)
							{
								for(int cnt=1;cnt<=har[0];cnt++)
								{
									bufMsg[0]=0x80+TRtoCH(tr);
									bufMsg[1]=noteStack[cnt];
									bufMsg[2]=0x40;
									midi->InsertMsg(time,0,bufMsg,3);
								}
							}
							// n[j[Ȃɐݒ
							har[0]=0;
						}
						break;
					}
					break;
				case '$'://Control
					{
						// ΉRg[ɕϊ
						int colon=trackData[tr].Find(_T(":"),curTrack);
						bufMsg[0]=0xb0+TRtoCH(tr);
						bufMsg[1]=(BYTE)(_wtoi(trackData[tr].Mid(curTrack+2,3)));
						bufMsg[2]=(BYTE)(_wtoi(trackData[tr].Mid(colon+1,3)));
						midi->InsertMsg(time,0,bufMsg,3);
					}
					break;
				case '#'://System
					switch(_wtoi(trackData[tr].Mid(curTrack+2,3)))
					{
					case 31://PichBend
						{
							UINT pich=(UINT)(_wtoi(trackData[tr].Mid(curTrack+5,5)));
							bufMsg[0]=0xe0+TRtoCH(tr);
							bufMsg[1]=DT_EXT(pich,0);
							bufMsg[2]=DT_EXT(pich,1);
							midi->InsertMsg(time,0,bufMsg,3);
						}
						break;
					}
					break;
				}
				curTrack=trackData[tr].Find(_T("]"),curTrack)+1;
				break;
			case '-':
				curTrack++;
				time+=dt;
				break;
			case '/'://NoteOFF
				if(play)
				{
					// ׂẲ~߂
					for(int cnt=0;cnt<=har[0];cnt++)
					{
						bufMsg[0]=0x80+TRtoCH(tr);
						bufMsg[1]=noteStack[cnt];
						bufMsg[2]=0x40;
						midi->InsertMsg(time,0,bufMsg,3);
					}
					play=false;
				}
				curTrack++;
				time+=dt;
				break;
			default://NoteON
				{
					int cnt,index;

					// łɉtȂAׂẲ~߂
					if(play)
					{
						for(cnt=0;cnt<=har[0];cnt++)
						{
							bufMsg[0]=0x80+TRtoCH(tr);
							bufMsg[1]=noteStack[cnt];
							bufMsg[2]=0x40;
							midi->InsertMsg(time,0,bufMsg,3);
						}
						play=false;
					}

					for(int i=0;i<4;i++)
					{
						index=noteElements[i].Find(trackData[tr].GetAt(curTrack),0);
						if(index!=-1)
						{
							for(cnt=0;cnt<=har[0];cnt++)
							{
								noteStack[cnt]=index+12*(oc+i)+(cnt==0 ? 0 : har[cnt]);
								bufMsg[0]=0x90+TRtoCH(tr);
								bufMsg[1]=noteStack[cnt];
								bufMsg[2]=(BYTE)vel;
								midi->InsertMsg(time,0,bufMsg,3);
							}

							play=true;
							break;
						}
					}
					curTrack++;
					time+=dt;
				}
				break;
			}
		}
		// gbN̍Ō͉~߂
		if(play)
		{
			for(int cnt=0;cnt<=har[0];cnt++)
			{
				bufMsg[0]=0x80+TRtoCH(tr);
				bufMsg[1]=noteStack[cnt];
				bufMsg[2]=0x40;
				midi->InsertMsg(time,0,bufMsg,3);
			}
		}
	}

	// GhIugbN
	bufMsg[0]=0xff;
	bufMsg[1]=0x2f;
	bufMsg[2]=0x00;
	midi->AddMsgTail(0,0,bufMsg,3);

}
