// Midi.cpp : t@C
//
#include "stdafx.h"
#include "Midi.h"


/////////////////////////////////////////////////////////////////
// CMidiHeaderNX
/////////////////////////////////////////////////////////////////

CMidiHeader::CMidiHeader()
{
	m_identifier[0]='M';
	m_identifier[1]='T';
	m_identifier[2]='h';
	m_identifier[3]='d';

	m_len=6;
	m_format=0;
	m_track=0;
	m_time=480;
}

CMidiHeader::~CMidiHeader()
{
}

void CMidiHeader::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{	// f[^ۑ
		ar.Write(m_identifier,4);

		ar<<BYTE_EXT(m_len,3);
		ar<<BYTE_EXT(m_len,2);
		ar<<BYTE_EXT(m_len,1);
		ar<<BYTE_EXT(m_len,0);
		
		ar<<BYTE_EXT(m_format,1);
		ar<<BYTE_EXT(m_format,0);
		
		ar<<BYTE_EXT(m_track,1);
		ar<<BYTE_EXT(m_track,0);
		
		ar<<BYTE_EXT(m_time,1);
		ar<<BYTE_EXT(m_time,0);
	}
	else
	{	// f[^ǂݍ
		BYTE buff[14];

		ar.Read(buff,14);

		if(memcmp(m_identifier,buff,4)!=0)
		{
			AfxMessageBox(_T("wb_`NG["),MB_OK|MB_ICONEXCLAMATION);
			return;
		}

		m_len=BYTE_SHIFT(buff[4],3)+BYTE_SHIFT(buff[5],2)+BYTE_SHIFT(buff[6],1)+buff[7];
		m_format=BYTE_SHIFT(buff[8],1)+buff[9];
		m_track=BYTE_SHIFT(buff[10],1)+buff[11];
		m_time=BYTE_SHIFT(buff[12],1)+buff[13];
	}
}


/////////////////////////////////////////////////////////////////
// CMidiObjNX
/////////////////////////////////////////////////////////////////

CMidiObj::CMidiObj()
{
	m_dt=0;
	m_len=0;
	m_msg=NULL;
}

CMidiObj::~CMidiObj()
{
	if(m_msg!=NULL)
		delete[] m_msg;
}

void CMidiObj::GetDeltaTime(UINT& len, LPBYTE dt)
{
	BYTE temp[4]={0x00,0x80,0x80,0x80};
	int i;

	len=1;
	for(i=0;i<4;i++)
	{
		if(DT_EXT(m_dt,i)!=0)
		{
			temp[i]+=DT_EXT(m_dt,i);
			len=i+1;
		}
	}
	for(i=0;i<(int)(len);i++)
	{
		dt[i]=temp[len-i-1];
	}
}

void CMidiObj::SetDeltaTime(LPBYTE dt)
{
	m_dt=0;

	for(int i=0;i<4;i++)
	{
		m_dt=m_dt<<7;
		m_dt+=dt[i]&0x7f;

		if((dt[i]&0x80)==0)
			break;
	}
}

UINT CMidiObj::GetSize(void)
{
	UINT len;
	BYTE dt[4];

	GetDeltaTime(len,dt);
	return (len+m_len);
}


void CMidiObj::Serialize(CArchive& ar)
{
	BYTE buff[4];
	UINT len;

	if (ar.IsStoring())
	{	// f[^ۑ
		GetDeltaTime(len,buff);
		ar.Write(buff,len);

		ar.Write(m_msg,m_len);
	}
	else
	{	// f[^ǂݍ
		if(m_msg!=NULL)
			delete m_msg;

		for(int i=0;i<4;i++)
		{
			ar.Read(&buff[i],1);
			if((buff[i]&0x80)==0)
				break;
		}
		SetDeltaTime(buff);

		BYTE msg[128];
		ar.Read(msg,1);
		switch((msg[0]&0xf0)>>4)
		{
		case 0xc://vO`FW
		case 0xd://`lvbV[
			m_len=2;
			ar.Read(msg+1,1);
			break;
		case 0x8://m[gIt
		case 0x9://m[gI
		case 0xa://|tHjbNL[vbV[
		case 0xb://Rg[`FWE[hbZ[W
		case 0xe://sb`xh`FW
			m_len=3;
			ar.Read(msg+1,2);
			break;
		case 0xf:
			switch(msg[0]&0x0f)
			{
			case 0x0://VXeGNXN[VubZ[W
			case 0x7:
				ar.Read(msg+1,1);
				if(msg[1]!=0)
					ar.Read(msg+2,(UINT)(msg[1]));
				m_len=msg[1]+2;
				break;
			case 0xf://^Cxg
				ar.Read(msg+1,2);
				if(msg[2]!=0)
					ar.Read(msg+3,(UINT)(msg[2]));
				m_len=msg[2]+3;
				break;
			default:
				ASSERT(FALSE);
			}
			break;
		default:
			ASSERT(FALSE);
		}
		m_msg=new BYTE[m_len];
		memcpy_s(m_msg,m_len,msg,m_len);
	}
}


/////////////////////////////////////////////////////////////////
// CMidiTrackNX
/////////////////////////////////////////////////////////////////

CMidiTrack::CMidiTrack()
{
	m_identifier[0]='M';
	m_identifier[1]='T';
	m_identifier[2]='r';
	m_identifier[3]='k';
}

CMidiTrack::~CMidiTrack()
{
	POSITION pos=m_list.GetHeadPosition();
	while(pos)
		delete (CMidiObj*)m_list.GetNext(pos);
	m_list.RemoveAll();
}

void CMidiTrack::Serialize(CArchive& ar)
{
	POSITION pos;
	CMidiObj *pObj;
	UINT dataSize=0;

	if (ar.IsStoring())
	{	// f[^ۑ
		ar.Write(m_identifier,4);
		if(m_list.IsEmpty())
		{
			BYTE voidTrack[8]={0x00,0x00,0x00,0x04,0x00,0xff,0x2f,0x00};
			ar.Write(voidTrack,8);
		}
		else
		{
			pos=m_list.GetHeadPosition();
			while(pos)
			{
				pObj=(CMidiObj*)m_list.GetNext(pos);
				dataSize+=pObj->GetSize();
			}
			ar<<BYTE_EXT(dataSize,3);
			ar<<BYTE_EXT(dataSize,2);
			ar<<BYTE_EXT(dataSize,1);
			ar<<BYTE_EXT(dataSize,0);

			pos=m_list.GetHeadPosition();
			while(pos)
			{
				pObj=(CMidiObj*)m_list.GetNext(pos);
				pObj->Serialize(ar);
			}
		}
	}
	else
	{	// f[^ǂݍ
		BYTE buff[8];
		ar.Read(buff,8);

		if(memcmp(m_identifier,buff,4)!=0)
		{
			AfxMessageBox(_T("gbN`NG["),MB_OK|MB_ICONEXCLAMATION);
			return;
		}

		if(!m_list.IsEmpty())
		{
			POSITION pos=m_list.GetHeadPosition();
			while(pos)
				delete (CMidiObj*)m_list.GetNext(pos);
			m_list.RemoveAll();
		}

		while(TRUE)
		{
			pObj=new CMidiObj;
			pObj->Serialize(ar);
			m_list.AddTail((CMidiObj*)pObj);

			if((pObj->m_msg[0]==0xff) && (pObj->m_msg[1]==0x2f))
				break;

			if(pObj->m_len==0)
			{
				AfxMessageBox(_T("t@C̓ǂݍ݂Ɏs܂B"),MB_OK|MB_ICONEXCLAMATION);
				return;
			}
		}
		//f[^`FbN
		UINT trackSize=BYTE_SHIFT((UINT)buff[4],3)+BYTE_SHIFT((UINT)buff[5],2)
			+BYTE_SHIFT((UINT)buff[6],1)+(UINT)buff[7];

		pos=m_list.GetHeadPosition();
		while(pos)
		{
			pObj=(CMidiObj*)m_list.GetNext(pos);
			dataSize+=pObj->GetSize();
		}
		if(dataSize!=trackSize)
		{
			AfxMessageBox(_T("f[^`FbNG["),MB_OK|MB_ICONEXCLAMATION);
			return;
		}
	}
}


/////////////////////////////////////////////////////////////////
// CMidiNX
/////////////////////////////////////////////////////////////////

CMidi::CMidi()
{
	CreateTrack(1,480);
}

CMidi::CMidi(WORD track,WORD time)
{
	CreateTrack(track,time);
}
CMidi::~CMidi()
{
	DeleteTrack();
}

void CMidi::DeleteTrack(void)
{
	if(m_midiTrack!=NULL)
		delete[] m_midiTrack;

	m_midiTrack=NULL;
}

void CMidi::CreateTrack(WORD track, WORD time)
{
	m_midiHeader.m_format=(track==1 ? 0 : 1);
	m_midiHeader.m_track=track;
	m_midiTrack=new CMidiTrack[track];

	m_midiHeader.m_time=time;
}

void CMidi::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{	// f[^ۑ
		m_midiHeader.Serialize(ar);

		for(int tr=0;tr<m_midiHeader.m_track;tr++)
			m_midiTrack[tr].Serialize(ar);
	}
	else
	{	// f[^ǂݍ
		if(m_midiTrack!=NULL)
			delete[] m_midiTrack;

		m_midiHeader.Serialize(ar);
		m_midiTrack=new CMidiTrack[m_midiHeader.m_track];

		for(int tr=0;tr<m_midiHeader.m_track;tr++)
			m_midiTrack[tr].Serialize(ar);
	}
}

void CMidi::InsertMsg(UINT time, int track, LPBYTE msg, UINT len)
{
	// bZ[W̑}
	if(track>=m_midiHeader.m_track)
		return;

	CMidiObj *pNewObj=new CMidiObj;

	pNewObj->m_len=len;
	pNewObj->m_msg=new BYTE[len];
	memcpy_s(pNewObj->m_msg,len,msg,len);

	CMidiObj *pMidiObj;
	POSITION pos;
	UINT t=0;
	pos=m_midiTrack[track].m_list.GetHeadPosition();
	if(!pos)
	{
		pNewObj->m_dt=time;
		m_midiTrack[track].m_list.AddHead((CObject*)pNewObj);
		return;
	}
	while(pos)
	{
		pMidiObj=(CMidiObj*)m_midiTrack[track].m_list.GetAt(pos);

		if(t+pMidiObj->m_dt>time)
		{
			pNewObj->m_dt=time-t;
			m_midiTrack[track].m_list.InsertBefore(pos,(CObject*)pNewObj);
			pMidiObj->m_dt-=time-t;
			return;
		}
		t+=pMidiObj->m_dt;
		m_midiTrack[track].m_list.GetNext(pos);
	}
	pNewObj->m_dt=time-t;
	m_midiTrack[track].m_list.AddTail((CObject*)pNewObj);
}

void CMidi::AddMsgTail(UINT dt, int track, LPBYTE msg, UINT len)
{
	// ŌɃbZ[Wǉ
	if(track>=m_midiHeader.m_track)
		return;

	CMidiObj *pNewObj=new CMidiObj;

	pNewObj->m_dt=dt;
	pNewObj->m_len=len;
	pNewObj->m_msg=new BYTE[len];
	memcpy_s(pNewObj->m_msg,len,msg,len);

	m_midiTrack[track].m_list.AddTail((CObject*)pNewObj);
}

// copyRight[]256oCgȏ
BYTE CMidi::GetTitle(char *title)
{
	BYTE len=0;
	title[len]='\0';

	if(m_midiTrack==NULL)
		return len;

	CMidiObj *pObj;
	POSITION pos;

	pos=m_midiTrack[0].m_list.GetHeadPosition();
	while(pos)
	{
		pObj=(CMidiObj*)(m_midiTrack[0].m_list.GetNext(pos));
		if((pObj->m_msg[0]==0xff) && (pObj->m_msg[1]==0x03))
		{
			len=pObj->m_msg[2];
			memcpy_s(title,256,pObj->m_msg+3,len);
			title[len]='\0';
			break;
		}
	}
	return len;
}

// copyRight[]256oCgȏ
BYTE CMidi::GetCopyRight(char *copyRight)
{
	BYTE len=0;
	copyRight[len]='\0';

	if(m_midiTrack==NULL)
		return len;

	CMidiObj *pObj;
	POSITION pos;

	pos=m_midiTrack[0].m_list.GetHeadPosition();
	while(pos)
	{
		pObj=(CMidiObj*)(m_midiTrack[0].m_list.GetNext(pos));
		if((pObj->m_msg[0]==0xff) && (pObj->m_msg[1]==0x02))
		{
			len=pObj->m_msg[2];
			memcpy_s(copyRight,256,pObj->m_msg+3,len);
			copyRight[len]='\0';
			break;
		}
	}
	return len;
}