#pragma once

// }N

#define BYTE_EXT(x,d) (BYTE)(((x)&(0xff<<(d*8)))>>(d*8))
#define BYTE_SHIFT(x,d) ((x)<<(d*8))
#define DT_EXT(x,d) (BYTE)(((x)&(0x7f<<(d*7)))>>(d*7))

// CMidiHeaderNX

class CMidiHeader : public CObject
{
public:
	__declspec(dllexport) CMidiHeader();
	virtual __declspec(dllexport) ~CMidiHeader();
public:
	char m_identifier[4];
	DWORD m_len;
	WORD m_format;
	WORD m_track;
	WORD m_time;
	virtual void Serialize(CArchive& ar);
};


// CMidiObjNX

class CMidiObj : public CObject
{
public:
	__declspec(dllexport) CMidiObj();
	virtual __declspec(dllexport) ~CMidiObj();
public:
	UINT m_len;
	UINT m_dt;
	LPBYTE m_msg;
	void GetDeltaTime(UINT& len, LPBYTE dt);
	void SetDeltaTime(LPBYTE dt);
	virtual void Serialize(CArchive& ar);
	UINT GetSize(void);
};


// CMidiTrackNX

class CMidiTrack : public CObject
{
public:
	__declspec(dllexport) CMidiTrack();
	virtual __declspec(dllexport) ~CMidiTrack();
public:
	char m_identifier[4];
	CObList m_list;
	virtual void Serialize(CArchive& ar);
};


// CMidiNX

class CMidi : public CObject
{
public:
	__declspec(dllexport) CMidi();
	__declspec(dllexport) CMidi(WORD track, WORD time);
	virtual __declspec(dllexport) ~CMidi();
public:
	virtual __declspec(dllexport) void Serialize(CArchive& ar);
	__declspec(dllexport) void CreateTrack(WORD track, WORD time);
	__declspec(dllexport) void DeleteTrack(void);
	__declspec(dllexport) void InsertMsg(UINT time, int track, LPBYTE msg, UINT len);
	__declspec(dllexport) void AddMsgTail(UINT dt, int track, LPBYTE msg, UINT len);
	__declspec(dllexport) BYTE GetTitle(char *title);
	__declspec(dllexport) BYTE GetCopyRight(char *copyRight);
	CMidiHeader m_midiHeader;
	CMidiTrack *m_midiTrack;
};


