// midioutDlg.cpp : t@C
//

#include "stdafx.h"
#include "midiout.h"
#include "midioutDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// AvP[Ṽo[WɎg CAboutDlg _CAO

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// _CAO f[^
	enum { IDD = IDD_ABOUTBOX };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV T|[g

// 
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
END_MESSAGE_MAP()


// CmidioutDlg _CAO




CmidioutDlg::CmidioutDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CmidioutDlg::IDD, pParent)
	, m_editFileName(_T(""))
	, m_bPlaying(FALSE)
	, m_portNumber(0)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

	for(int i=0;i<10;i++)
		m_portCaps[i].dwSize=sizeof(DMUS_PORTCAPS);
}

void CmidioutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Text(pDX, IDC_EDIT_FILE, m_editFileName);
	DDX_Control(pDX, IDC_COMBO_DEVICE, m_comboDevice);
}

BEGIN_MESSAGE_MAP(CmidioutDlg, CDialog)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_BUTTON_OPEN, &CmidioutDlg::OnBnClickedButtonOpen)
	ON_BN_CLICKED(IDC_BUTTON_PLAY, &CmidioutDlg::OnBnClickedButtonPlay)
	ON_BN_CLICKED(IDC_BUTTON_STOP, &CmidioutDlg::OnBnClickedButtonStop)
	ON_BN_CLICKED(IDOK, &CmidioutDlg::OnBnClickedOk)
	ON_BN_CLICKED(IDABORT, &CmidioutDlg::OnBnClickedAbort)
	ON_WM_DESTROY()
	ON_CBN_SELCHANGE(IDC_COMBO_DEVICE, &CmidioutDlg::OnCbnSelchangeComboDevice)
END_MESSAGE_MAP()


// CmidioutDlg bZ[W nh

BOOL CmidioutDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// "o[W..." j[VXe j[ɒǉ܂B

	// IDM_ABOUTBOX ́AVXe R}h͈͓̔ɂȂ΂Ȃ܂B
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// ̃_CAÕACRݒ肵܂BAvP[ṼC EBhE_CAOłȂꍇA
	//  Framework ́A̐ݒIɍs܂B
	SetIcon(m_hIcon, TRUE);			// 傫ACR̐ݒ
	SetIcon(m_hIcon, FALSE);		// ACR̐ݒ

	// TODO: ɒǉ܂B
	
	g_pInterface=NULL;
	g_pMusicPort=NULL;
	g_pLoader=NULL;
	g_pPerformance=NULL;
	g_pSegment=NULL;

	CoInitialize(NULL);

	CoCreateInstance(CLSID_DirectMusic,NULL,CLSCTX_INPROC,
		IID_IDirectMusic8,(void**)&g_pInterface);

	CoCreateInstance(CLSID_DirectMusicLoader,NULL,CLSCTX_INPROC,
		IID_IDirectMusicLoader8,(void**)&g_pLoader);

	CoCreateInstance(CLSID_DirectMusicPerformance, NULL,CLSCTX_INPROC,
		IID_IDirectMusicPerformance8,(void**)&g_pPerformance );


	//DirectSound̐ݒ
	g_pInterface->SetDirectSound(NULL,m_hWnd);
	
	//|[gLpVeB擾
	int count=0;
	while(g_pInterface->EnumPort(count,&m_portCaps[count])!=S_FALSE)
	{
		m_comboDevice.AddString(m_portCaps[count].wszDescription);
		count++;
	}
	m_comboDevice.SetCurSel(m_portNumber);

	//|[g̍쐬
	DMUS_PORTPARAMS8 portParams;
	ZeroMemory(&portParams,sizeof(DMUS_PORTPARAMS8));
	portParams.dwSize=sizeof(DMUS_PORTPARAMS8);
	g_pInterface->CreatePort(m_portCaps[m_portNumber].guidPort,&portParams,&g_pMusicPort,NULL);

	//|[g̏
	g_pPerformance->Init((IDirectMusic**)(&g_pInterface),NULL,m_hWnd);
	g_pMusicPort->Activate(TRUE);
	g_pPerformance->AddPort(g_pMusicPort);
	g_pPerformance->AssignPChannelBlock(0,g_pMusicPort,1);


	return TRUE;  // tH[JXRg[ɐݒ肵ꍇATRUE Ԃ܂B
}

void CmidioutDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// _CAOɍŏ{^ǉꍇAACR`悷邽߂
//  ̃R[hKvłBhLg/r[ fg MFC AvP[V̏ꍇA
//  ́AFramework ɂĎIɐݒ肳܂B

void CmidioutDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // `̃foCX ReLXg

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// NCAg̎lp`̈̒
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// ACR̕`
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// [U[ŏEBhEhbOĂƂɕ\J[\擾邽߂ɁA
//  VXe̊֐Ăяo܂B
HCURSOR CmidioutDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}


void CmidioutDlg::OnBnClickedButtonOpen()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B

	//ut@CJv_CAO{bNX\
	CString fileFilter=_T("Standard Midi File(*.mid)|*.mid|ׂẴt@C(*.*)|*.*|");

	CFileDialog fdlg(TRUE,NULL,NULL,OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,fileFilter);

	if(m_bPlaying==TRUE)
	{
		g_pPerformance->Stop(g_pSegment,NULL,0,0);
		m_bPlaying=FALSE;
	}
	
	if(fdlg.DoModal()==IDOK)
	{
		m_editFileName=fdlg.GetPathName();
	}
	UpdateData(FALSE);
}

void CmidioutDlg::OnBnClickedButtonPlay()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B

	if(FAILED(g_pLoader->LoadObjectFromFile(CLSID_DirectMusicSegment
		,IID_IDirectMusicSegment8,(wchar_t*)((LPCTSTR)m_editFileName),(LPVOID*) &g_pSegment)))
	{
		//[hs
		MessageBox(_T("t@CȂAĐłȂ`̃t@CłB")
			,_T("dmusic"), MB_OK|MB_ICONWARNING );
	}
	else
	{
		g_pSegment->Download( g_pPerformance );

		//ĐJn
		g_pPerformance->PlaySegmentEx(g_pSegment,NULL,NULL,0,
			0,NULL,NULL,NULL);
		m_bPlaying=TRUE;
	}
}

void CmidioutDlg::OnBnClickedButtonStop()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	g_pPerformance->Stop(g_pSegment,NULL,0,0);
	m_bPlaying=FALSE;
	Sleep(500);
}

void CmidioutDlg::OnBnClickedOk()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	if(m_bPlaying==TRUE)
	{
		//Đ~
		g_pPerformance->Stop(g_pSegment,NULL,0,0);
		m_bPlaying=FALSE;
	}
	OnOK();
}

void CmidioutDlg::OnBnClickedAbort()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	CAboutDlg dlg;
	dlg.DoModal();
}

void CmidioutDlg::OnDestroy()
{
	CDialog::OnDestroy();

	// TODO: ɃbZ[W nh R[hǉ܂B
	g_pPerformance->RemovePort(g_pMusicPort);
	g_pMusicPort->Release();
	g_pPerformance->CloseDown();
	g_pLoader->Release(); 
	g_pPerformance->Release();
	if(g_pSegment!=NULL)
		g_pSegment->Release();
 
	CoUninitialize();
}

void CmidioutDlg::OnCbnSelchangeComboDevice()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	UpdateData(TRUE);
	m_portNumber=m_comboDevice.GetCurSel();

	if(m_bPlaying==TRUE)
	{
		g_pPerformance->Stop(g_pSegment,NULL,0,0);
		m_bPlaying=FALSE;
	}
	Sleep(500);
	//|[g̍폜
	g_pPerformance->RemovePort(g_pMusicPort);
	g_pMusicPort->Release();

	//|[g̍쐬
	DMUS_PORTPARAMS8 portParams;
	ZeroMemory(&portParams,sizeof(DMUS_PORTPARAMS8));
	portParams.dwSize=sizeof(DMUS_PORTPARAMS8);
	g_pInterface->CreatePort(m_portCaps[m_portNumber].guidPort,&portParams,&g_pMusicPort,NULL);

	//|[g̏
	g_pMusicPort->Activate(TRUE);
	g_pPerformance->AddPort(g_pMusicPort);
	g_pPerformance->AssignPChannelBlock(0,g_pMusicPort,1);
}
