/***************************************************************************
    Copyright          : (C) 2002 by Neoworks Limited. All rights reserved
    URL                : http://www.neoworks.com
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

import java.util.ListResourceBundle;

/**
 * Resource bundle for localisation of the JukeX user interface
 *
 * @author Nigel Atkinson (<a href="mailto:nigel@neoworks.com">nigel@neoworks.com</a>)
 */
public class InterfaceResources extends ListResourceBundle
{
	static final Object [][] contents = {
		{"currentlyPlaying", "Currently Playing"},
		{"comingNext", "Coming Next"},
		{"personalPlaylist", "Personal Playlist"},
		{"search", "Search"},
		{"actions", "Actions"},
		{"play", "play"},
		{"pause", "pause"},
		{"skip", "skip"},
		{"noTracks", "No tracks"},
		{"go", "Go"},
		{"browse", "browse"},
		{"pipeline", "pipeline"},
		{"Pipeline", "Pipeline"},
		{"attributes", "attributes"},
		{"advancedSearch", "Advanced Search"},
		{"adminSearch", "Admin Search"},
		{"del", "del"},
		{"stopped", "stopped"},
		{"details", "details"},
		{"other", "Other"},
		{"configureColumns", "Configure Columns"},
		{"remove", "Remove"},
		{"configure", "Configure"},
		{"attribute", "Attribute"},
		{"type", "Type"},
		{"value", "Value"},
		{"update", "Update"},
		{"addAttribute", "Add Attribute"},
		{"removeAttribute", "Remove Attribute"},
		{"systemAttributes", "System Attributes"},
		{"newSearchTerm", "New Search Term"},
		{"currentSearchTerms", "Current Search Terms"},
		{"equals", "equals"},
		{"startsWith", "starts with"},
		{"contains", "contains"},
		{"matches", "matches"},
		{"isLessThan", "is less than"},
		{"isGreaterThan", "is greater than"},
		{"AND", "AND"},
		{"OR", "OR"},
		{"updateQuery", "Add Another Term"},
		{"clearQuery", "Clear Query"},
		{"runSearch", "Run Search"},
		{"defineSearch", "Define Search"},
		{"saveThisQuery", "Save This Query"},
		{"filterConfiguration", "Filter Configuration"},
		{"addANewFilter", "Add a New Filter"},
		{"addNewFilter", "Add New Filter"},
		{"existingFilters", "Existing Filters"},
		{"removeFilter", "Remove Filter"},
		{"trackAttributes", "Track Attributes"},
		{"editAttributes", "Edit Attributes"},
		{"editTrackAttributes", "Edit Track Attributes"},
		{"playTrack", "Play this track"},
		{"columnConfiguration", "Column Configuration"},
		{"chooseColumns", "Choose Columns"},
		{"column", "Column"},
		{"groupTracksByFirstColumn", "Group tracks by first column"},
		{"save", "Save"},
		{"enterDetails", "enter details"},
		{"searchGoogleTrack", "Search Google for this track"}
	};

	/**
	 * Get an array of mappings
	 *
	 * @return An array of String-&gt;Object mappings
	 */
	public Object[][] getContents()
	{
		return contents;
	}
}
