/***************************************************************************
    Copyright          : (C) 2002 by Neoworks Limited. All rights reserved
    URL                : http://www.neoworks.com
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

package com.neoworks.jukex;

import java.util.Locale;

/**
 * Attributes are classes of information associated with Tracks.
 * (E.g. the Attribute could be "Artist", and then all tracks could have
 * a value for this attribute.)
 *
 * @author Nick Vincent (<a href="mailto:nick@neoworks.com">nick@neoworks.com</a>)
 */
public interface Attribute
{ 
	/** String attribute type */
	public static final int TYPE_STRING = 1;
	/** int attribute type */
	public static final int TYPE_INT = 2;

	/**
	 * Get the name of this attribute
	 *
	 * @return The name of the attribute
	 */
	public String getName();

	/**
	 * Get a localised name for this attribute
	 *
	 * @param locale The required Locale for the name
	 * @return A localised name for the attribute
	 */
	public String getLocalisedName(Locale locale);
	
	/**
	 * Return the type of the attribute, which can be equal to Attribute.TYPE_STRING or
	 * Attribute.TYPE_INT
	 *
	 * @return The type of the Attribute
	 */
	public int getType();

	/**
	 * Get an AttributeValue object representing the String object that was 
	 * passed
	 *
	 * @param s The String to retrieve an AttributeValue object for
	 * @return An AttributeValue representing the passed String.
	 */
	public AttributeValue getAttributeValue( String s );
	
	/**
	 * Get an AttributeValue object representing the integer that was 
	 * passed
	 *
	 * @param val The integer to retrieve an AttributeValue object for
	 * @return An AttributeValue representing the passed integer.
	 */
	public AttributeValue getAttributeValue( int val );
}
