/***************************************************************************
    Copyright          : (C) 2002 by Neoworks Limited. All rights reserved
    URL                : http://www.neoworks.com
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

package com.neoworks.jukex;

/**
 * AttributeValue represents a possible value of an Attribute.
 *
 * @author Nick Vincent (<a href="mailto:nick@neoworks.com">nick@neoworks.com</a>)
 */
public interface AttributeValue
{
	/**
	 * Get the String value
	 *
	 * @return The value
	 */
	public String getString();

	/** 
	 * Get the int value
	 *
	 * @return The value
	 */
	public int getInt();

	/**
	 * Get the type of the attribute that this value corresponds to
	 *
	 * @return An int representing the attribute type (see Attribute)
	 */
	public int getType();	

	/**
	 * Set the String value
	 *
	 * @param newval The String to set as the new value
	 */
	public void setString( String newval );

	/**
	 * Get a String representation of this AttributeValue
	 *
	 * @return A String
	 */
	public String toString();
}
