/***************************************************************************
    Copyright          : (C) 2002 by Neoworks Limited. All rights reserved
    URL                : http://www.neoworks.com
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

package com.neoworks.jukex;

import com.neoworks.jukex.tracksource.TrackSource;

/**
 * Interface for classes controlling the playback of Tracks.
 *
 * @author Nigel Atkinson (<a href="mailto:nigel@neoworks.com">nigel@neoworks.com</a>)
 */
public interface ControlPlayback
{
	/**
	 * Get the currently playing Track
	 *
	 * @return The Track that is currently playing
	 */
	public Track getPlaying();
	
	/**
	 * Play the current/next available Track.
	 */
	public void play();

	/**
	 * Test whether the playback is paused
	 *
	 * @return boolean indicating whether playback is paused
	 */
	public boolean isPaused();

	/**
	 * Pause playback
	 */
	public void pause();
	
	/**
	 * Skip to the next available Track.
	 */
	public void skip();

	/**
	 * Stop playing. This has a silly name as many ControlPlayback implementations
	 * will probably extend Thread.
	 */
	public void cpStop();

	/**
	 * Get the remaining play time for the current Track
	 *
	 * @return The remaining play time in milliseconds
	 */
	public long getRemainingPlayingTime();

	/**
	 * Get the currently playing TrackSource.
	 *
	 * @return The TrackSource that is currently playing
	 */
	public TrackSource getTrackSource();

	/**
	 * Set the TrackSource to play from.
	 *
	 * @param ts The TrackSource for this onbject to play from
	 */
	public void setTrackSource(TrackSource ts);
}
