/***************************************************************************
    Copyright          : (C) 2002 by Neoworks Limited. All rights reserved
    URL                : http://www.neoworks.com
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

package com.neoworks.jukex;

import com.neoworks.jukex.tracksource.TrackSource;

import java.util.Map;
import java.util.HashMap;
import java.util.Set;

/**
 * ControlPlayback manager.
 *
 * @author Nigel Atkinson (<a href="mailto:nigel@neoworks.com">nigel@neoworks.com</a>)
 */
public class ControlPlaybackManager
{
	private static Map controlPlaybacks = new HashMap();

	/**
	 * Get a ControlPlayback object by name
	 *
	 * @param name The name of the ControlPlayback object
	 * @return The ControlPlayback or null
	 */
	public ControlPlayback getControlPlayback(String name)
	{
		return (ControlPlayback)controlPlaybacks.get(name);
	}
	
	/**
	 * Register a ControlPlayback
	 *
	 * @param name The name to register under
	 * @param cp The ControlPlayback object
	 */
	public void registerControlPlayback(String name, ControlPlayback cp)
	{
		controlPlaybacks.put(name, cp);
	}

	/**
	 * Unregister a ControlPlayback
	 *
	 * @param name The name of the ControlPlayback to unregister
	 */
	public void unregisterControlPlayback(String name)
	{
		controlPlaybacks.remove(name);
	}

	/**
	 * List all of the registered ControlPlaybacks
	 *
	 * @return A Set of the ControlPlayback names
	 */
	public Set listAllControlPlaybacks()
	{
		return controlPlaybacks.keySet();
	}
}
