/***************************************************************************
    Copyright          : (C) 2002 by Neoworks Limited. All rights reserved
    URL                : http://www.neoworks.com
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*
 * Playlist.java
 *
 * Created on 22 April 2002, 17:31
 */

package com.neoworks.jukex;

import java.util.List;
import com.neoworks.jukex.Track;
import com.neoworks.jukex.tracksource.TrackSourcePipelineElement;

/**
 * PlayList is a special case of List which is used for storing only Tracks.
 *
 * It comprises of a List interface representing the current queue of songs 
 * waiting to be played, and a single song which is being 'played'.  The Playlist
 * itself does not play any music, but can be controlled by a class which does.
 * 
 * Several new methods for find out which song is 
 * currently being 'played'.  The song being played is not part of the List.
 *
 * @author Nick Vincent <a href="mailto:nick@neoworks.com">nick@neoworks.com</a>
 */
public interface Playlist extends List, TrackSourcePipelineElement
{
	/**
	 * Get the next available Track
	 *
	 * @return The next available Track object
	 */
	public Track getNextTrack();
	
	/**
	 * Get the Track at the specified index
	 *
	 * @param index The index of the Track to get
	 * @return The Track at the specified index
	 */
	public Track getTrack( int index );
	
	/**
	 * Get the name of the Playlist
	 *
	 * @return The name of the playlist
	 */
	public String getName();
}
