/***************************************************************************
    Copyright          : (C) 2002 by Neoworks Limited. All rights reserved
    URL                : http://www.neoworks.com
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

package com.neoworks.jukex.client.html.standard;

import com.neoworks.jukex.Attribute;

/**
 * Class representing an Attribute based query
 *
 * @author Nigel Atkinson (<a href="mailto:nigel@neoworks.com">nigel@neoworks.com</a>)
 */
public class AttributeQuery
{
	private static String[][] comparatorLUT = {{"=","=","",""},{"<","<","",""},{">",">","",""},{"~=","REGEXP","",""},{"x%","=","","%"},{"%x%","=","%","%"}};
	private static int COMPARATORS = 6;
	private Attribute attribute;
	private String comparator;
	private String value;

	/**
	 * Public constructor
	 *
	 * @param a The Attribute to query on
	 * @param c The comparator token
	 * @param v The value to query for
	 */
	public AttributeQuery(Attribute a, String c, String v)
	{
		attribute = a;
		comparator = c;
		value = v;
	}

	/**
	 * Get the Attribute
	 *
	 * @return The Attribute to be queried on
	 */
	public Attribute getAttribute()
	{
		return attribute;
	}

	/**
	 * Get the comparator token
	 *
	 * @return the String comparator token
	 */
	public String getComparator()
	{
		return comparator;
	}

	/**
	 * Get the value String
	 *
	 * @return the value
	 */
	public String getValue()
	{
		return value;
	}

	/**
	 * Get a String representation of this query
	 */
	public String toString()
	{
		String[] tokens = getComparatorTokens();
		if (attribute.getType() == Attribute.TYPE_INT)
		{
			return attribute.getName() + " " + tokens[1] + " " + value;
		} else {
			return attribute.getName() + " " + tokens[1] + " \"" + tokens[2] + value + tokens[3] + "\"";
		}
	}

	/**
	 * Get an array of tokens representing [lookup string][prefix][comparator][postfix] for the current comparator
	 *
	 * @return An array of comparator tokens
	 */
	private String [] getComparatorTokens()
	{
		for (int i = 0; i < COMPARATORS; i++)
		{
			if (comparator.equals(comparatorLUT[i][0]))
			{
				return comparatorLUT[i];
			}
		}
		return new String[4];
	}
}
