/***************************************************************************
    Copyright          : (C) 2002 by Neoworks Limited. All rights reserved
    URL                : http://www.neoworks.com
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

package com.neoworks.jukex.client.html.standard;

import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpServletRequest;
import com.neoworks.jukex.TrackStore;
import com.neoworks.jukex.TrackStoreFactory;
import com.neoworks.jukex.query.AttributeValueResultSet;
import com.neoworks.jukex.query.JukeXParser;
import com.neoworks.jukex.query.Query;
import com.neoworks.rdc.ParserException;
import com.neoworks.util.Escaper;
import java.util.List;
import java.util.ArrayList;

import org.apache.log4j.Category;

/**
 * Administration servlet interface for JukeX.
 *
 * @author Nigel Atkinson (<a href="mailto:nigel@neoworks.com">nigel@neoworks.com</a>)
 */
public class SearchHelper
{
	private static final Category log = Category.getInstance(SearchHelper.class.getName());
	private static final boolean logDebugEnabled = log.isDebugEnabled();
	private static final boolean logInfoEnabled = log.isInfoEnabled();

	public static HttpSession prepareSearchSession(HttpServletRequest req)
	{
		TrackStore ts = TrackStoreFactory.getTrackStore();

		// Get parameters from the user's session. These are set if they do not exist.
		HttpSession session = req.getSession();

		// Ascending or descending sort order
		if (session.getAttribute("browseSortOrder") == null)
		{
			session.setAttribute("browseSortOrder", "ASC");
		}

		// Attribute columns to display
		if (session.getAttribute("browseColumnAttributes") == null)
		{
			List attributes = new ArrayList();
			attributes.add(ts.getAttribute("Artist"));
			attributes.add(ts.getAttribute("Title"));
			session.setAttribute("browseColumnAttributes",attributes);
		}

		List columnAttributes = (List)session.getAttribute("browseColumnAttributes");

		// Use grouping in the display
		if (session.getAttribute("browseUseGrouping") == null)
		{
			session.setAttribute("browseUseGrouping", new Boolean(false));
		}

		// Attribute to sort browse results on
		if (session.getAttribute("browseSortAttribute") == null || ((Boolean)session.getAttribute("browseUseGrouping")).booleanValue() || !columnAttributes.contains(session.getAttribute("browseSortAttribute")))
		{
			session.setAttribute("browseSortAttribute",columnAttributes.get(0));
		}
		return session;
	}

	public static AttributeValueResultSet performSearch(String queryString) throws ParserException
	{
		if (logInfoEnabled) log.info( "Searching with JukeXQL "+queryString );
		AttributeValueResultSet retVal = null;
		try {
			Query q = ((JukeXParser)JukeXParser.createParser( Escaper.SQLEscape(queryString) )).parse();
			retVal = q.getAttributeValues();
		} catch (ParserException pe) {
			throw pe;
		} catch (Exception e) {
			log.warn("Exception encountered while performing search", e);
		}
		return retVal;
	}
}
