/***************************************************************************
    Copyright          : (C) 2002 by Neoworks Limited. All rights reserved
    URL                : http://www.neoworks.com
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*
 * Expression.java
 *
 * Created on 17 April 2002, 14:45
 */

package com.neoworks.jukex.query;

import java.util.Set;
import java.util.Map;
import java.io.Serializable;

/**
 * Interface for JukeXQL expressions.
 *
 * @author Nick Vincent (<a href="mailto:nick@neoworks.com">nick@neoworks.com</a>)
 */
public interface Expression extends Serializable
{
	/**
	 * Get the generated SQL for this expression.
	 *
	 * @param buffer StringBuffer to populate with the SQL expression.
	 */
	public void getSQL( StringBuffer buffer );
}
