/***************************************************************************
    Copyright          : (C) 2002 by Neoworks Limited. All rights reserved
    URL                : http://www.neoworks.com
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*
 * QueryType.java
 *
 * Created on 24 April 2002, 17:17
 */

package com.neoworks.jukex.query;

import java.util.List;
import java.io.Serializable;

/**
 * Abstract class to represent a Query type
 *
 * @author Nick Vincent (<a href="mailto:nick@neoworks.com">nick@neoworks.com</a>)
 */
public abstract class QueryType implements Serializable
{
	/**
	 * Public constructor
	 */
	public QueryType()
	{
	}

	/**
	 * Track Query type
	 */
	public static class Track extends QueryType
	{
		/**
		 * Public constructor
		 */
		public Track()
		{
		}
	}

	/**
	 * Attribute Query type
	 */
	public static class Attribute extends QueryType
	{
		/**
		 * Public constructor
		 */
		public Attribute()
		{
		}
	}
}
