/***************************************************************************
    Copyright          : (C) 2002 by Neoworks Limited. All rights reserved
    URL                : http://www.neoworks.com
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*
 * TrackBatchGetter.java
 *
 * Created on 15 May 2002, 11:29
 */

package com.neoworks.jukex.sqlimpl;

import java.util.List;
import java.util.Map;

/**
 * Interface that allows a batch retrieval of tracks in order to atone for
 * the inherent slowness of retrieving their attributes from the database on a 
 * per track basis, resulting in a huge number of queries.
 *
 * @author Nick Vincent <a href="mailto:nick@neoworks.com>nick@neoworks.com</a>
 */
public interface BatchTrackLoader
{
	/**
	 * Retrieve the tracks with the ids that this loader has been told about.
	 *
	 * The function returns a <code>Map</code> of <code>Track</code> objects 
	 * keyed by Track ID.  The Track IDs themselves are <code>Long</code> 
	 * objects.
	 *
	 * @return A Map keyed by <code>Long</code> objects containing <code>Track</code> objects.
	 */
	public Map getTracks();
	
	/**
	 * Add a trackID to this batch for retrieval.
	 *
	 * Tracks are retrieved in the order in which the IDs are added.
	 *
	 * @param id The ID to add to the batch.
	 */
	public void addTrack( long id );
	
	/**
	 * Add all of the IDs from this list to the batch for retrieval
	 *
	 * The List specified must contain Long objects.  Any other objects will be
	 * ignored.
	 *
	 * @param idlist A <code>List</code> of <code>Long</code> objects representing
	 * the IDs of Tracks to add to the batch.
	 */
	public void addTracks( List idlist );
	
	/**
	 * Clear the IDs to retrieve
	 */
	public void reset();
}
