/***************************************************************************
    Copyright          : (C) 2002 by Neoworks Limited. All rights reserved
    URL                : http://www.neoworks.com
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*
 * TrackSourcePipelineElementSkeleton.java
 *
 * Created on 02 May 2002, 14:48
 */

package com.neoworks.jukex.tracksource;

import com.neoworks.jukex.query.*;

/**
 * Interface for PipelineElements that are defined by a query.
 *
 * @author Nigel Atkinson <a href="mailto:nigel@neoworks.com">nigel@neoworks.com</a>
 */
public interface SearchPipelineElement extends TrackSourcePipelineElement
{
	/**
	 * Set the query to perform
	 *
	 * @param q The Query
	 */
	public void setQuery(Query q);

	/** 
	 * Get the original JukeXQL query String
	 *
	 * @return The query String
	 */
	public String getQueryString();
}
