/***************************************************************************
    Copyright          : (C) 2002 by Neoworks Limited. All rights reserved
    URL                : http://www.neoworks.com
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

package com.neoworks.jukex.tracksource;

import com.neoworks.jukex.Track;

/**
 * Track source interface.  This is for classes which are able to offer Track
 * objects for playback.
 *
 * @author Nigel Atkinson (<a href="mailto:nigel@neoworks.com">nigel@neoworks.com</a>)
 * @version $Revision: 1.8 $
 */
public interface TrackSource
{
	/**
	 * Get the next track from the source.
	 *
	 * @return A Track object
	 */
	public Track getNextTrack();

	/**
	 * Get the name of this TrackSource
	 *
	 * @return A String identifying the TrackSource
	 */
	public String getName();

	/**
	 * Must implement cloning
	 */
	public abstract Object clone();

	/**
	 * Is this TrackSource enabled?
	 *
	 * @return Status
	 */
	public boolean isEnabled();
	
	/**
	 * Return a String summarising the configuration of the task the source is 
	 * performing
	 *
	 * @return A String
	 */
	public String getSummary();
	
	/**
	 * Return a String describing what, in general terms, this TrackSource does
	 *
	 * @return A String
	 */
	public String getDescription();
}
