/***************************************************************************
    Copyright          : (C) 2002 by Neoworks Limited. All rights reserved
    URL                : http://www.neoworks.com
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*
 * TrackSourcePipelineElement.java
 *
 * Created on 02 May 2002, 14:15
 */

package com.neoworks.jukex.tracksource;

import java.util.Map;
import java.util.List;
import java.sql.Connection;
import java.io.Serializable;

/**
 * An object which can be present in a pipeline of TrackSources.
 *
 * @author Nigel Atkinson (<a href="mailto:nigel@neoworks.com">nigel@neoworks.com</a>)
 * @author Nick Vincent (<a href="mailto:nick@neoworks.com">nick@neoworks.com</a>)
 */
public interface TrackSourcePipelineElement extends TrackSource, Serializable
{
	/**
	 * Tells this tracksource of a new link in the chain
	 * 
	 * @return The previous TrackSource
	 */
	public TrackSourcePipelineElement setNextTrackSource( TrackSourcePipelineElement next );

	/**
	 * Get the next TrackSourcePipelineElement
	 *
	 * @return The next TrackSourcePipelineElement
	 */
	public TrackSourcePipelineElement getNextTrackSource();

	/**
	 * Remove a Track from this PipelineElement
	 *
	 * @param index The index of the Track to remove
	 * @return Success
	 */
	public boolean removeTrack(int index);

	/**
	 * Peek at the next count tracks from this TrackSourcePipelineElement
	 *
	 * @param count The number of Tracks to peek ahead at
	 * @return A List of Track objects
	 */
	public List peekTracks(int count);

	/**
	 * Set which TrackSourcePipeline this PipelineElement is currently a part of
	 *
	 * @param pipe The TrackSourcePipeline to which you now belong
	 * @return The PipelineElement, to allow for chaining of calls
	 */
	public TrackSourcePipelineElement setOwner( TrackSourcePipeline pipe );

	/**
	 * Get the current state of this PipelineElement for persisting
	 *
	 * @return a String keyed Map of objects representing the state of 
	 * this PipelineElement, e.g. for a Playlist this would be information
	 * allowing the reconstruction of the current playlist queue.
	 */
	public Map getState();

	/**
	 * Load the configuration of this PipelineElement
	 *
	 * @param state a Map of values keyed by Strings representing the state of this PipelineElement.
	 * @return success
	 */
	public boolean setState( Map state );

	/**
	 * Persist the current state of the PipelineElement into the database
	 *
	 * @param conn The database connection to use, which must have AutoCommit disabled
	 * @return success
	 */
	public boolean storeState(Connection conn);

	/**
	 * Disable this element
	 */
	public void disable();

	/**
	 * Enable this element
	 */
	public void enable();
	
	/**
	 * Set the name of this element
	 * 
	 * @param name The name of this Pipeline Element
	 */
	public void setName(String name);
}
