/***************************************************************************
    Copyright          : (C) 2002 by Neoworks Limited. All rights reserved
    URL                : http://www.neoworks.com
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*
 * TrackSourcePipelineElementSkeleton.java
 *
 * Created on 02 May 2002, 14:48
 */

package com.neoworks.jukex.tracksource.filter;

import com.neoworks.jukex.Attribute;
import com.neoworks.jukex.AttributeValue;
import java.io.Serializable;

/**
 * Interface for Attribute based Track filters. This interface exists in case any
 * filters are created that do not use Attributes.
 *
 * @author Nigel Atkinson <a href="mailto:nigel@neoworks.com">nigel@neoworks.com</a>
 */
public interface AttributeTrackFilter extends TrackFilter
{
	/**
	 * Get the Attribute used for matching
	 *
	 * @return The Attribute
	 */
	public Attribute getAttribute();

	/**
	 * Get the AttributeValue to match against
	 *
	 * @return The AttributeValue
	 */
	public AttributeValue getValue();
}
