/***************************************************************************
    Copyright          : (C) 2002 by Neoworks Limited. All rights reserved
    URL                : http://www.neoworks.com
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*
 * TrackSourcePipelineElementSkeleton.java
 *
 * Created on 02 May 2002, 14:48
 */

package com.neoworks.jukex.tracksource.filter;

import com.neoworks.jukex.Track;
import java.io.Serializable;

/**
 * Interface for Track filters
 *
 * @author Nigel Atkinson <a href="mailto:nigel@neoworks.com">nigel@neoworks.com</a>
 */
public interface TrackFilter extends Serializable
{
	/**
	 * Check whether a Track matches this filter
	 *
	 * @param t The Track to check for a match
	 * @return Whether the Track matches
	 */
	public boolean match(Track t);

	/**
	 * Get a String description of the comparator being used by this filter
	 */
	public String getComparatorDescription();
}
